/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.units.PrefixSet;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitTransform;

final class DMSUnit
extends Unit {
    private static final Unit DEGREE = Unit.DEGREE;
    private final int divider;

    public DMSUnit(int divider) {
        super(DMSUnit.getSymbol(divider), null);
        this.divider = divider;
    }

    private static String getSymbol(int divider) {
        switch (divider) {
            case 1: {
                return "DMS";
            }
            case 10000: {
                return "D.MS";
            }
        }
        throw new IllegalArgumentException(String.valueOf(divider));
    }

    public boolean canConvert(Unit that) {
        return DEGREE.canConvert(that);
    }

    public double convert(double value, Unit fromUnit) throws UnitException {
        value = DEGREE.convert(value, fromUnit);
        int deg = (int)value;
        value = (value - (double)deg) * 60.0;
        int min = (int)value;
        value = (value - (double)min) * 60.0;
        int sec = (int)value;
        return ((double)((deg * 100 + min) * 100 + sec) + value) / (double)this.divider;
    }

    public void convert(double[] values, Unit fromUnit) throws UnitException {
        DEGREE.convert(values, fromUnit);
        int i = 0;
        while (i < values.length) {
            double value = values[i];
            int deg = (int)value;
            value = (value - (double)deg) * 60.0;
            int min = (int)value;
            value = (value - (double)min) * 60.0;
            int sec = (int)value;
            values[i] = ((double)((deg * 100 + min) * 100 + sec) + value) / (double)this.divider;
            ++i;
        }
    }

    public void convert(float[] values, Unit fromUnit) throws UnitException {
        DEGREE.convert(values, fromUnit);
        int i = 0;
        while (i < values.length) {
            float value = values[i];
            int deg = (int)value;
            value = (value - (float)deg) * 60.0f;
            int min = (int)value;
            value = (value - (float)min) * 60.0f;
            int sec = (int)value;
            values[i] = ((float)((deg * 100 + min) * 100 + sec) + value) / (float)this.divider;
            ++i;
        }
    }

    double inverseConvert(double value, Unit toUnit) throws UnitException {
        int deg = (int)((value *= (double)this.divider) / 10000.0);
        int min = (int)((value -= (double)(10000 * deg)) / 100.0);
        value -= (double)(100 * min);
        if (min <= -60 || min >= 60) {
            throw new UnitException("Invalid minutes: " + min);
        }
        if (value <= -60.0 || value >= 60.0) {
            throw new UnitException("Invalid secondes: " + value);
        }
        value = (value / 60.0 + (double)min) / 60.0 + (double)deg;
        return DEGREE.inverseConvert(value, toUnit);
    }

    void inverseConvert(double[] values, Unit toUnit) throws UnitException {
        int i = 0;
        while (i < values.length) {
            double value = values[i] * (double)this.divider;
            int deg = (int)(value / 10000.0);
            int min = (int)((value -= (double)(10000 * deg)) / 100.0);
            value -= (double)(100 * min);
            if (min <= -60 || min >= 60) {
                throw new UnitException("Invalid minutes: " + min);
            }
            if (value <= -60.0 || value >= 60.0) {
                throw new UnitException("Invalid secondes: " + value);
            }
            values[i] = (value / 60.0 + (double)min) / 60.0 + (double)deg;
            ++i;
        }
        DEGREE.inverseConvert(values, toUnit);
    }

    void inverseConvert(float[] values, Unit toUnit) throws UnitException {
        int i = 0;
        while (i < values.length) {
            float value = values[i] * (float)this.divider;
            int deg = (int)(value / 10000.0f);
            int min = (int)((value -= (float)(10000 * deg)) / 100.0f);
            value -= (float)(100 * min);
            if (min <= -60 || min >= 60) {
                throw new UnitException("Invalid minutes: " + min);
            }
            if (value <= -60.0f || value >= 60.0f) {
                throw new UnitException("Invalid secondes: " + value);
            }
            values[i] = (value / 60.0f + (float)min) / 60.0f + (float)deg;
            ++i;
        }
        DEGREE.inverseConvert(values, toUnit);
    }

    public UnitTransform getTransform(Unit fromUnit) throws UnitException {
        throw new UnitException("Not implemented");
    }

    UnitTransform getInverseTransform(Unit toUnit) throws UnitException {
        throw new UnitException("Not implemented");
    }

    public Unit scale(double amount) {
        throw new UnitException("Not implemented");
    }

    public Unit shift(double offset) {
        throw new UnitException("Not implemented");
    }

    public String getQuantityName() {
        return null;
    }

    boolean equalsIgnoreSymbol(Unit unit) {
        return unit instanceof DMSUnit && ((DMSUnit)unit).divider == this.divider;
    }

    public Unit rename(String symbol, PrefixSet prefix) {
        throw new UnitException("Not implemented");
    }

    public int hashCode() {
        return 457829627 + this.divider;
    }
}

