/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.text.ChoiceFormat;
import org.geotools.resources.Utilities;
import org.geotools.resources.rsc.Resources;

public final class XMath {
    public static final double LN10 = 2.302585092994046;
    private static final double[] POW10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    private XMath() {
    }

    public static double cbrt(double x) {
        return Math.pow(x, 0.3333333333333333);
    }

    public static double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double log10(double x) {
        return Math.log(x) / 2.302585092994046;
    }

    public static double pow10(double x) {
        int ix = (int)x;
        if ((double)ix == x) {
            return XMath.pow10(ix);
        }
        return Math.pow(10.0, x);
    }

    public static double pow10(int x) {
        int nx;
        if (x >= 0) {
            if (x < POW10.length) {
                return POW10[x];
            }
        } else if (x != Integer.MIN_VALUE && (nx = -x) < POW10.length) {
            return 1.0 / POW10[nx];
        }
        try {
            return Double.parseDouble("1E" + x);
        }
        catch (NumberFormatException exception) {
            return StrictMath.pow(10.0, x);
        }
    }

    public static int sgn(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int sgn(float x) {
        if (x > 0.0f) {
            return 1;
        }
        if (x < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static int sgn(long x) {
        if (x > 0L) {
            return 1;
        }
        if (x < 0L) {
            return -1;
        }
        return 0;
    }

    public static int sgn(int x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static short sgn(short x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static byte sgn(byte x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static double round(double value, int flu) {
        double target = Math.rint(value);
        if (value != target) {
            boolean pos = value < target;
            double candidate = value;
            while (--flu >= 0) {
                double d = candidate = pos ? XMath.next(candidate) : XMath.previous(candidate);
                if (candidate != target) continue;
                return target;
            }
        }
        return value;
    }

    private static float next(float f, boolean positive) {
        int SIGN = Integer.MIN_VALUE;
        int POSITIVEINFINITY = 2139095040;
        if (Float.isNaN(f)) {
            return f;
        }
        if (f == 0.0f) {
            float smallestPositiveFloat = Float.intBitsToFloat(1);
            return positive ? smallestPositiveFloat : -smallestPositiveFloat;
        }
        int bits = Float.floatToIntBits(f);
        int magnitude = bits & Integer.MAX_VALUE;
        if (bits > 0 == positive) {
            if (magnitude != 2139095040) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        int signbit = bits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitude | signbit);
    }

    public static float next(float f) {
        return XMath.next(f, true);
    }

    public static float previous(float f) {
        return XMath.next(f, false);
    }

    public static double next(double f) {
        return ChoiceFormat.nextDouble(f);
    }

    public static double previous(double f) {
        return ChoiceFormat.previousDouble(f);
    }

    public static double rool(Class type, double value, int amount) throws IllegalArgumentException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(type)) {
            if (amount < 0) {
                do {
                    value = XMath.previous(value);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    value = XMath.next(value);
                } while (--amount != 0);
            }
            return value;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(type)) {
            float vf = (float)value;
            if (amount < 0) {
                do {
                    vf = XMath.previous(vf);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    vf = XMath.next(vf);
                } while (--amount != 0);
            }
            return vf;
        }
        if (XMath.isInteger(type)) {
            return value + (double)amount;
        }
        throw new IllegalArgumentException(Resources.format(21, Utilities.getShortName(type)));
    }

    public static boolean isReal(Class type) {
        block13: {
            block12: {
                Class<?> clazz;
                block11: {
                    if (type == null) break block11;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.isAssignableFrom(type)) break block12;
                }
                if ((clazz = class$1) == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(type)) break block13;
            }
            return true;
        }
        return false;
    }

    public static boolean isInteger(Class type) {
        block21: {
            block20: {
                Class<?> clazz;
                block19: {
                    if (type == null) break block19;
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$2 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.isAssignableFrom(type)) break block20;
                }
                if ((clazz = class$3) == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(type)) break block20;
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.isAssignableFrom(type)) break block20;
                Class<?> clazz4 = class$5;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$5 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz4.isAssignableFrom(type)) break block21;
            }
            return true;
        }
        return false;
    }

    public static int getBitCount(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(type)) {
            return 64;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(type)) {
            return 32;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(type)) {
            return 64;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.isAssignableFrom(type)) {
            return 32;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz5.isAssignableFrom(type)) {
            return 16;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz6.isAssignableFrom(type)) {
            return 8;
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz7.isAssignableFrom(type)) {
            return 16;
        }
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz8.isAssignableFrom(type)) {
            return 1;
        }
        return 0;
    }

    public static Class primitiveToWrapper(Class type) {
        if (Character.TYPE.equals(type)) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Boolean.TYPE.equals(type)) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Byte.TYPE.equals(type)) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Short.TYPE.equals(type)) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Integer.TYPE.equals(type)) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Long.TYPE.equals(type)) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Float.TYPE.equals(type)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (Double.TYPE.equals(type)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return type;
    }
}

