/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.resources.XMath;

public abstract class XAffineTransform
extends AffineTransform {
    private static final long serialVersionUID = 5215291166450556451L;
    private static final double EPS = 1.0E-6;

    protected XAffineTransform(AffineTransform tr) {
        super(tr);
    }

    protected abstract void checkPermission();

    public void translate(double tx, double ty) {
        this.checkPermission();
        super.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.checkPermission();
        super.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.checkPermission();
        super.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.checkPermission();
        super.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.checkPermission();
        super.shear(shx, shy);
    }

    public void setToIdentity() {
        this.checkPermission();
        super.setToIdentity();
    }

    public void setToTranslation(double tx, double ty) {
        this.checkPermission();
        super.setToTranslation(tx, ty);
    }

    public void setToRotation(double theta) {
        this.checkPermission();
        super.setToRotation(theta);
    }

    public void setToRotation(double theta, double x, double y) {
        this.checkPermission();
        super.setToRotation(theta, x, y);
    }

    public void setToScale(double sx, double sy) {
        this.checkPermission();
        super.setToScale(sx, sy);
    }

    public void setToShear(double shx, double shy) {
        this.checkPermission();
        super.setToShear(shx, shy);
    }

    public void setTransform(AffineTransform Tx) {
        this.checkPermission();
        super.setTransform(Tx);
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.checkPermission();
        super.setTransform(m00, m10, m01, m11, m02, m12);
    }

    public void concatenate(AffineTransform Tx) {
        this.checkPermission();
        super.concatenate(Tx);
    }

    public void preConcatenate(AffineTransform Tx) {
        this.checkPermission();
        super.preConcatenate(Tx);
    }

    public static Rectangle2D transform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        int i = 0;
        while (i < 4) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static Rectangle2D inverseTransform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) throws NoninvertibleTransformException {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        int i = 0;
        while (i < 4) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.inverseTransform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static Point2D inverseDeltaTransform(AffineTransform transform, Point2D source, Point2D dest) throws NoninvertibleTransformException {
        double m10;
        double m01;
        double m11;
        double m00 = transform.getScaleX();
        double det = m00 * (m11 = transform.getScaleY()) - (m01 = transform.getShearX()) * (m10 = transform.getShearY());
        if (!(Math.abs(det) > Double.MIN_VALUE)) {
            return transform.createInverse().deltaTransform(source, dest);
        }
        double x = source.getX();
        double y = source.getY();
        if (dest != null) {
            dest.setLocation((x * m11 - y * m01) / det, (y * m00 - x * m10) / det);
            return dest;
        }
        return new Point2D.Double((x * m11 - y * m01) / det, (y * m00 - x * m10) / det);
    }

    public static double getScaleX0(AffineTransform zoom) {
        return XMath.hypot(zoom.getScaleX(), zoom.getShearX());
    }

    public static double getScaleY0(AffineTransform zoom) {
        return XMath.hypot(zoom.getScaleY(), zoom.getShearY());
    }

    public static double getScale(AffineTransform zoom) {
        return 0.5 * (XAffineTransform.getScaleX0(zoom) + XAffineTransform.getScaleY0(zoom));
    }

    public static AffineTransform getScaleInstance(double sx, double sy, double x, double y) {
        return new AffineTransform(sx, 0.0, 0.0, sy, (1.0 - sx) * x, (1.0 - sy) * y);
    }

    public static void round(AffineTransform zoom) {
        double d;
        double r = zoom.getScaleX();
        double m00 = Math.rint(r);
        if (Math.abs(d - r) <= 1.0E-6) {
            double d2;
            r = zoom.getShearX();
            double m01 = Math.rint(r);
            if (Math.abs(d2 - r) <= 1.0E-6) {
                double d3;
                r = zoom.getScaleY();
                double m11 = Math.rint(r);
                if (Math.abs(d3 - r) <= 1.0E-6) {
                    double d4;
                    r = zoom.getShearY();
                    double m10 = Math.rint(r);
                    if (!(!(Math.abs(d4 - r) <= 1.0E-6) || m00 == 0.0 && m01 == 0.0 || m10 == 0.0 && m11 == 0.0)) {
                        double m12;
                        r = zoom.getTranslateX();
                        double m02 = Math.rint(r);
                        if (!(Math.abs(m02 - r) <= 1.0E-6)) {
                            m02 = r;
                        }
                        if (!(Math.abs((m12 = Math.rint(r = zoom.getTranslateY())) - r) <= 1.0E-6)) {
                            m12 = r;
                        }
                        zoom.setTransform(m00, m10, m01, m11, m02, m12);
                    }
                }
            }
        }
    }
}

