/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.geotools.resources.XMath;

final class ResourceCompiler
implements Comparator {
    private static final String[] ORDER = new String[]{"WARNING_", "ERROR_"};
    private static final String CLASS_NAME = "ResourceKeys";
    private static final String PROPERTIES_EXT = ".properties";
    private static final String RESOURCES_EXT = ".utf";
    private static final String ARGUMENT_COUNT_PREFIX = "_$";
    private final Map allocatedIDs = new HashMap();
    private final Map resources = new HashMap();

    private ResourceCompiler(File directory) throws IOException {
        try {
            String classname = ResourceCompiler.toRelative(new File(directory, CLASS_NAME));
            classname = classname.replace(File.separatorChar, '.');
            AccessibleObject[] fields = Class.forName(classname).getFields();
            System.out.print("Loading ");
            System.out.println(classname);
            Field.setAccessible(fields, true);
            int i = fields.length;
            while (--i >= 0) {
                AccessibleObject field = fields[i];
                String key = ((Field)field).getName();
                try {
                    Object ID = ((Field)field).get(null);
                    if (!(ID instanceof Integer)) continue;
                    this.allocatedIDs.put((Integer)ID, key);
                }
                catch (IllegalAccessException exception) {
                    ResourceCompiler.warning(ResourceCompiler.toSourceFile(classname), key, "Access denied", exception);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void scanForResources(File directory) throws IOException {
        ResourceCompiler compiler = null;
        File[] content = directory.listFiles();
        int i = 0;
        while (i < content.length) {
            File file = content[i];
            if (file.isDirectory()) {
                ResourceCompiler.scanForResources(file);
            } else if (file.getName().endsWith(PROPERTIES_EXT)) {
                if (compiler == null) {
                    compiler = new ResourceCompiler(directory);
                }
                compiler.loadPropertyFile(file);
                String path = file.getPath();
                path = String.valueOf(path.substring(0, path.length() - PROPERTIES_EXT.length())) + RESOURCES_EXT;
                compiler.writeUTFFile(new File(path));
            }
            ++i;
        }
        if (compiler != null) {
            super.writeJavaSource(new File(directory, "ResourceKeys.java"));
        }
    }

    private void loadPropertyFile(File file) throws IOException {
        String key;
        FileInputStream input = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(input);
        ((InputStream)input).close();
        this.resources.clear();
        Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            int argumentCount;
            MessageFormat message;
            Map.Entry<Object, Object> entry = it.next();
            String key2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key2.trim().length() == 0) {
                ResourceCompiler.warning(file, key2, "Empty key.", null);
                continue;
            }
            if (value.trim().length() == 0) {
                ResourceCompiler.warning(file, key2, "Empty value.", null);
                continue;
            }
            try {
                message = new MessageFormat(ResourceCompiler.toMessageFormatString(value));
            }
            catch (IllegalArgumentException exception) {
                ResourceCompiler.warning(file, key2, "Bad resource value", exception);
                continue;
            }
            int index = key2.lastIndexOf(ARGUMENT_COUNT_PREFIX);
            if (index < 0) {
                argumentCount = 0;
                this.resources.put(key2, value);
            } else {
                try {
                    String suffix = key2.substring(index + ARGUMENT_COUNT_PREFIX.length());
                    argumentCount = Integer.parseInt(suffix);
                    this.resources.put(key2, message.toPattern());
                }
                catch (NumberFormatException exception) {
                    ResourceCompiler.warning(file, key2, "Bad number in resource key", exception);
                    continue;
                }
            }
            int expected = message.getFormats().length;
            if (argumentCount == expected) continue;
            String suffix = ARGUMENT_COUNT_PREFIX + expected;
            ResourceCompiler.warning(file, key2, "Key name should ends with \"" + suffix + "\".", null);
        }
        if (!this.allocatedIDs.isEmpty()) {
            Iterator it2;
            HashSet missing = new HashSet(this.allocatedIDs.values());
            missing.removeAll(this.resources.keySet());
            String filename = file.getName();
            if (filename.indexOf(95) == filename.lastIndexOf(95)) {
                it2 = missing.iterator();
                while (it2.hasNext()) {
                    key = (String)it2.next();
                    ResourceCompiler.warning(file, key, "Key defined in previous languages is missing in current one.", null);
                }
            }
            missing.clear();
            missing.addAll(this.resources.keySet());
            missing.removeAll(this.allocatedIDs.values());
            it2 = missing.iterator();
            while (it2.hasNext()) {
                key = (String)it2.next();
                ResourceCompiler.warning(file, key, "Key was not defined in previous languages.", null);
            }
        }
        String[] keys = this.resources.keySet().toArray(new String[this.resources.size()]);
        Arrays.sort(keys, this);
        int freeID = 0;
        int i = 0;
        while (i < keys.length) {
            key = keys[i];
            if (!this.allocatedIDs.containsValue(key)) {
                Integer ID;
                while (this.allocatedIDs.containsKey(ID = new Integer(freeID++))) {
                }
                this.allocatedIDs.put(ID, key);
            }
            ++i;
        }
    }

    private void writeUTFFile(File file) throws IOException {
        int count = this.allocatedIDs.isEmpty() ? 0 : (Integer)Collections.max(this.allocatedIDs.keySet()) + 1;
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.writeInt(count);
        int i = 0;
        while (i < count) {
            String value = (String)this.resources.get(this.allocatedIDs.get(new Integer(i)));
            out.writeUTF(value != null ? value : "");
            ++i;
        }
        out.close();
    }

    private static File toSourceFile(String classname) {
        return new File(String.valueOf(classname.replace('.', '/')) + ".java");
    }

    private static String toClassName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    private static String toRelative(File path) throws IOException {
        String bestpath = null;
        String absolutePath = path.getCanonicalPath();
        String fileSeparator = System.getProperty("file.separator", "/");
        StringTokenizer tokr = new StringTokenizer(System.getProperty("java.class.path", "."), System.getProperty("path.separator", ":"));
        while (tokr.hasMoreTokens()) {
            String classpath = new File(tokr.nextToken()).getCanonicalPath();
            if (!classpath.endsWith(fileSeparator)) {
                classpath = String.valueOf(classpath) + fileSeparator;
            }
            if (!absolutePath.startsWith(classpath)) continue;
            String candidate = absolutePath.substring(classpath.length());
            if (bestpath != null && bestpath.length() <= candidate.length()) continue;
            bestpath = candidate;
        }
        return bestpath != null ? bestpath : path.getPath();
    }

    private static String toMessageFormatString(String text) {
        int level = 0;
        int last = -1;
        StringBuffer buffer = new StringBuffer(text);
        int i = 0;
        while (i < buffer.length()) {
            block0 : switch (buffer.charAt(i)) {
                case '{': {
                    ++level;
                    last = i;
                    break;
                }
                case '}': {
                    --level;
                    last = i;
                    break;
                }
                case '\'': {
                    if (i + 2 < buffer.length() && buffer.charAt(i + 2) == '\'') {
                        switch (buffer.charAt(i + 1)) {
                            case '{': {
                                i += 2;
                                break block0;
                            }
                            case '}': {
                                i += 2;
                                break block0;
                            }
                        }
                    }
                    if (level <= 0) {
                        buffer.insert(i++, '\'');
                        break;
                    }
                    if (last < 0 || buffer.charAt(last) != '{') break;
                    int scan = last;
                    while (scan < i) {
                        if (Character.isDigit(buffer.charAt(++scan))) continue;
                        String choice = ",choice,";
                        int end = scan + ",choice,".length();
                        if (end >= buffer.length() || !buffer.substring(scan, end).equalsIgnoreCase(",choice,")) break block0;
                        buffer.insert(i++, '\'');
                        break block0;
                    }
                    break;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static void warning(File file, String key, String message, Exception exception) {
        System.out.flush();
        System.err.print("ERROR ");
        if (file != null) {
            String filename = file.getPath();
            if (filename.endsWith(PROPERTIES_EXT)) {
                filename = filename.substring(0, filename.length() - PROPERTIES_EXT.length());
            }
            System.err.print('(');
            System.err.print(filename);
            System.err.print(')');
        }
        System.err.print(": ");
        if (key != null) {
            System.err.print('\"');
            System.err.print(key);
            System.err.print('\"');
        }
        System.err.println();
        System.err.print(message);
        if (exception != null) {
            System.err.print(": ");
            System.err.print(exception.getLocalizedMessage());
        }
        System.err.println();
        System.err.println();
        System.err.flush();
    }

    private static void writeWhiteSpaces(Writer out, int count) throws IOException {
        while (--count >= 0) {
            out.write(32);
        }
    }

    private void writeJavaSource(File file) throws IOException {
        String packageName = ResourceCompiler.toRelative(file.getParentFile()).replace(File.separatorChar, '.');
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write("/*\n * Geotools - OpenSource mapping toolkit\n * (C) 2003, Geotools Project Managment Committee (PMC)\n *\n *     THIS IS AN AUTOMATICALLY GENERATED FILE. DO NOT EDIT!\n *     Generated with: org.geotools.resources.ResourceCompiler\n */\n");
        out.write("package ");
        out.write(packageName);
        out.write(";\n\n\n");
        out.write("/**\n * Resource keys. This interface is used when compiling sources, but\n * no dependencies to <code>ResourceKeys</code> should appear in any\n * resulting class files.  Since Java compiler inlines final integer\n * values, using long identifiers will not bloat constant pools of\n * classes compiled against the interface, provided that no class\n * implements this interface.\n *\n * @see org.geotools.resources.ResourceBundle\n * @see org.geotools.resources.ResourceCompiler\n */\n");
        out.write("public interface ");
        out.write(ResourceCompiler.toClassName(file));
        out.write("\n{\n");
        Map.Entry[] entries = this.allocatedIDs.entrySet().toArray(new Map.Entry[this.allocatedIDs.size()]);
        Arrays.sort(entries, this);
        int maxLength = 0;
        int i = entries.length;
        while (--i >= 0) {
            int length = ((String)entries[i].getValue()).length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        i = 0;
        while (i < entries.length) {
            String key = (String)entries[i].getValue();
            String ID = entries[i].getKey().toString();
            if (i != 0 && this.compare(entries[i - 1], key) < -1) {
                out.write(10);
            }
            ResourceCompiler.writeWhiteSpaces(out, 4);
            out.write("public static final int ");
            out.write(key);
            ResourceCompiler.writeWhiteSpaces(out, maxLength - key.length());
            out.write(" = ");
            ResourceCompiler.writeWhiteSpaces(out, 5 - ID.length());
            out.write(ID);
            out.write(";\n");
            ++i;
        }
        out.write("}\n");
        out.close();
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Map.Entry) {
            o1 = ((Map.Entry)o1).getValue();
        }
        if (o2 instanceof Map.Entry) {
            o2 = ((Map.Entry)o2).getValue();
        }
        String key1 = (String)o1;
        String key2 = (String)o2;
        int i1 = ORDER.length;
        while (--i1 >= 0) {
            if (key1.startsWith(ORDER[i1])) break;
        }
        int i2 = ORDER.length;
        while (--i2 >= 0) {
            if (key2.startsWith(ORDER[i2])) break;
        }
        if (i1 < i2) {
            return -2;
        }
        if (i1 > i2) {
            return 2;
        }
        return XMath.sgn(key1.compareTo(key2));
    }

    public static void main(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            ResourceCompiler.scanForResources(new File(args[i]));
            ++i;
        }
    }
}

