/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;

public class ResourceBundle
extends java.util.ResourceBundle {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.resources");
    private static final int MAX_STRING_LENGTH = 80;
    private final String filename;
    private String[] values;
    private transient MessageFormat format;
    private transient int lastKey;

    protected ResourceBundle(String filename) {
        this.filename = filename;
    }

    private String getPackageName() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        return index >= 0 ? name.substring(0, index) : "org.geotools";
    }

    public final void list(Writer out) throws IOException {
        ResourceBundle.list(out, this.ensureLoaded(null));
    }

    private static void list(Writer out, String[] values) throws IOException {
        String lineSeparator = System.getProperty("line.separator", "\n");
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (value != null) {
                int indexLF;
                int indexCR = value.indexOf(13);
                if (indexCR < 0) {
                    indexCR = value.length();
                }
                if ((indexLF = value.indexOf(10)) < 0) {
                    indexLF = value.length();
                }
                String number = String.valueOf(i);
                out.write(Utilities.spaces(5 - number.length()));
                out.write(number);
                out.write(":\t");
                out.write(value.substring(0, Math.min(indexCR, indexLF)));
                out.write(lineSeparator);
            }
            ++i;
        }
    }

    private String[] ensureLoaded(String key) throws MissingResourceException {
        LogRecord record = null;
        try {
            String[] values;
            ResourceBundle resourceBundle = this;
            synchronized (resourceBundle) {
                values = this.values;
                if (values != null) {
                    return values;
                }
                record = new LogRecord(Level.FINER, "Loaded resources for {0} from bundle \"{1}\".");
                record.setSourceClassName(this.getClass().getName());
                record.setSourceMethodName(key != null ? "getObject" : "getKeys");
                InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.filename);
                if (in == null) {
                    throw new FileNotFoundException(this.filename);
                }
                DataInputStream input = new DataInputStream(new BufferedInputStream(in));
                values = new String[input.readInt()];
                this.values = values;
                int i = 0;
                while (i < values.length) {
                    values[i] = input.readUTF();
                    if (values[i].length() == 0) {
                        values[i] = null;
                    }
                    ++i;
                }
                input.close();
                String language = this.getLocale().getDisplayName(Locale.US);
                if (language == null || language.length() == 0) {
                    language = "<default>";
                }
                record.setParameters(new String[]{language, this.getPackageName()});
            }
            LOGGER.log(record);
            return values;
        }
        catch (IOException exception) {
            record.setLevel(Level.WARNING);
            record.setMessage(exception.getLocalizedMessage());
            record.setThrown(exception);
            LOGGER.log(record);
            MissingResourceException error = new MissingResourceException(exception.getLocalizedMessage(), this.getClass().getName(), key);
            error.initCause(exception);
            throw error;
        }
    }

    public final Enumeration getKeys() {
        final String[] values = this.ensureLoaded(null);
        return new Enumeration(){
            private int i = 0;

            public boolean hasMoreElements() {
                while (this.i < values.length) {
                    if (values[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            public Object nextElement() {
                while (true) {
                    if (this.i >= values.length) {
                        throw new NoSuchElementException();
                    }
                    if (values[this.i] != null) {
                        return String.valueOf(this.i++);
                    }
                    ++this.i;
                }
            }
        };
    }

    protected final Object handleGetObject(String key) {
        int keyID;
        String[] values = this.ensureLoaded(key);
        try {
            keyID = Integer.parseInt(key);
        }
        catch (NumberFormatException exception) {
            return null;
        }
        return keyID >= 0 && keyID < values.length ? values[keyID] : null;
    }

    private static String summarize(String text, int maxLength) {
        int length = (text = text.trim()).length();
        if (length <= maxLength) {
            return text;
        }
        if ((maxLength = maxLength - 7 >> 1) <= 0) {
            return text;
        }
        int break1 = maxLength;
        int break2 = length - maxLength;
        int lower = maxLength >> 1;
        while (break1 >= lower) {
            if (!Character.isUnicodeIdentifierPart(text.charAt(break1))) {
                while (--break1 >= lower && !Character.isUnicodeIdentifierPart(text.charAt(break1))) {
                }
                break;
            }
            --break1;
        }
        int upper = length - (maxLength >> 1);
        while (break2 < upper) {
            if (!Character.isUnicodeIdentifierPart(text.charAt(break2))) {
                while (++break2 < upper && !Character.isUnicodeIdentifierPart(text.charAt(break2))) {
                }
                break;
            }
            ++break2;
        }
        return (String.valueOf(text.substring(0, break1 + 1)) + " (...) " + text.substring(break2)).trim();
    }

    private static Object[] toArray(Object arguments) {
        Object[] array = arguments instanceof Object[] ? (Object[])arguments : new Object[]{arguments};
        int i = 0;
        while (i < array.length) {
            String s1;
            String s0;
            if (array[i] instanceof CharSequence && (s0 = array[i].toString()) != (s1 = ResourceBundle.summarize(s0, 80)) && !s0.equals(s1)) {
                if (array == arguments) {
                    array = new Object[array.length];
                    System.arraycopy(arguments, 0, array, 0, array.length);
                }
                array[i] = s1;
            }
            ++i;
        }
        return array;
    }

    public final String getMenuLabel(int keyID) throws MissingResourceException {
        return String.valueOf(this.getString(keyID)) + "...";
    }

    public final String getLabel(int keyID) throws MissingResourceException {
        return String.valueOf(this.getString(keyID)) + ": ";
    }

    public final String getString(int keyID) throws MissingResourceException {
        return this.getString(String.valueOf(keyID));
    }

    public final String getString(int keyID, Object arg0) throws MissingResourceException {
        Object object = this.getObject(String.valueOf(keyID));
        Object[] arguments = ResourceBundle.toArray(arg0);
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            if (this.format == null) {
                Locale locale = Locale.getDefault();
                Locale resourceLocale = this.getLocale();
                if (!locale.getLanguage().equalsIgnoreCase(resourceLocale.getLanguage())) {
                    locale = resourceLocale;
                }
                this.format = new MessageFormat(object.toString(), locale);
            } else if (keyID != this.lastKey) {
                this.format.applyPattern(object.toString());
                this.lastKey = keyID;
            }
            return this.format.format(arguments);
        }
    }

    public final String getString(int keyID, Object arg0, Object arg1) throws MissingResourceException {
        return this.getString(keyID, new Object[]{arg0, arg1});
    }

    public final String getString(int keyID, Object arg0, Object arg1, Object arg2) throws MissingResourceException {
        return this.getString(keyID, new Object[]{arg0, arg1, arg2});
    }

    public final String getString(int keyID, Object arg0, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        return this.getString(keyID, new Object[]{arg0, arg1, arg2, arg3});
    }

    public final String getString(int keyID, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) throws MissingResourceException {
        return this.getString(keyID, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public LogRecord getLogRecord(Level level, int key) {
        return this.getLogRecord(level, key, null);
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0) {
        LogRecord record = new LogRecord(level, String.valueOf(key));
        record.setResourceBundle(this);
        if (arg0 != null) {
            record.setParameters(ResourceBundle.toArray(arg0));
        }
        return record;
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0, Object arg1) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1});
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0, Object arg1, Object arg2) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1, arg2});
    }

    public LogRecord getLogRecord(Level level, int key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getLogRecord(level, key, new Object[]{arg0, arg1, arg2, arg3});
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        if (this.values != null) {
            int count = 0;
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] != null) {
                    ++count;
                }
                ++i;
            }
            buffer.append(count);
            buffer.append(" values");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

