/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.prefs.Preferences;
import org.geotools.io.LineWriter;
import org.geotools.resources.Utilities;

public class Log4JFormatter
extends Formatter {
    private static final String PREFIX = "[";
    private static final String SUFFIX = "] ";
    private static long startMillis;
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final int margin;
    private final String base;
    private final StringBuffer buffer;
    private final LineWriter writer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Log4JFormatter(String base) {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.base = base.trim();
        this.margin = Log4JFormatter.getHeaderWidth();
        startMillis = System.currentTimeMillis();
        StringWriter str = new StringWriter();
        this.writer = new LineWriter(str);
        this.buffer = str.getBuffer();
    }

    public synchronized String format(LogRecord record) {
        String logger = record.getLoggerName();
        String recordLevel = record.getLevel().getLocalizedName();
        try {
            this.buffer.setLength(1);
            Long millis = new Long(record.getMillis() - startMillis);
            this.writer.write(millis.toString());
            this.writer.write(" ");
            this.writer.write(PREFIX);
            this.writer.write(recordLevel);
            this.writer.write(SUFFIX);
            this.writer.write(record.getSourceClassName());
            this.writer.write(" - ");
            this.writer.setLineSeparator(this.bodyLineSeparator);
            this.writer.write(this.formatMessage(record));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    public static void init(String base, Level filterLevel) {
        Logger logger;
        Log4JFormatter log4j = null;
        Logger parent = logger = Logger.getLogger(base);
        while (parent.getUseParentHandlers()) {
            if ((parent = parent.getParent()) == null) break;
            Handler[] handlers = parent.getHandlers();
            int i = 0;
            while (i < handlers.length) {
                Handler handler = handlers[i];
                Class<?> clazz = handler.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.util.logging.ConsoleHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    Formatter formatter = handler.getFormatter();
                    Class<?> clazz3 = formatter.getClass();
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = Class.forName("java.util.logging.SimpleFormatter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz3.equals(clazz4)) {
                        if (log4j == null) {
                            log4j = new Log4JFormatter(base);
                        }
                        try {
                            handler = new Stdout(handler, (Formatter)log4j);
                            handler.setLevel(filterLevel);
                        }
                        catch (UnsupportedEncodingException exception) {
                            Log4JFormatter.unexpectedException(exception);
                        }
                        catch (SecurityException exception) {
                            Log4JFormatter.unexpectedException(exception);
                        }
                    }
                }
                logger.addHandler(handler);
                logger.setLevel(filterLevel);
                ++i;
            }
        }
        logger.setUseParentHandlers(false);
    }

    private static void unexpectedException(Exception e) {
        Utilities.unexpectedException("org.geotools.resources", "GeotoolsHandler", "init", e);
    }

    private static int getHeaderWidth() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.geotools.resources.Log4JFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Preferences.userNodeForPackage(clazz).getInt("logging.header", 15);
    }

    static void setHeaderWidth(int margin) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.geotools.resources.Log4JFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences.userNodeForPackage(clazz).putInt("logging.header", margin);
    }

    private static final class Stdout
    extends StreamHandler {
        public Stdout(Handler handler, Formatter formatter) throws UnsupportedEncodingException {
            super(System.out, formatter);
            this.setErrorManager(handler.getErrorManager());
            this.setFilter(handler.getFilter());
            this.setLevel(handler.getLevel());
            this.setEncoding(handler.getEncoding());
        }

        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        public void close() {
            this.flush();
        }
    }
}

