/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import org.geotools.resources.XMath;

public final class Geometry {
    private static final double EPS = 1.0E-6;
    public static final int PARALLEL = 0;
    public static final int HORIZONTAL = 1;

    private Geometry() {
    }

    public static Point2D intersectionPoint(Line2D a, Line2D b) {
        return Geometry.intersectionPoint(a.getX1(), a.getY1(), a.getX2(), a.getY2(), b.getX1(), b.getY1(), b.getX2(), b.getY2());
    }

    public static Point2D intersectionPoint(double ax1, double ay1, double ax2, double ay2, double bx1, double by1, double bx2, double by2) {
        double x = (ay2 -= ay1) * (bx2 -= bx1);
        double y = (ax2 -= ax1) * (by2 -= by1);
        x = ((by1 - ay1) * (ax2 * bx2) + x * ax1 - y * bx1) / (x - y);
        double d = y = Math.abs(bx2) > Math.abs(ax2) ? by2 / bx2 * (x - bx1) + by1 : ay2 / ax2 * (x - ax1) + ay1;
        if (ax2 != 0.0 && (ax2 < 0.0 ? !(x <= ax1) || !(x >= ax1 + ax2) : !(x >= ax1) || !(x <= ax1 + ax2))) {
            return null;
        }
        if (bx2 != 0.0 && (bx2 < 0.0 ? !(x <= bx1) || !(x >= bx1 + bx2) : !(x >= bx1) || !(x <= bx1 + bx2))) {
            return null;
        }
        if (ay2 != 0.0 && (ay2 < 0.0 ? !(y <= ay1) || !(y >= ay1 + ay2) : !(y >= ay1) || !(y <= ay1 + ay2))) {
            return null;
        }
        if (by2 != 0.0 && (by2 < 0.0 ? !(y <= by1) || !(y >= by1 + by2) : !(y >= by1) || !(y <= by1 + by2))) {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D nearestColinearPoint(Line2D segment, Point2D point) {
        return Geometry.nearestColinearPoint(segment.getX1(), segment.getY1(), segment.getX2(), segment.getY2(), point.getX(), point.getY());
    }

    public static Point2D nearestColinearPoint(double x1, double y1, double x2, double y2, double x, double y) {
        double slope = (y2 - y1) / (x2 - x1);
        if (!Double.isInfinite(slope)) {
            double y0 = y2 - slope * x2;
            x = ((y - y0) * slope + x) / (slope * slope + 1.0);
            y = x * slope + y0;
        } else {
            x = x2;
        }
        if (x1 <= x2) {
            if (x < x1) {
                x = x1;
            }
            if (x > x2) {
                x = x2;
            }
        } else {
            if (x > x1) {
                x = x1;
            }
            if (x < x2) {
                x = x2;
            }
        }
        if (y1 <= y2) {
            if (y < y1) {
                y = y1;
            }
            if (y > y2) {
                y = y2;
            }
        } else {
            if (y > y1) {
                y = y1;
            }
            if (y < y2) {
                y = y2;
            }
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D colinearPoint(Line2D line, Point2D point, double distance) {
        return Geometry.colinearPoint(line.getX1(), line.getY1(), line.getX2(), line.getY2(), point.getX(), point.getY(), distance);
    }

    public static Point2D colinearPoint(double x1, double y1, double x2, double y2, double x, double y, double distance) {
        boolean in2;
        boolean in1;
        double ox1 = x1;
        double oy1 = y1;
        double ox2 = x2;
        double oy2 = y2;
        distance *= distance;
        if (x1 == x2) {
            double dy = x1 - x;
            dy = Math.sqrt(distance - dy * dy);
            y1 = y - dy;
            y2 = y + dy;
        } else if (y1 == y2) {
            double dx = y1 - y;
            dx = Math.sqrt(distance - dx * dx);
            x1 = x - dx;
            x2 = x + dx;
        } else {
            double m = (y1 - y2) / (x2 - x1);
            double y0 = y2 - y + m * (x2 - x);
            double B = m * y0;
            double A = m * m + 1.0;
            double C = Math.sqrt(B * B + A * (distance - y0 * y0));
            x1 = (B + C) / A;
            x2 = (B - C) / A;
            y1 = y + y0 - m * x1;
            y2 = y + y0 - m * x2;
            x1 += x;
            x2 += x;
        }
        if (oy1 > oy2) {
            in1 = y1 <= oy1 && y1 >= oy2;
            in2 = y2 <= oy1 && y2 >= oy2;
        } else {
            in1 = y1 >= oy1 && y1 <= oy2;
            boolean bl = in2 = y2 >= oy1 && y2 <= oy2;
        }
        if (ox1 > ox2) {
            in1 &= x1 <= ox1 && x1 >= ox2;
            in2 &= x2 <= ox1 && x2 >= ox2;
        } else {
            in1 &= x1 >= ox1 && x1 <= ox2;
            in2 &= x2 >= ox1 && x2 <= ox2;
        }
        if (!in1 && !in2) {
            return null;
        }
        if (!in1) {
            return new Point2D.Double(x2, y2);
        }
        if (!in2) {
            return new Point2D.Double(x1, y1);
        }
        x = x1 - ox1;
        y = y1 - oy1;
        double d1 = x * x + y * y;
        double d2 = (x = x2 - ox1) * x + (y = y2 - oy1) * y;
        if (d1 > d2) {
            return new Point2D.Double(x2, y2);
        }
        return new Point2D.Double(x1, y1);
    }

    public static QuadCurve2D fitParabol(Point2D P0, Point2D P1, Point2D P2, int orientation) throws IllegalArgumentException {
        return Geometry.fitParabol(P0.getX(), P0.getY(), P1.getX(), P1.getY(), P2.getX(), P2.getY(), orientation);
    }

    public static QuadCurve2D fitParabol(double x0, double y0, double x1, double y1, double x2, double y2, int orientation) throws IllegalArgumentException {
        Point2D p = Geometry.parabolicControlPoint(x0, y0, x1, y1, x2, y2, orientation, null);
        return p != null ? new QuadCurve2D.Double(x0, y0, p.getX(), p.getY(), x2, y2) : null;
    }

    public static Point2D parabolicControlPoint(double x0, double y0, double x1, double y1, double x2, double y2, int orientation, Point2D dest) throws IllegalArgumentException {
        x1 -= x0;
        y1 -= y0;
        x2 -= x0;
        y2 -= y0;
        switch (orientation) {
            case 0: {
                double rx2 = x2;
                double ry2 = y2;
                x2 = XMath.hypot(x2, y2);
                y2 = (x1 * rx2 + y1 * ry2) / x2;
                y1 = (y1 * rx2 - x1 * ry2) / x2;
                x1 = y2;
                y2 = 0.0;
                double x = 0.5;
                double y = y1 * 0.5 * x2 / (x1 * (x2 - x1));
                double check = Math.abs(y);
                if (!(check <= 1000000.0)) {
                    return null;
                }
                if (!(check >= 1.0E-6)) {
                    return null;
                }
                x1 = 0.5 * rx2 - y * ry2 + x0;
                y1 = y * rx2 + 0.5 * ry2 + y0;
                break;
            }
            case 1: {
                double a = (y2 - y1 * x2 / x1) / (x2 - x1);
                double check = Math.abs(a);
                if (!(check <= 1000000.0)) {
                    return null;
                }
                if (!(check >= 1.0E-6)) {
                    return null;
                }
                double b = y2 / x2 - a;
                x1 = (1.0 + b / (2.0 * a)) * x2 - y2 / (2.0 * a);
                y1 = y0 + b * x1;
                x1 += x0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (dest != null) {
            dest.setLocation(x1, y1);
            return dest;
        }
        return new Point2D.Double(x1, y1);
    }

    public static Ellipse2D fitCircle(Point2D P1, Point2D P2, Point2D P3) {
        Point2D center = Geometry.circleCentre(P1.getX(), P1.getY(), P2.getX(), P2.getY(), P3.getX(), P3.getY());
        double radius = center.distance(P2);
        return new Ellipse2D.Double(center.getX() - radius, center.getY() - radius, 2.0 * radius, 2.0 * radius);
    }

    public static Point2D circleCentre(double x1, double y1, double x2, double y2, double x3, double y3) {
        double sq2 = (x2 -= x1) * x2 + (y2 -= y1) * y2;
        double sq3 = (x3 -= x1) * x3 + (y3 -= y1) * y3;
        double x = (y2 * sq3 - y3 * sq2) / (y2 * x3 - y3 * x2);
        return new Point2D.Double(x1 + 0.5 * x, y1 + 0.5 * (sq2 - x * x2) / y2);
    }

    public static Shape toPrimitive(Shape path) {
        float[] buffer = new float[6];
        PathIterator it = path.getPathIterator(null);
        if (!it.isDone() && it.currentSegment(buffer) == 0 && !it.isDone()) {
            float x1 = buffer[0];
            float y1 = buffer[1];
            int code = it.currentSegment(buffer);
            if (it.isDone()) {
                switch (code) {
                    case 1: {
                        return new Line2D.Float(x1, y1, buffer[0], buffer[1]);
                    }
                    case 2: {
                        return new QuadCurve2D.Float(x1, y1, buffer[0], buffer[1], buffer[2], buffer[3]);
                    }
                    case 3: {
                        return new CubicCurve2D.Float(x1, y1, buffer[0], buffer[1], buffer[2], buffer[3], buffer[4], buffer[5]);
                    }
                }
            }
        }
        return path;
    }

    public static double getFlatness(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        double dx = bounds.getWidth();
        double dy = bounds.getHeight();
        return Math.max(0.025 * Math.min(dx, dy), 0.001 * Math.max(dx, dy));
    }
}

