/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.Date;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;

public abstract class ClassChanger {
    private static final Class[] CLASS_RANK;
    private static ClassChanger[] list;
    private final Class source;
    private final Class target;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class<?> clazz;
        Class[] classArray = new Class[6];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz5;
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz6;
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz7;
        CLASS_RANK = classArray;
        ClassChanger[] classChangerArray = new ClassChanger[1];
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classChangerArray[0] = new ClassChanger(clazz8, clazz){

            protected Number convert(Comparable object) {
                return new Long(((Date)object).getTime());
            }

            protected Comparable inverseConvert(Number value) {
                return new Date(value.longValue());
            }
        };
        list = classChangerArray;
    }

    protected ClassChanger(Class source, Class target) {
        this.source = source;
        this.target = target;
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.lang.Comparable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(source)) {
            throw new IllegalArgumentException(String.valueOf(source));
        }
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz2.isAssignableFrom(target)) {
            throw new IllegalArgumentException(String.valueOf(target));
        }
    }

    protected abstract Number convert(Comparable var1) throws ClassCastException;

    protected abstract Comparable inverseConvert(Number var1);

    public String toString() {
        return "ClassChanger[" + this.source.getName() + "\u00a0\u21e8\u00a0" + this.target.getName() + ']';
    }

    public static synchronized void register(ClassChanger converter) throws IllegalStateException {
        int i = 0;
        while (i < list.length) {
            if (ClassChanger.list[i].source.isAssignableFrom(converter.source)) {
                int j = i;
                while (j < list.length) {
                    if (ClassChanger.list[j].source.equals(converter.source)) {
                        throw new IllegalStateException(list[j].toString());
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        list = (ClassChanger[])XArray.insert(list, i, 1);
        ClassChanger.list[i] = converter;
    }

    private static synchronized ClassChanger getClassChanger(Class source) throws ClassNotFoundException {
        int i = 0;
        while (i < list.length) {
            if (ClassChanger.list[i].source.isAssignableFrom(source)) {
                return list[i];
            }
            ++i;
        }
        throw new ClassNotFoundException(source.getName());
    }

    public static synchronized Class getTransformedClass(Class source) {
        if (source != null) {
            int i = 0;
            while (i < list.length) {
                if (ClassChanger.list[i].source.isAssignableFrom(source)) {
                    return ClassChanger.list[i].target;
                }
                ++i;
            }
        }
        return source;
    }

    public static Number toNumber(Comparable object) throws ClassNotFoundException {
        if (object != null) {
            if (object instanceof Number) {
                return (Number)((Object)object);
            }
            return ClassChanger.getClassChanger(object.getClass()).convert(object);
        }
        return null;
    }

    public static Comparable toComparable(Number value, Class classe) throws ClassNotFoundException {
        if (value != null) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(classe)) {
                return (Comparable)((Object)value);
            }
            return ClassChanger.getClassChanger(classe).inverseConvert(value);
        }
        return null;
    }

    public static Number cast(Number n, Class c) {
        if (n != null && !n.getClass().equals(c)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(c)) {
                return new Byte(n.byteValue());
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(c)) {
                return new Short(n.shortValue());
            }
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.equals(c)) {
                return new Integer(n.intValue());
            }
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz4.equals(c)) {
                return new Long(n.longValue());
            }
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz5.equals(c)) {
                return new Float(n.floatValue());
            }
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz6.equals(c)) {
                return new Double(n.doubleValue());
            }
            throw new IllegalArgumentException(Utilities.getShortName(c));
        }
        return n;
    }

    public static Class getWidestClass(Number n1, Number n2) {
        return ClassChanger.getWidestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class getWidestClass(Class c1, Class c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return CLASS_RANK[Math.max(ClassChanger.getRank(c1), ClassChanger.getRank(c2))];
    }

    public static Class getFinestClass(Class c1, Class c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return CLASS_RANK[Math.min(ClassChanger.getRank(c1), ClassChanger.getRank(c2))];
    }

    public static Class getFinestClass(double value) {
        float fv;
        long lg = (long)value;
        if (value == (double)lg) {
            if (lg >= -128L && lg <= 127L) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (lg >= -32768L && lg <= 32767L) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (lg >= Integer.MIN_VALUE && lg <= Integer.MAX_VALUE) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (lg >= -32768L && lg <= Long.MAX_VALUE) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        if (value == (double)(fv = (float)value)) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static int getRank(Class c) {
        int i = 0;
        while (i < CLASS_RANK.length) {
            if (CLASS_RANK[i].isAssignableFrom(c)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException(Utilities.getShortName(c));
    }
}

