/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.geotools.io.ExpandedTabWriter;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;

public class TableWriter
extends FilterWriter {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 1;
    private static final char[][] BOX;
    private static final char SPACE = ' ';
    private final StringBuffer buffer = new StringBuffer();
    private final List cells = new ArrayList();
    private int alignment = 0;
    private int column;
    private int row;
    private int[] width = new int[0];
    private final String separator;
    private final String leftBorder;
    private final String rightBorder;
    private boolean multiLinesCells;
    private final boolean stringOnly;
    private boolean skipCR;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geotools.io.TableWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        BOX = new char[][]{{'\u250c', '\u252c', '\u2510', '\u251c', '\u253c', '\u2524', '\u2514', '\u2534', '\u2518', '\u2500', '\u2502'}, {'\u2553', '\u2565', '\u2556', '\u255f', '\u256b', '\u2562', '\u2559', '\u2568', '\u255c', '\u2500', '\u2551'}, {'\u2552', '\u2564', '\u2555', '\u255e', '\u256a', '\u2561', '\u2558', '\u2567', '\u255b', '\u2550', '\u2502'}, {'\u2554', '\u2566', '\u2557', '\u2560', '\u256c', '\u2563', '\u255a', '\u2569', '\u255d', '\u2550', '\u2551'}, {'+', '+', '+', '+', '+', '+', '+', '+', '+', '-', '|'}};
    }

    public TableWriter(Writer out) {
        super(out != null ? out : new StringWriter());
        this.stringOnly = out == null;
        this.leftBorder = "\u2551 ";
        this.rightBorder = " \u2551";
        this.separator = " \u2502 ";
    }

    public TableWriter(Writer out, int spaces) {
        this(out, Utilities.spaces(spaces));
    }

    public TableWriter(Writer out, String separator) {
        super(out != null ? out : new StringWriter());
        this.stringOnly = out == null;
        int length = separator.length();
        int lower = 0;
        int upper = length;
        while (lower < length && Character.isSpaceChar(separator.charAt(lower))) {
            ++lower;
        }
        while (upper > 0 && Character.isSpaceChar(separator.charAt(upper - 1))) {
            --upper;
        }
        this.leftBorder = separator.substring(lower);
        this.rightBorder = separator.substring(0, upper);
        this.separator = separator;
    }

    private void writeBorder(Writer out, int horizontalBorder, int verticalBorder, char horizontalChar) throws IOException {
        String border;
        int boxCount = 0;
        char[][] box = new char[BOX.length][];
        int i = 0;
        while (i < BOX.length) {
            if (BOX[i][9] == horizontalChar) {
                box[boxCount++] = BOX[i];
            }
            ++i;
        }
        switch (horizontalBorder) {
            case -1: {
                border = this.leftBorder;
                break;
            }
            case 1: {
                border = this.rightBorder;
                break;
            }
            case 0: {
                border = this.separator;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(horizontalBorder));
            }
        }
        if (verticalBorder < -1 || verticalBorder > 1) {
            throw new IllegalArgumentException(String.valueOf(verticalBorder));
        }
        int index = horizontalBorder + 1 + (verticalBorder + 1) * 3;
        int borderLength = border.length();
        int i2 = 0;
        while (i2 < borderLength) {
            char c = border.charAt(i2);
            if (Character.isSpaceChar(c)) {
                c = horizontalChar;
            } else {
                int j = 0;
                while (j < boxCount) {
                    if (box[j][10] == c) {
                        c = box[j][index];
                        break;
                    }
                    ++j;
                }
            }
            out.write(c);
            ++i2;
        }
    }

    public void setMultiLinesCells(boolean multiLines) {
        Object object = this.lock;
        synchronized (object) {
            this.multiLinesCells = multiLines;
        }
    }

    public boolean isMultiLinesCells() {
        Object object = this.lock;
        synchronized (object) {
            return this.multiLinesCells;
        }
    }

    public void setColumnAlignment(int column, int alignment) {
        if (alignment != 0 && alignment != 2 && alignment != 1) {
            throw new IllegalArgumentException(String.valueOf(alignment));
        }
        Object object = this.lock;
        synchronized (object) {
            int current = 0;
            Iterator it = this.cells.iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                if (cell == null || cell.text == null) {
                    current = 0;
                    continue;
                }
                if (current == column) {
                    cell.alignment = alignment;
                }
                ++current;
            }
        }
    }

    public void setAlignment(int alignment) {
        if (alignment != 0 && alignment != 2 && alignment != 1) {
            throw new IllegalArgumentException(String.valueOf(alignment));
        }
        Object object = this.lock;
        synchronized (object) {
            this.alignment = alignment;
        }
    }

    public int getAlignment() {
        Object object = this.lock;
        synchronized (object) {
            return this.alignment;
        }
    }

    private int getRowCount() {
        int count = this.row;
        if (this.column != 0) {
            ++count;
        }
        return count;
    }

    private int getColumnCount() {
        return this.width.length;
    }

    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.multiLinesCells) {
                switch (c) {
                    case 9: {
                        this.nextColumn();
                        this.skipCR = false;
                        return;
                    }
                    case 13: {
                        this.nextLine();
                        this.skipCR = true;
                        return;
                    }
                    case 10: {
                        if (!this.skipCR) {
                            this.nextLine();
                        }
                        this.skipCR = false;
                        return;
                    }
                }
            }
            if (c < 0 || c > 65535) {
                throw new IllegalArgumentException(String.valueOf(c));
            }
            this.buffer.append((char)c);
            this.skipCR = false;
        }
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void write(String string, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.skipCR && string.charAt(offset) == '\n') {
                ++offset;
                --length;
            }
            if (!this.multiLinesCells) {
                int upper = offset;
                while (length != 0) {
                    switch (string.charAt(upper++)) {
                        case '\t': {
                            this.buffer.append(string.substring(offset, upper - 1));
                            this.nextColumn();
                            offset = upper;
                            break;
                        }
                        case '\r': {
                            this.buffer.append(string.substring(offset, upper - 1));
                            this.nextLine();
                            if (length != 0 && string.charAt(upper) == '\n') {
                                --length;
                            }
                            offset = ++upper;
                            break;
                        }
                        case '\n': {
                            this.buffer.append(string.substring(offset, upper - 1));
                            this.nextLine();
                            offset = upper;
                        }
                    }
                    --length;
                }
                length = upper - offset;
            }
            this.skipCR = string.charAt(offset + length - 1) == '\r';
            this.buffer.append(string.substring(offset, offset + length));
        }
    }

    public void write(char[] cbuf) {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(char[] cbuf, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.skipCR && cbuf[offset] == '\n') {
                ++offset;
                --length;
            }
            if (!this.multiLinesCells) {
                int upper = offset;
                while (length != 0) {
                    switch (cbuf[upper++]) {
                        case '\t': {
                            this.buffer.append(cbuf, offset, upper - offset - 1);
                            this.nextColumn();
                            offset = upper;
                            break;
                        }
                        case '\r': {
                            this.buffer.append(cbuf, offset, upper - offset - 1);
                            this.nextLine();
                            if (length != 0 && cbuf[upper] == '\n') {
                                --length;
                            }
                            offset = ++upper;
                            break;
                        }
                        case '\n': {
                            this.buffer.append(cbuf, offset, upper - offset - 1);
                            this.nextLine();
                            offset = upper;
                        }
                    }
                    --length;
                }
                length = upper - offset;
            }
            this.skipCR = cbuf[offset + length - 1] == '\r';
            this.buffer.append(cbuf, offset, length);
        }
    }

    public void writeHorizontalSeparator() {
        Object object = this.lock;
        synchronized (object) {
            if (this.column != 0 || this.buffer.length() != 0) {
                this.nextLine();
            }
            this.nextLine('\u2500');
        }
    }

    public void nextColumn() {
        this.nextColumn(' ');
    }

    public void nextColumn(char fill) {
        Object object = this.lock;
        synchronized (object) {
            String cellText = this.buffer.toString();
            this.cells.add(new Cell(cellText, this.alignment, fill));
            if (this.column >= this.width.length) {
                this.width = XArray.resize(this.width, this.column + 1);
            }
            int length = 0;
            StringTokenizer tk = new StringTokenizer(cellText, "\r\n");
            while (tk.hasMoreTokens()) {
                int lg = tk.nextToken().length();
                if (lg <= length) continue;
                length = lg;
            }
            if (length > this.width[this.column]) {
                this.width[this.column] = length;
            }
            ++this.column;
            this.buffer.setLength(0);
        }
    }

    public void nextLine() {
        this.nextLine(' ');
    }

    public void nextLine(char fill) {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.length() != 0) {
                this.nextColumn(fill);
            }
            if (!$assertionsDisabled && this.buffer.length() != 0) {
                throw new AssertionError();
            }
            this.cells.add(!Character.isSpaceChar(fill) ? new Cell(null, this.alignment, fill) : null);
            this.column = 0;
            ++this.row;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer.length() != 0) {
                this.nextLine();
                if (!$assertionsDisabled && this.buffer.length() != 0) {
                    throw new AssertionError();
                }
            }
            this.flushTo(this.out);
            this.column = 0;
            this.row = 0;
            this.cells.clear();
            this.out.flush();
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.out.close();
        }
    }

    private void flushTo(Writer out) throws IOException {
        String columnSeparator = this.separator;
        String lineSeparator = System.getProperty("line.separator", "\n");
        Object[] currentLine = new Cell[this.width.length];
        int cellCount = this.cells.size();
        int cellIndex = 0;
        while (cellIndex < cellCount) {
            Cell cell;
            Cell lineFill = null;
            int currentCount = 0;
            while ((cell = (Cell)this.cells.get(cellIndex)) != null) {
                if (cell.text == null) {
                    lineFill = new Cell("", cell.alignment, cell.fill);
                    break;
                }
                currentLine[currentCount++] = cell;
                if (++cellIndex < cellCount) continue;
            }
            Arrays.fill(currentLine, currentCount, currentLine.length, lineFill);
            while (!TableWriter.isEmpty(currentLine)) {
                int j = 0;
                while (j < currentLine.length) {
                    boolean isFirstColumn = j == 0;
                    boolean isLastColumn = j + 1 == currentLine.length;
                    Object cell2 = currentLine[j];
                    int cellWidth = this.width[j];
                    if (cell2 == null) {
                        if (isFirstColumn) {
                            out.write(this.leftBorder);
                        }
                        TableWriter.repeat(out, ' ', cellWidth);
                        out.write(isLastColumn ? this.rightBorder : columnSeparator);
                    } else {
                        int end;
                        String cellText = ((Cell)cell2).toString();
                        int endCR = cellText.indexOf(13);
                        int endLF = cellText.indexOf(10);
                        int n = endCR < 0 ? endLF : (end = endLF < 0 ? endCR : Math.min(endCR, endLF));
                        if (end >= 0) {
                            int top = end + 1;
                            if (endCR < 0 || endCR + 1 == endLF) {
                                // empty if block
                            }
                            int scan = ++top;
                            int textLength = cellText.length();
                            while (scan < textLength && Character.isWhitespace(cellText.charAt(scan))) {
                                ++scan;
                            }
                            currentLine[j] = scan < textLength ? ((Cell)cell2).substring(top) : null;
                            cellText = cellText.substring(0, end);
                        } else {
                            currentLine[j] = null;
                        }
                        int textLength = cellText.length();
                        if (currentCount == 0) {
                            if (!$assertionsDisabled && textLength != 0) {
                                throw new AssertionError();
                            }
                            int verticalBorder = cellIndex == 0 ? -1 : (cellIndex >= cellCount - 1 ? 1 : 0);
                            if (isFirstColumn) {
                                this.writeBorder(out, -1, verticalBorder, ((Cell)cell2).fill);
                            }
                            TableWriter.repeat(out, ((Cell)cell2).fill, cellWidth);
                            this.writeBorder(out, isLastColumn ? 1 : 0, verticalBorder, ((Cell)cell2).fill);
                        } else {
                            if (isFirstColumn) {
                                out.write(this.leftBorder);
                            }
                            Writer tabExpander = cellText.indexOf(9) >= 0 ? new ExpandedTabWriter(out) : out;
                            switch (((Cell)cell2).alignment) {
                                default: {
                                    throw new AssertionError(((Cell)cell2).alignment);
                                }
                                case 0: {
                                    tabExpander.write(cellText);
                                    TableWriter.repeat(tabExpander, ((Cell)cell2).fill, cellWidth - textLength);
                                    break;
                                }
                                case 2: {
                                    TableWriter.repeat(tabExpander, ((Cell)cell2).fill, cellWidth - textLength);
                                    tabExpander.write(cellText);
                                    break;
                                }
                                case 1: {
                                    int rightMargin = (cellWidth - textLength) / 2;
                                    TableWriter.repeat(tabExpander, ((Cell)cell2).fill, rightMargin);
                                    tabExpander.write(cellText);
                                    TableWriter.repeat(tabExpander, ((Cell)cell2).fill, cellWidth - rightMargin - textLength);
                                }
                            }
                            out.write(isLastColumn ? this.rightBorder : columnSeparator);
                        }
                    }
                    ++j;
                }
                out.write(lineSeparator);
            }
            ++cellIndex;
        }
    }

    private static boolean isEmpty(Object[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] == null) continue;
            return false;
        }
        return true;
    }

    private static void repeat(Writer out, char car, int count) throws IOException {
        while (--count >= 0) {
            out.write(car);
        }
    }

    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            StringWriter writer;
            int capacity = 2;
            int i = 0;
            while (i < this.width.length) {
                capacity += this.width[i];
                ++i;
            }
            capacity *= this.getRowCount();
            if (this.stringOnly) {
                writer = (StringWriter)this.out;
                StringBuffer buffer = writer.getBuffer();
                buffer.setLength(0);
                buffer.ensureCapacity(capacity);
            } else {
                writer = new StringWriter(capacity);
            }
            try {
                this.flushTo(writer);
            }
            catch (IOException exception) {
                IllegalStateException error = new IllegalStateException(exception.getLocalizedMessage());
                error.initCause(exception);
                throw error;
            }
            return writer.toString();
        }
    }

    private static final class Cell {
        public final String text;
        public int alignment;
        public final char fill;

        public Cell(String text, int alignment, char fill) {
            this.text = text;
            this.alignment = alignment;
            this.fill = fill;
        }

        public Cell substring(int lower) {
            return new Cell(this.text.substring(lower), this.alignment, this.fill);
        }

        public String toString() {
            return this.text;
        }
    }
}

