/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.geotools.resources.Utilities;

public class ExpandedTabWriter
extends FilterWriter {
    private int tabWidth = 8;
    private int column = 0;

    public ExpandedTabWriter(Writer out) {
        super(out);
    }

    public ExpandedTabWriter(Writer out, int tabWidth) throws IllegalArgumentException {
        super(out);
        this.setTabWidth(tabWidth);
    }

    public void setTabWidth(int tabWidth) throws IllegalArgumentException {
        Object object = this.lock;
        synchronized (object) {
            if (tabWidth <= 0) {
                throw new IllegalArgumentException(Integer.toString(tabWidth));
            }
            this.tabWidth = tabWidth;
        }
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    private void expand() throws IOException {
        int width = this.tabWidth - this.column % this.tabWidth;
        this.out.write(Utilities.spaces(width));
        this.column += width;
    }

    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            switch (c) {
                case 10: 
                case 13: {
                    this.column = 0;
                    break;
                }
                case 9: {
                    this.expand();
                    return;
                }
                default: {
                    ++this.column;
                }
            }
            this.out.write(c);
        }
    }

    public void write(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int start = offset;
            length += offset;
            int end = offset;
            while (end < length) {
                char c = buffer[end];
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.column = 0;
                        break;
                    }
                    case '\t': {
                        this.out.write(buffer, start, end - start);
                        start = end + 1;
                        this.expand();
                        break;
                    }
                    default: {
                        ++this.column;
                    }
                }
                ++end;
            }
            this.out.write(buffer, start, length - start);
        }
    }

    public void write(String string, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int start = offset;
            length += offset;
            int end = offset;
            while (end < length) {
                char c = string.charAt(end);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.column = 0;
                        break;
                    }
                    case '\t': {
                        this.out.write(string, start, end - start);
                        start = end + 1;
                        this.expand();
                        break;
                    }
                    default: {
                        ++this.column;
                    }
                }
                ++end;
            }
            this.out.write(string, start, length - start);
        }
    }
}

