/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class DefaultFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private final String description;
    private final Pattern pattern;

    public DefaultFileFilter(String pattern) {
        this(pattern, new File(pattern).getName());
    }

    public DefaultFileFilter(String pattern, String description) {
        this.description = description.trim();
        int length = pattern.length();
        StringBuffer buffer = new StringBuffer(length + 8);
        int i = 0;
        while (i < length) {
            char c = pattern.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    case '*': 
                    case '?': {
                        buffer.append('.');
                        break;
                    }
                    default: {
                        buffer.append('\\');
                    }
                }
            }
            buffer.append(c);
            ++i;
        }
        this.pattern = Pattern.compile(buffer.toString());
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accept(File file) {
        return file != null && this.pattern.matcher(file.getName()).matches();
    }

    public boolean accept(File dir, String name) {
        return name != null && this.pattern.matcher(name).matches();
    }
}

