/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.factory.FactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;

public abstract class FeatureTypeFactory
implements Factory {
    private static Set builtInTypes = null;
    private static boolean initialized;
    private String name;
    private String namespace;
    private boolean dirty = true;
    private FeatureType type = null;
    private AttributeType defaultGeometry = null;
    private boolean abstractType = false;
    private Set superTypes;

    public static FeatureTypeFactory createTemplate(FeatureType original) throws FactoryConfigurationError {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(original.getTypeName());
        factory.importType(original);
        factory.setNamespace(original.getNamespace());
        factory.setDefaultGeometry(original.getDefaultGeometry());
        FeatureType[] ancestors = original.getAncestors();
        if (ancestors != null) {
            factory.setSuperTypes(Arrays.asList(ancestors));
        }
        return factory;
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, String ns, boolean isAbstract, FeatureType[] superTypes) throws FactoryConfigurationError, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, String ns, boolean isAbstract) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, String ns) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, false);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, null, false);
    }

    public static FeatureTypeFactory newInstance(String name) throws FactoryConfigurationError {
        FeatureTypeFactory factory = (FeatureTypeFactory)FactoryFinder.findFactory("org.geotools.feature.FeatureTypeFactory", "org.geotools.feature.DefaultFeatureTypeFactory");
        factory.setName(name);
        return factory;
    }

    public void importType(FeatureType type, boolean strict) throws IllegalArgumentException {
        int i = 0;
        int ii = type.getAttributeCount();
        while (i < ii) {
            block3: {
                try {
                    this.addType(type.getAttributeType(i));
                }
                catch (IllegalArgumentException iae) {
                    if (!strict) break block3;
                    throw iae;
                }
            }
            ++i;
        }
    }

    public final void setSuperTypes(Collection types) {
        this.superTypes = new LinkedHashSet(types);
    }

    public final Collection getSuperTypes() {
        Set supers = this.superTypes == null ? new HashSet() : this.superTypes;
        Set builtin = this.getBuiltinTypes();
        if (builtin != null) {
            supers.addAll(builtin);
        }
        return supers;
    }

    public void importType(FeatureType type) {
        this.importType(type, false);
    }

    public void setName(String name) {
        this.dirty |= this.isDifferent(name, this.name);
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void setNamespace(String namespace) {
        this.dirty |= this.isDifferent(namespace, this.namespace);
        this.namespace = namespace;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final boolean isAbstract() {
        return this.abstractType;
    }

    public final void setAbstract(boolean a) {
        this.dirty = true;
        this.abstractType = a;
    }

    private boolean isDifferent(String s1, String s2) {
        if (s1 != null) {
            return !s1.equals(s2);
        }
        if (s2 != null) {
            return !s2.equals(s1);
        }
        return s1 != s2;
    }

    public final void removeAll() {
        int cnt;
        int i = cnt = this.getAttributeCount();
        while (i > 0) {
            this.removeType(i - 1);
            ++i;
        }
    }

    public final void addTypes(AttributeType[] types) throws NullPointerException, IllegalArgumentException {
        if (types == null) {
            return;
        }
        int i = 0;
        while (i < types.length) {
            this.addType(types[i]);
            ++i;
        }
    }

    public final void addType(AttributeType type) throws NullPointerException, IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        this.check(type);
        this.add(type);
    }

    public final void removeType(AttributeType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        AttributeType removed = this.remove(type);
        if (removed == this.defaultGeometry) {
            this.defaultGeometry = null;
        }
    }

    public final void addType(int idx, AttributeType type) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        this.check(type);
        this.add(idx, type);
    }

    public final void removeType(int idx) throws ArrayIndexOutOfBoundsException {
        this.dirty = true;
        AttributeType removed = this.remove(idx);
        if (removed == this.defaultGeometry) {
            this.defaultGeometry = null;
        }
    }

    public final void setType(int idx, AttributeType type) throws IllegalArgumentException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        this.check(type);
        AttributeType removed = this.set(idx, type);
        if (removed == this.defaultGeometry) {
            this.defaultGeometry = null;
        }
    }

    public final void swap(int idx1, int idx2) throws ArrayIndexOutOfBoundsException {
        AttributeType tmp = this.get(idx1);
        this.set(idx1, this.get(idx2));
        this.set(idx2, tmp);
        this.dirty = true;
    }

    public final AttributeType getDefaultGeometry() {
        return this.defaultGeometry;
    }

    public final void setDefaultGeometry(AttributeType defaultGeometry) throws IllegalArgumentException {
        if (defaultGeometry != null && !defaultGeometry.isGeometry()) {
            String mess = "Attempted to set a non-geometry type as defaultGeometry: ";
            throw new IllegalArgumentException(String.valueOf(mess) + defaultGeometry);
        }
        this.dirty = true;
        this.defaultGeometry = defaultGeometry;
        if (defaultGeometry != null && !this.contains(defaultGeometry)) {
            this.addType(defaultGeometry);
        }
    }

    public final FeatureType getFeatureType() throws SchemaException {
        if (this.dirty || this.type == null) {
            if (this.defaultGeometry == null) {
                int i = 0;
                int ii = this.getAttributeCount();
                while (i < ii) {
                    if (this.get(i).isGeometry()) {
                        this.defaultGeometry = this.get(i);
                        break;
                    }
                    ++i;
                }
            }
            if (this.name == null || this.name.trim().length() == 0) {
                throw new SchemaException("Cannot create FeatureType with null or blank name");
            }
            this.type = this.createFeatureType();
            if (this.type == null) {
                throw new NullPointerException(String.valueOf(this.getClass().getName()) + ".createFeatureType()");
            }
            if (this.isAbstract() && !this.type.isAbstract()) {
                throw new RuntimeException("FeatureTypeFactory poorly implemented, expected abstract type, received " + this.type);
            }
            this.dirty = false;
        }
        return this.type;
    }

    public String toString() {
        String types = "";
        int i = 0;
        int ii = this.getAttributeCount();
        while (i < ii) {
            types = String.valueOf(types) + this.get(i);
            if (i < ii) {
                types = String.valueOf(types) + " , ";
            }
            ++i;
        }
        return "FeatureTypeFactory(" + this.getClass().getName() + ") [ " + types + " ]";
    }

    public final boolean contains(AttributeType type) {
        int i = 0;
        int ii = this.getAttributeCount();
        while (i < ii) {
            if (this.get(i).getName().equals(type.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void check(AttributeType type) {
        if (this.contains(type)) {
            throw new IllegalArgumentException("Duplicate AttributeTypes " + type);
        }
    }

    protected final Set getBuiltinTypes() {
        if (builtInTypes == null && !initialized) {
            builtInTypes = new HashSet();
            try {
                builtInTypes.add(FeatureTypeFactory.newFeatureType(null, "Feature", "http://www.opengis.net/gml", true));
                initialized = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.addBaseTypes(builtInTypes);
        }
        return builtInTypes;
    }

    protected void addBaseTypes(Set types) {
    }

    protected abstract FeatureType createFeatureType() throws SchemaException;

    protected abstract void add(AttributeType var1) throws IllegalArgumentException;

    protected abstract AttributeType remove(AttributeType var1);

    protected abstract void add(int var1, AttributeType var2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException;

    protected abstract AttributeType remove(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract AttributeType get(int var1) throws ArrayIndexOutOfBoundsException;

    protected abstract AttributeType set(int var1, AttributeType var2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException;

    public abstract int getAttributeCount();
}

