/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Iterator;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;

public class FeatureCollectionIteration {
    protected final Handler handler;
    private final FeatureCollection collection;
    static /* synthetic */ Class class$0;

    public FeatureCollectionIteration(Handler handler, FeatureCollection collection) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        this.handler = handler;
        this.collection = collection;
    }

    public static void iteration(Handler handler, FeatureCollection collection) {
        FeatureCollectionIteration iteration = new FeatureCollectionIteration(handler, collection);
        iteration.iterate();
    }

    public void iterate() {
        this.walker(this.collection);
    }

    protected void walker(FeatureCollection collection) {
        this.handler.handleFeatureCollection(collection);
        this.iterate(collection.iterator());
        this.handler.endFeatureCollection(collection);
    }

    protected void iterate(Iterator iterator) {
        while (iterator.hasNext()) {
            this.walker((Feature)iterator.next());
        }
    }

    protected void walker(Feature feature) {
        FeatureType schema = feature.getFeatureType();
        int cnt = schema.getAttributeCount();
        this.handler.handleFeature(feature);
        int i = 0;
        while (i < cnt) {
            AttributeType type = schema.getAttributeType(i);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.geotools.feature.FeatureCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(type.getType())) {
                this.walker((FeatureCollection)feature.getAttribute(i));
            } else if (type.isNested()) {
                this.walker((Feature)feature.getAttribute(i));
            } else {
                this.handler.handleAttribute(type, feature.getAttribute(i));
            }
            ++i;
        }
        this.handler.endFeature(feature);
    }

    public interface Handler {
        public void handleFeatureCollection(FeatureCollection var1);

        public void endFeatureCollection(FeatureCollection var1);

        public void handleFeature(Feature var1);

        public void endFeature(Feature var1);

        public void handleAttribute(AttributeType var1, Object var2);
    }
}

