/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;

public class ShapefileWriter {
    WritableByteChannel shpChannel;
    WritableByteChannel shxChannel;
    ByteBuffer shapeBuffer;
    ByteBuffer indexBuffer;
    ShapeHandler handler;
    ShapeType type;
    int fileLength;

    public ShapefileWriter(WritableByteChannel shpChannel, WritableByteChannel shxChannel) {
        this.shpChannel = shpChannel;
        this.shxChannel = shxChannel;
    }

    private void init(GeometryCollection geometries) throws IOException, ShapefileException {
        this.handler = this.type.getShapeHandler();
        this.fileLength = 100;
        int i = geometries.getNumGeometries() - 1;
        while (i >= 0) {
            int size = this.handler.getLength(geometries.getGeometryN(i)) + 8;
            this.fileLength += size;
            --i;
        }
        this.allocateBuffers(geometries.getNumGeometries());
    }

    private void allocateBuffers(int geomCnt) throws IOException {
        if (!(this.shpChannel instanceof FileChannel)) {
            throw new RuntimeException("Can only handle FileChannels - fix me!");
        }
        FileChannel shpc = (FileChannel)this.shpChannel;
        FileChannel shxc = (FileChannel)this.shxChannel;
        this.shapeBuffer = shpc.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileLength);
        this.indexBuffer = shxc.map(FileChannel.MapMode.READ_WRITE, 0L, 100 + 8 * geomCnt);
        this.indexBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    private void writeHeaders(GeometryCollection geometries) throws IOException {
        ShapefileHeader header = new ShapefileHeader();
        Envelope bounds = geometries.getEnvelopeInternal();
        header.write(this.shapeBuffer, this.type, geometries.getNumGeometries(), this.fileLength / 2, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
        header.write(this.indexBuffer, this.type, geometries.getNumGeometries(), 50 + 4 * geometries.getNumGeometries(), bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    public void write(GeometryCollection geometries, ShapeType type) throws IOException, ShapefileException {
        this.type = type;
        this.init(geometries);
        this.writeHeaders(geometries);
        int offset = 50;
        int lp = this.shapeBuffer.position();
        int i = 0;
        int ii = geometries.getNumGeometries();
        while (i < ii) {
            Geometry g = geometries.getGeometryN(i);
            int length = this.handler.getLength(g) / 2;
            this.shapeBuffer.order(ByteOrder.BIG_ENDIAN);
            this.shapeBuffer.putInt(i + 1);
            this.shapeBuffer.putInt(length);
            this.shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.shapeBuffer.putInt(type.id);
            this.handler.write(this.shapeBuffer, g);
            lp = this.shapeBuffer.position();
            System.out.flush();
            this.indexBuffer.putInt(offset);
            this.indexBuffer.putInt(length);
            offset += length + 4;
            ++i;
        }
        this.shpChannel.close();
        this.shxChannel.close();
    }
}

