/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;

public class ShapefileReader {
    private ShapeHandler handler;
    private ShapefileHeader header;
    private ReadableByteChannel channel;
    private ByteBuffer buffer;
    private ShapeType fileShapeType = ShapeType.UNDEFINED;
    private final Record record = new Record();
    private final boolean randomAccessEnabled;

    public ShapefileReader(ReadableByteChannel channel, boolean strict) throws IOException, ShapefileException {
        this.channel = channel;
        this.randomAccessEnabled = channel instanceof FileChannel;
        this.init(strict);
    }

    public ShapefileReader(ReadableByteChannel channel) throws IOException, ShapefileException {
        this(channel, true);
    }

    public static ShapefileHeader readHeader(ReadableByteChannel channel, boolean strict) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        if (ShapefileReader.fill(buffer, channel) == -1) {
            throw new EOFException("Premature end of header");
        }
        buffer.flip();
        ShapefileHeader header = new ShapefileHeader();
        header.read(buffer, strict);
        return header;
    }

    private ByteBuffer ensureCapacity(ByteBuffer buffer, int size) {
        if (buffer.isReadOnly()) {
            return buffer;
        }
        int limit = buffer.limit();
        while (limit < size) {
            limit *= 2;
        }
        if (limit != buffer.limit()) {
            if (this.record.ready) {
                buffer = ByteBuffer.allocateDirect(limit);
            } else {
                throw new IllegalArgumentException("next before hasNext");
            }
        }
        return buffer;
    }

    private static int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void init(boolean strict) throws IOException, ShapefileException {
        this.header = ShapefileReader.readHeader(this.channel, strict);
        this.fileShapeType = this.header.getShapeType();
        this.handler = this.fileShapeType.getShapeHandler();
        if (this.handler == null) {
            throw new IOException("Unsuported shape type:" + this.fileShapeType);
        }
        if (this.channel instanceof FileChannel) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            this.buffer.position(100);
        } else {
            this.buffer = ByteBuffer.allocateDirect(8192);
            ShapefileReader.fill(this.buffer, this.channel);
            this.buffer.flip();
        }
        this.record.end = this.buffer.position();
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
        this.channel = null;
        this.header = null;
    }

    public boolean supportsRandomAccess() {
        return this.randomAccessEnabled;
    }

    public boolean hasNext() throws IOException {
        this.buffer.position(this.record.end);
        if (this.buffer.remaining() < 8) {
            if (this.buffer.isReadOnly()) {
                return false;
            }
            this.buffer.compact();
            if (ShapefileReader.fill(this.buffer, this.channel) == -1) {
                return false;
            }
            this.buffer.position(0);
        }
        this.buffer.mark();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int number = this.buffer.getInt();
        if (number != this.record.number + 1) {
            return false;
        }
        this.buffer.reset();
        this.record.ready = true;
        return true;
    }

    public Record nextRecord() throws IOException {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int recordNumber = this.buffer.getInt();
        int recordLength = this.buffer.getInt() * 2;
        if (this.buffer.capacity() < recordLength) {
            ByteBuffer old = this.buffer;
            this.buffer = this.ensureCapacity(this.buffer, recordLength);
            this.buffer.put(old);
            ShapefileReader.fill(this.buffer, this.channel);
            this.buffer.position(0);
        } else if (this.buffer.remaining() < recordLength) {
            this.buffer.compact();
            ShapefileReader.fill(this.buffer, this.channel);
            this.buffer.position(0);
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        ShapeType recordType = ShapeType.forID(this.buffer.getInt());
        if (recordType != ShapeType.NULL && recordType != this.fileShapeType) {
            throw new IllegalStateException("ShapeType changed illegally from " + this.fileShapeType + " to " + recordType);
        }
        this.buffer.mark();
        if (recordType.isMultiPoint()) {
            this.record.minX = this.buffer.getDouble();
            this.record.minY = this.buffer.getDouble();
            this.record.maxX = this.buffer.getDouble();
            this.record.maxY = this.buffer.getDouble();
        } else if (recordType != ShapeType.NULL) {
            this.record.minX = this.record.maxX = this.buffer.getDouble();
            this.record.minY = this.record.minY = this.buffer.getDouble();
        }
        this.buffer.reset();
        this.record.offset = this.record.offset + (this.record.length + (this.record.length == 0 ? 0 : 8));
        this.record.length = recordLength;
        this.record.type = recordType;
        this.record.number = recordNumber;
        this.record.end = this.buffer.position() + recordLength - 4;
        this.record.ready = false;
        return this.record;
    }

    public Object shapeAt(int offset) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            this.buffer.position(offset);
            this.hasNext();
            return this.nextRecord().shape();
        }
        throw new UnsupportedOperationException("Random Access not enabled");
    }

    public static void main(String[] args) throws Exception {
        FileChannel channel = new FileInputStream(args[0]).getChannel();
        ShapefileReader reader = new ShapefileReader(channel);
        while (reader.hasNext()) {
            System.out.println(reader.nextRecord().shape());
        }
    }

    public final class Record {
        int length;
        int number = 0;
        int offset;
        public double minX;
        public double minY;
        public double maxX;
        public double maxY;
        ShapeType type;
        int end = 0;
        boolean ready = false;

        public Object shape() {
            return ShapefileReader.this.handler.read(ShapefileReader.this.buffer, this.type);
        }

        public int offset() {
            return this.offset;
        }

        public String toString() {
            return "Record " + this.number + " length " + this.length + " bounds " + this.minX + "," + this.minY + " " + this.maxX + "," + this.maxY;
        }
    }
}

