/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class PolygonHandler
implements ShapeHandler {
    GeometryFactory geometryFactory = new GeometryFactory();
    RobustCGAlgorithms cga = new RobustCGAlgorithms();
    final ShapeType shapeType;

    public PolygonHandler() {
        this.shapeType = ShapeType.POLYGON;
    }

    public PolygonHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        int t = pointList.length - 1;
        while (t >= 0) {
            Coordinate p = pointList[t];
            if (testPoint.x == p.x && testPoint.y == p.y && (testPoint.z == p.z || testPoint.z != testPoint.z)) {
                return true;
            }
            --t;
        }
        return false;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    /*
     * WARNING - void declaration
     */
    public int getLength(Object geometry) {
        void var5_7;
        int length;
        MultiPolygon multi;
        if (geometry instanceof MultiPolygon) {
            multi = (MultiPolygon)geometry;
        } else {
            Geometry g = (Geometry)geometry;
            multi = new MultiPolygon(new Polygon[]{(Polygon)geometry}, g.getPrecisionModel(), g.getSRID());
        }
        int nrings = 0;
        int t = 0;
        while (t < multi.getNumGeometries()) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
            ++t;
        }
        int npoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return (int)var5_7;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        int i = 0;
        while (i < numParts) {
            partOffsets[i] = buffer.getInt();
            ++i;
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        Coordinate[] coords = this.readCoordinates(buffer, numPoints);
        if (this.shapeType == ShapeType.POLYGONZ) {
            buffer.position(buffer.position() + 16);
            int t = 0;
            while (t < numPoints) {
                coords[t].z = buffer.getDouble();
                ++t;
            }
        }
        int offset = 0;
        int part = 0;
        while (part < numParts) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            Coordinate[] points = new Coordinate[length];
            int i2 = 0;
            while (i2 < length) {
                points[i2] = coords[offset++];
                ++i2;
            }
            if (points.length == 0 || points.length > 3) {
                LinearRing ring = this.geometryFactory.createLinearRing(points);
                if (this.cga.isCCW(points)) {
                    holes.add(ring);
                } else {
                    shells.add(ring);
                }
            }
            ++part;
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.size() == 0) {
            Logger.getLogger("org.geotools.data.shapefile").warning("only one hole in this polygon record");
            return this.createMulti(JTSUtilities.reverseRing((LinearRing)holes.get(0)));
        }
        ArrayList holesForShells = this.assignHolesToShells(shells, holes);
        Geometry g = this.buildGeometries(shells, holes, holesForShells);
        return g;
    }

    private Coordinate[] readCoordinates(ByteBuffer buffer, int numPoints) {
        Coordinate[] coords = new Coordinate[numPoints];
        int t = 0;
        while (t < numPoints) {
            coords[t] = new Coordinate(buffer.getDouble(), buffer.getDouble());
            ++t;
        }
        return coords;
    }

    private Geometry buildGeometries(List shells, List holes, List holesForShells) {
        Polygon[] polygons = shells.size() > 0 ? new Polygon[shells.size()] : new Polygon[holes.size()];
        int i = 0;
        while (i < shells.size()) {
            polygons[i] = this.geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
            ++i;
        }
        if (shells.size() == 0) {
            i = 0;
            int ii = holes.size();
            while (i < ii) {
                LinearRing hole = (LinearRing)holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(JTSUtilities.reverseRing(hole), new LinearRing[0]);
                ++i;
            }
        }
        MultiPolygon g = this.geometryFactory.createMultiPolygon(polygons);
        return g;
    }

    ArrayList assignHolesToShells(ArrayList shells, ArrayList holes) {
        ArrayList holesForShells = new ArrayList(shells.size());
        int i = 0;
        while (i < shells.size()) {
            holesForShells.add(new ArrayList());
            ++i;
        }
        i = 0;
        while (i < holes.size()) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            int j = 0;
            while (j < shells.size()) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (this.cga.isPointInRing(testPt, coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (isContained && (minShell == null || minEnv.contains(tryEnv))) {
                    minShell = tryRing;
                }
                ++j;
            }
            if (minShell == null) {
                Logger.getLogger("org.geotools.data.shapefile").warning("polygon found with a hole thats not inside a shell");
                shells.add(JTSUtilities.reverseRing(testRing));
                holesForShells.add(new ArrayList());
            } else {
                ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
            }
            ++i;
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing single, List holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[holes.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        MultiPolygon multi;
        if (geometry instanceof MultiPolygon) {
            multi = (MultiPolygon)geometry;
        } else {
            Geometry g = (Geometry)geometry;
            multi = new MultiPolygon(new Polygon[]{(Polygon)geometry}, g.getPrecisionModel(), g.getSRID());
        }
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int nrings = 0;
        int t = 0;
        while (t < multi.getNumGeometries()) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
            ++t;
        }
        int u = 0;
        int[] pointsPerRing = new int[nrings];
        int t2 = 0;
        while (t2 < multi.getNumGeometries()) {
            Polygon p = (Polygon)multi.getGeometryN(t2);
            pointsPerRing[u] = p.getExteriorRing().getNumPoints();
            ++u;
            int v = 0;
            while (v < p.getNumInteriorRing()) {
                pointsPerRing[u] = p.getInteriorRingN(v).getNumPoints();
                ++u;
                ++v;
            }
            ++t2;
        }
        int npoints = multi.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        int t3 = 0;
        while (t3 < nrings) {
            buffer.putInt(count);
            count += pointsPerRing[t3];
            ++t3;
        }
        Coordinate[] coords = multi.getCoordinates();
        int t4 = 0;
        while (t4 < coords.length) {
            buffer.putDouble(coords[t4].x);
            buffer.putDouble(coords[t4].y);
            ++t4;
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            double[] zExtreame = JTSUtilities.zMinMax(multi.getCoordinates());
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            int t5 = 0;
            while (t5 < npoints) {
                double z = coords[t5].z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                } else {
                    buffer.putDouble(z);
                }
                ++t5;
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            t = 0;
            while (t < npoints) {
                buffer.putDouble(-1.0E41);
                ++t;
            }
        }
    }
}

