/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiPointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory = new GeometryFactory();

    public MultiPointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    public MultiPointHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.MULTIPOINT && type != ShapeType.MULTIPOINTM && type != ShapeType.MULTIPOINTZ) {
            throw new ShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.shapeType = type;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    /*
     * WARNING - void declaration
     */
    public int getLength(Object geometry) {
        void var3_3;
        int length;
        MultiPoint mp = (MultiPoint)geometry;
        if (this.shapeType == ShapeType.MULTIPOINT) {
            length = mp.getNumGeometries() * 16 + 40;
        } else if (this.shapeType == ShapeType.MULTIPOINTM) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries();
        } else if (this.shapeType == ShapeType.MULTIPOINTZ) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries() + 16 + 8 * mp.getNumGeometries();
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return (int)var3_3;
    }

    private Object createNull() {
        Coordinate[] c = null;
        return this.geometryFactory.createMultiPoint(c);
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numpoints = buffer.getInt();
        Coordinate[] coords = new Coordinate[numpoints];
        int t = 0;
        while (t < numpoints) {
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            coords[t] = new Coordinate(x, y);
            ++t;
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            buffer.position(buffer.position() + 16);
            t = 0;
            while (t < numpoints) {
                coords[t].z = buffer.getDouble();
                ++t;
            }
        }
        return this.geometryFactory.createMultiPoint(coords);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        Coordinate c;
        MultiPoint mp = (MultiPoint)geometry;
        int p = buffer.position();
        Envelope box = mp.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        buffer.putInt(mp.getNumGeometries());
        int t = 0;
        int tt = mp.getNumGeometries();
        while (t < tt) {
            c = mp.getGeometryN(t).getCoordinate();
            buffer.putDouble(c.x);
            buffer.putDouble(c.y);
            ++t;
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            double[] zExtreame = JTSUtilities.zMinMax(mp.getCoordinates());
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            int t2 = 0;
            while (t2 < mp.getNumGeometries()) {
                c = mp.getGeometryN(t2).getCoordinate();
                double z = c.z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                } else {
                    buffer.putDouble(z);
                }
                ++t2;
            }
        }
        if (this.shapeType == ShapeType.MULTIPOINTM || this.shapeType == ShapeType.MULTIPOINTZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            t = 0;
            while (t < mp.getNumGeometries()) {
                buffer.putDouble(-1.0E41);
                ++t;
            }
        }
    }
}

