/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory = new GeometryFactory();

    public MultiLineHandler() {
        this.shapeType = ShapeType.ARC;
    }

    public MultiLineHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.ARC && type != ShapeType.ARCM && type != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    /*
     * WARNING - void declaration
     */
    public int getLength(Object geometry) {
        void var5_5;
        int length;
        MultiLineString multi = (MultiLineString)geometry;
        int numlines = multi.getNumGeometries();
        int numpoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.ARC) {
            length = 44 + 4 * numlines + numpoints * 16;
        } else if (this.shapeType == ShapeType.ARCM) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints;
        } else if (this.shapeType == ShapeType.ARCZ) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 + 8 + 8 * numpoints + 8 + 8 + 8 * numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return (int)var5_5;
    }

    private Object createNull() {
        return this.geometryFactory.createLineString(null);
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        int i = 0;
        while (i < numParts) {
            partOffsets[i] = buffer.getInt();
            ++i;
        }
        LineString[] lines = new LineString[numParts];
        Coordinate[] coords = new Coordinate[numPoints];
        int t = 0;
        while (t < numPoints) {
            coords[t] = new Coordinate(buffer.getDouble(), buffer.getDouble());
            ++t;
        }
        if (this.shapeType == ShapeType.ARCZ) {
            buffer.position(buffer.position() + 16);
            t = 0;
            while (t < numPoints) {
                coords[t].z = buffer.getDouble();
                ++t;
            }
        }
        int offset = 0;
        int part = 0;
        while (part < numParts) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            Coordinate[] points = new Coordinate[length];
            int i2 = 0;
            while (i2 < length) {
                points[i2] = coords[offset];
                ++offset;
                ++i2;
            }
            lines[part] = this.geometryFactory.createLineString(points);
            ++part;
        }
        return this.geometryFactory.createMultiLineString(lines);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        MultiLineString multi = (MultiLineString)geometry;
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int numParts = multi.getNumGeometries();
        buffer.putInt(numParts);
        int npoints = multi.getNumPoints();
        buffer.putInt(npoints);
        LineString[] lines = new LineString[numParts];
        int idx = 0;
        int i = 0;
        while (i < numParts) {
            lines[i] = (LineString)multi.getGeometryN(i);
            buffer.putInt(idx);
            idx += lines[i].getNumPoints();
            ++i;
        }
        Coordinate[] coords = multi.getCoordinates();
        int t = 0;
        while (t < npoints) {
            buffer.putDouble(coords[t].x);
            buffer.putDouble(coords[t].y);
            ++t;
        }
        if (this.shapeType == ShapeType.ARCZ) {
            double[] zExtreame = JTSUtilities.zMinMax(coords);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            int t2 = 0;
            while (t2 < npoints) {
                double z = coords[t2].z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                } else {
                    buffer.putDouble(z);
                }
                ++t2;
            }
        }
        if (this.shapeType == ShapeType.ARCZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            t = 0;
            while (t < npoints) {
                buffer.putDouble(-1.0E41);
                ++t;
            }
        }
    }
}

