/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class JTSUtilities {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    private JTSUtilities() {
    }

    public static final double[] zMinMax(Coordinate[] cs) {
        boolean validZFound = false;
        double[] result = new double[2];
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        int t = cs.length - 1;
        while (t >= 0) {
            double z = cs[t].z;
            if (!Double.isNaN(z)) {
                if (validZFound) {
                    if (z < zmin) {
                        zmin = z;
                    }
                    if (z > zmax) {
                        zmax = z;
                    }
                } else {
                    validZFound = true;
                    zmin = z;
                    zmax = z;
                }
            }
            --t;
        }
        result[0] = zmin;
        result[1] = zmax;
        return result;
    }

    public static final ShapeType findBestGeometryType(Geometry geom) {
        ShapeType type = ShapeType.UNDEFINED;
        if (geom instanceof Point) {
            type = ShapeType.POINT;
        } else if (geom instanceof MultiPoint) {
            type = ShapeType.MULTIPOINT;
        } else if (geom instanceof Polygon) {
            type = ShapeType.POLYGON;
        } else if (geom instanceof MultiPolygon) {
            type = ShapeType.POLYGON;
        } else if (geom instanceof LineString) {
            type = ShapeType.ARC;
        } else if (geom instanceof MultiLineString) {
            type = ShapeType.ARC;
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public static final Class findBestGeometryClass(ShapeType type) {
        void var1_1;
        Class<?> best;
        if (type == null || type == ShapeType.NULL) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.vividsolutions.jts.geom.Geometry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            best = clazz;
        } else if (type.isLineType()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.vividsolutions.jts.geom.MultiLineString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            best = clazz;
        } else if (type.isMultiPointType()) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("com.vividsolutions.jts.geom.MultiPoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            best = clazz;
        } else if (type.isPointType()) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("com.vividsolutions.jts.geom.Point");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            best = clazz;
        } else if (type.isPolygonType()) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("com.vividsolutions.jts.geom.MultiPolygon");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            best = clazz;
        } else {
            throw new RuntimeException("Unknown ShapeType->GeometryClass : " + type);
        }
        return var1_1;
    }

    public static final LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints() - 1;
        Coordinate[] newCoords = new Coordinate[numPoints + 1];
        int t = numPoints;
        while (t >= 0) {
            newCoords[t] = lr.getCoordinateN(numPoints - t);
            --t;
        }
        return new LinearRing(newCoords, lr.getPrecisionModel(), lr.getSRID());
    }

    public static final Polygon makeGoodShapePolygon(Polygon p) {
        LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
        RobustCGAlgorithms cga = new RobustCGAlgorithms();
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        LinearRing outer = cga.isCCW(coords) ? JTSUtilities.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
        int t = 0;
        int tt = p.getNumInteriorRing();
        while (t < tt) {
            coords = p.getInteriorRingN(t).getCoordinates();
            holes[t] = !cga.isCCW(coords) ? JTSUtilities.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
            ++t;
        }
        return new Polygon(outer, holes, p.getPrecisionModel(), p.getSRID());
    }

    public static final MultiPolygon makeGoodShapeMultiPolygon(MultiPolygon mp) {
        Polygon[] ps = new Polygon[mp.getNumGeometries()];
        int t = 0;
        while (t < mp.getNumGeometries()) {
            ps[t] = JTSUtilities.makeGoodShapePolygon((Polygon)mp.getGeometryN(t));
            ++t;
        }
        MultiPolygon result = new MultiPolygon(ps, new PrecisionModel(), 0);
        return result;
    }

    public static final int guessCoorinateDims(Coordinate[] cs) {
        int dims = 2;
        int t = cs.length - 1;
        while (t >= 0) {
            if (!Double.isNaN(cs[t].z)) {
                dims = 4;
                break;
            }
            --t;
        }
        return dims;
    }

    public static final ShapeType getShapeType(Geometry geom, int shapeFileDimentions) throws ShapefileException {
        ShapeType type;
        block23: {
            block25: {
                block24: {
                    block22: {
                        type = null;
                        if (!(geom instanceof Point)) break block22;
                        switch (shapeFileDimentions) {
                            case 2: {
                                type = ShapeType.POINT;
                                break block23;
                            }
                            case 3: {
                                type = ShapeType.POINTM;
                                break block23;
                            }
                            case 4: {
                                type = ShapeType.POINTZ;
                                break block23;
                            }
                            default: {
                                throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                            }
                        }
                    }
                    if (!(geom instanceof MultiPoint)) break block24;
                    switch (shapeFileDimentions) {
                        case 2: {
                            type = ShapeType.MULTIPOINT;
                            break block23;
                        }
                        case 3: {
                            type = ShapeType.MULTIPOINTM;
                            break block23;
                        }
                        case 4: {
                            type = ShapeType.MULTIPOINTZ;
                            break block23;
                        }
                        default: {
                            throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                        }
                    }
                }
                if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) break block25;
                switch (shapeFileDimentions) {
                    case 2: {
                        type = ShapeType.POLYGON;
                        break block23;
                    }
                    case 3: {
                        type = ShapeType.POLYGONM;
                        break block23;
                    }
                    case 4: {
                        type = ShapeType.POLYGONZ;
                        break block23;
                    }
                    default: {
                        throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                    }
                }
            }
            if (geom instanceof LineString || geom instanceof MultiLineString) {
                switch (shapeFileDimentions) {
                    case 2: {
                        type = ShapeType.ARC;
                        break;
                    }
                    case 3: {
                        type = ShapeType.ARCM;
                        break;
                    }
                    case 4: {
                        type = ShapeType.ARCZ;
                        break;
                    }
                    default: {
                        throw new ShapefileException("Too many dimensions for shapefile : " + shapeFileDimentions);
                    }
                }
            }
        }
        if (type == null) {
            throw new ShapefileException("Cannot handle geometry type : " + (geom == null ? "null" : geom.getClass().getName()));
        }
        return type;
    }
}

