/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.ReadableByteChannel;
import org.geotools.data.shapefile.shp.ShapefileHeader;

public class IndexFile {
    private ShapefileHeader header = null;
    private int[] content;

    public IndexFile(ReadableByteChannel channel) throws IOException {
        this.readHeader(channel);
        this.readRecords(channel);
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    private void readHeader(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        while (buffer.remaining() > 0) {
            channel.read(buffer);
        }
        buffer.flip();
        this.header = new ShapefileHeader();
        this.header.read(buffer, true);
    }

    private void readRecords(ReadableByteChannel channel) throws IOException {
        int remaining = this.header.getFileLength() * 2 - 100;
        ByteBuffer buffer = ByteBuffer.allocateDirect(remaining);
        buffer.order(ByteOrder.BIG_ENDIAN);
        while (buffer.remaining() > 0) {
            channel.read(buffer);
        }
        buffer.flip();
        int records = remaining / 4;
        this.content = new int[records];
        IntBuffer ints = buffer.asIntBuffer();
        ints.get(this.content);
    }

    public int getRecordCount() {
        return this.content.length / 2;
    }

    public int getOffset(int index) {
        return this.content[2 * index];
    }

    public int getContentLength(int index) {
        return this.content[2 * index + 1];
    }
}

