/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.dbf.DbaseFileException;

public class DbaseFileHeader {
    private static final int FILE_DESCRIPTOR_SIZE = 32;
    private static final byte MAGIC = 3;
    private static final int MINIMUM_HEADER = 33;
    private Date date = new Date();
    private int recordCnt = 0;
    private int fieldCnt = 0;
    private int recordLength = 1;
    private int headerLength = -1;
    private int largestFieldSize = 0;
    private Logger logger = Logger.getLogger("org.geotools.data.shapefile");
    private DbaseField[] fields = new DbaseField[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    private void read(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        while (buffer.remaining() > 0) {
            if (channel.read(buffer) != -1) continue;
            throw new EOFException("Premature end of file");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class getFieldClass(int i) {
        Class<?> clazz;
        Class<?> typeClass = null;
        switch (this.fields[i].fieldType) {
            case 'C': {
                Class<?> clazz2;
                Class<?> clazz3 = class$0;
                Class<?> clazz4 = clazz3;
                if (clazz3 != null) return clazz4;
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz4 = class$0 = clazz2;
                return clazz4;
            }
            case 'N': {
                Class<?> clazz5;
                if (this.fields[i].decimalCount == 0) {
                    Class<?> clazz6;
                    Class<?> clazz7 = class$1;
                    Class<?> clazz8 = clazz7;
                    if (clazz7 != null) return clazz8;
                    try {
                        clazz6 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz8 = class$1 = clazz6;
                    return clazz8;
                }
                Class<?> clazz9 = class$2;
                Class<?> clazz10 = clazz9;
                if (clazz9 != null) return clazz10;
                try {
                    clazz5 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz10 = class$2 = clazz5;
                return clazz10;
            }
            case 'F': {
                Class<?> clazz11;
                Class<?> clazz12 = class$2;
                Class<?> clazz13 = clazz12;
                if (clazz12 != null) return clazz13;
                try {
                    clazz11 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz13 = class$2 = clazz11;
                return clazz13;
            }
            case 'L': {
                Class<?> clazz14;
                Class<?> clazz15 = class$3;
                Class<?> clazz16 = clazz15;
                if (clazz15 != null) return clazz16;
                try {
                    clazz14 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz16 = class$3 = clazz14;
                return clazz16;
            }
            case 'D': {
                Class<?> clazz17;
                Class<?> clazz18 = class$4;
                Class<?> clazz19 = clazz18;
                if (clazz18 != null) return clazz19;
                try {
                    clazz17 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz19 = class$4 = clazz17;
                return clazz19;
            }
        }
        Class<?> clazz20 = class$0;
        Class<?> clazz21 = clazz20;
        if (clazz20 != null) return clazz21;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        clazz21 = class$0 = clazz;
        return clazz21;
    }

    public void addColumn(String inFieldName, char inFieldType, int inFieldLength, int inDecimalCount) throws DbaseFileException {
        if (inFieldLength <= 0) {
            throw new DbaseFileException("field length <= 0");
        }
        if (this.fields == null) {
            this.fields = new DbaseField[0];
        }
        int tempLength = 1;
        DbaseField[] tempFieldDescriptors = new DbaseField[this.fields.length + 1];
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i].fieldDataAddress = tempLength;
            tempLength += this.fields[i].fieldLength;
            tempFieldDescriptors[i] = this.fields[i];
            ++i;
        }
        tempFieldDescriptors[this.fields.length] = new DbaseField();
        tempFieldDescriptors[this.fields.length].fieldLength = inFieldLength;
        tempFieldDescriptors[this.fields.length].decimalCount = inDecimalCount;
        tempFieldDescriptors[this.fields.length].fieldDataAddress = tempLength;
        String tempFieldName = inFieldName;
        if (tempFieldName == null) {
            tempFieldName = "NoName";
        }
        if (tempFieldName.length() > 11) {
            tempFieldName = tempFieldName.substring(0, 11);
            this.warn("FieldName " + inFieldName + " is longer than 11 characters, truncating to " + tempFieldName);
        }
        tempFieldDescriptors[this.fields.length].fieldName = tempFieldName;
        if (inFieldType == 'C' || inFieldType == 'c') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)67;
            if (inFieldLength > 254) {
                this.warn("Field Length for " + inFieldName + " set to " + inFieldLength + " Which is longer than 254, not consistent with dbase III");
            }
        } else if (inFieldType == 'S' || inFieldType == 's') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)67;
            this.warn("Field type for " + inFieldName + " set to S which is flat out wrong people!, I am setting this to C, in the hopes you meant character.");
            if (inFieldLength > 254) {
                this.warn("Field Length for " + inFieldName + " set to " + inFieldLength + " Which is longer than 254, not consistent with dbase III");
            }
            tempFieldDescriptors[this.fields.length].fieldLength = 8;
        } else if (inFieldType == 'D' || inFieldType == 'd') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)68;
            if (inFieldLength != 8) {
                this.warn("Field Length for " + inFieldName + " set to " + inFieldLength + " Setting to 8 digets YYYYMMDD");
            }
            tempFieldDescriptors[this.fields.length].fieldLength = 8;
        } else if (inFieldType == 'F' || inFieldType == 'f') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)70;
            if (inFieldLength > 20) {
                this.warn("Field Length for " + inFieldName + " set to " + inFieldLength + " Preserving length, but should be set to Max of 20 not valid for dbase IV, and UP specification, not present in dbaseIII.");
            }
        } else if (inFieldType == 'N' || inFieldType == 'n') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)78;
            if (inFieldLength > 18) {
                this.warn("Field Length for " + inFieldName + " set to " + inFieldLength + " Preserving length, but should be set to Max of 18 for dbase III specification.");
            }
            if (inDecimalCount < 0) {
                this.warn("Field Decimal Position for " + inFieldName + " set to " + inDecimalCount + " Setting to 0 no decimal data will be saved.");
                tempFieldDescriptors[this.fields.length].decimalCount = 0;
            }
            if (inDecimalCount > inFieldLength - 1) {
                this.warn("Field Decimal Position for " + inFieldName + " set to " + inDecimalCount + " Setting to " + (inFieldLength - 1) + " no non decimal data will be saved.");
                tempFieldDescriptors[this.fields.length].decimalCount = inFieldLength - 1;
            }
        } else if (inFieldType == 'L' || inFieldType == 'l') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)76;
            if (inFieldLength != 1) {
                this.warn("Field Length for " + inFieldName + " set to " + inFieldLength + " Setting to length of 1 for logical fields.");
            }
            tempFieldDescriptors[this.fields.length].fieldLength = 1;
        } else {
            throw new DbaseFileException("Undefined field type " + inFieldType + " For column " + inFieldName);
        }
        this.fields = tempFieldDescriptors;
        this.headerLength = 33 + 32 * this.fields.length;
        this.recordLength = tempLength += tempFieldDescriptors[this.fields.length].fieldLength;
    }

    public int removeColumn(String inFieldName) {
        int retCol = -1;
        int tempLength = 1;
        DbaseField[] tempFieldDescriptors = new DbaseField[this.fields.length - 1];
        int i = 0;
        int j = 0;
        while (i < this.fields.length) {
            if (!inFieldName.equalsIgnoreCase(this.fields[i].fieldName.trim())) {
                if (i == j && i == this.fields.length - 1) {
                    System.err.println("Could not find a field named '" + inFieldName + "' for removal");
                    return retCol;
                }
                tempFieldDescriptors[j] = this.fields[i];
                tempFieldDescriptors[j].fieldDataAddress = tempLength;
                tempLength += tempFieldDescriptors[j].fieldLength;
                ++j;
            } else {
                retCol = i;
            }
            ++i;
        }
        this.fields = tempFieldDescriptors;
        this.headerLength = 33 + 32 * this.fields.length;
        this.recordLength = tempLength;
        return retCol;
    }

    private void warn(String inWarn) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(inWarn);
        }
    }

    public int getFieldLength(int inIndex) {
        return this.fields[inIndex].fieldLength;
    }

    public int getFieldDecimalCount(int inIndex) {
        return this.fields[inIndex].decimalCount;
    }

    public String getFieldName(int inIndex) {
        return this.fields[inIndex].fieldName;
    }

    public char getFieldType(int inIndex) {
        return this.fields[inIndex].fieldType;
    }

    public Date getLastUpdateDate() {
        return this.date;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public int getNumRecords() {
        return this.recordCnt;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void readHeader(ReadableByteChannel channel) throws IOException {
        ByteBuffer in = ByteBuffer.allocateDirect(1024);
        in.order(ByteOrder.LITTLE_ENDIAN);
        in.limit(10);
        this.read(in, channel);
        in.position(0);
        byte magic = in.get();
        if (magic != 3) {
            throw new IOException("Unsupported DBF file Type " + Integer.toHexString(magic));
        }
        int tempUpdateYear = in.get();
        byte tempUpdateMonth = in.get();
        byte tempUpdateDay = in.get();
        tempUpdateYear = tempUpdateYear > 90 ? (tempUpdateYear += 1900) : (tempUpdateYear += 2000);
        Calendar c = Calendar.getInstance();
        c.set(1, tempUpdateYear);
        c.set(2, tempUpdateMonth - 1);
        c.set(5, tempUpdateDay);
        this.date = c.getTime();
        this.recordCnt = in.getInt();
        this.headerLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
        if (this.headerLength > in.capacity()) {
            in = ByteBuffer.allocateDirect(this.headerLength - 10);
        }
        in.limit(this.headerLength - 10);
        in.position(0);
        this.read(in, channel);
        in.position(0);
        this.recordLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
        in.position(in.position() + 20);
        this.fieldCnt = (this.headerLength - 32 - 1) / 32;
        ArrayList<DbaseField> lfields = new ArrayList<DbaseField>();
        int i = 0;
        while (i < this.fieldCnt) {
            DbaseField field = new DbaseField();
            byte[] buffer = new byte[11];
            in.get(buffer);
            String name = new String(buffer);
            int nullPoint = name.indexOf(0);
            if (nullPoint != -1) {
                name = name.substring(0, nullPoint);
            }
            field.fieldName = name.trim();
            field.fieldType = (char)in.get();
            field.fieldDataAddress = in.getInt();
            int length = in.get();
            if (length < 0) {
                length += 256;
            }
            field.fieldLength = length;
            if (length > this.largestFieldSize) {
                this.largestFieldSize = length;
            }
            field.decimalCount = in.get();
            in.position(in.position() + 14);
            if (field.fieldLength > 0) {
                lfields.add(field);
            }
            ++i;
        }
        in.position(in.position() + 1);
        this.fields = new DbaseField[lfields.size()];
        this.fields = lfields.toArray(this.fields);
    }

    public int getLargestFieldSize() {
        return this.largestFieldSize;
    }

    public void setNumRecords(int inNumRecords) {
        this.recordCnt = inNumRecords;
    }

    public void writeHeader(WritableByteChannel out) throws IOException {
        if (this.headerLength == -1) {
            this.headerLength = 33;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.headerLength);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)3);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        buffer.put((byte)(c.get(1) % 100));
        buffer.put((byte)(c.get(2) + 1));
        buffer.put((byte)c.get(5));
        buffer.putInt(this.recordCnt);
        buffer.putShort((short)this.headerLength);
        buffer.putShort((short)this.recordLength);
        buffer.position(buffer.position() + 20);
        int tempOffset = 0;
        int i = 0;
        while (i < this.fields.length) {
            int j = 0;
            while (j < 11) {
                if (this.fields[i].fieldName.length() > j) {
                    buffer.put((byte)this.fields[i].fieldName.charAt(j));
                } else {
                    buffer.put((byte)0);
                }
                ++j;
            }
            buffer.put((byte)this.fields[i].fieldType);
            buffer.putInt(tempOffset);
            tempOffset += this.fields[i].fieldLength;
            buffer.put((byte)this.fields[i].fieldLength);
            buffer.put((byte)this.fields[i].decimalCount);
            buffer.position(buffer.position() + 14);
            ++i;
        }
        buffer.put((byte)13);
        buffer.position(0);
        int r = buffer.remaining();
        while ((r -= out.write(buffer)) > 0) {
        }
    }

    public String toString() {
        StringBuffer fs = new StringBuffer();
        int i = 0;
        int ii = this.fields.length;
        while (i < ii) {
            DbaseField f = this.fields[i];
            fs.append(String.valueOf(f.fieldName) + " " + f.fieldType + " " + f.fieldLength + " " + f.decimalCount + " " + f.fieldDataAddress + "\n");
            ++i;
        }
        return "DB3 Header\nDate : " + this.date + "\n" + "Records : " + this.recordCnt + "\n" + "Fields : " + this.fieldCnt + "\n" + fs;
    }

    class DbaseField {
        String fieldName;
        char fieldType;
        int fieldDataAddress;
        int fieldLength;
        int decimalCount;

        DbaseField() {
        }
    }
}

