/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;

public class ShapefileDataSource
extends AbstractDataSource {
    private URL shpURL;
    private URL dbfURL;
    private URL shxURL;
    private FeatureType schema = null;
    private IDFactory idFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public ShapefileDataSource(URL url) throws MalformedURLException {
        String filename = null;
        if (url == null) {
            throw new NullPointerException("Null URL for ShapefileDataSource");
        }
        try {
            filename = URLDecoder.decode(url.toString(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        String shpext = ".shp";
        String dbfext = ".dbf";
        String shxext = ".shx";
        if (filename.endsWith(shpext) || filename.endsWith(dbfext) || filename.endsWith(shxext)) {
            filename = filename.substring(0, filename.length() - 4);
        } else if (filename.endsWith(".SHP") || filename.endsWith(".DBF") || filename.endsWith(".SHX")) {
            filename = filename.substring(0, filename.length() - 4);
            shpext = ".SHP";
            dbfext = ".DBF";
            shxext = ".SHX";
        }
        this.shpURL = new URL(String.valueOf(filename) + shpext);
        this.dbfURL = new URL(String.valueOf(filename) + dbfext);
        this.shxURL = new URL(String.valueOf(filename) + shxext);
    }

    public IDFactory getIDFactory() {
        if (this.idFactory == null) {
            this.idFactory = new DefaultIDFactory();
        }
        return this.idFactory;
    }

    public void setIDFactory(IDFactory f) {
        this.idFactory = f;
    }

    public void abortLoading() {
    }

    public Envelope getBounds() throws DataSourceException {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(100);
            ReadableByteChannel in = ShapefileDataSource.getReadChannel(this.shpURL);
            in.read(buffer);
            buffer.flip();
            ShapefileHeader header = new ShapefileHeader();
            header.read(buffer, true);
            return new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
        }
        catch (IOException ioe) {
            throw new DataSourceException("Problem getting Bbox", ioe);
        }
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        try {
            ReadableByteChannel channel;
            Filter filter = null;
            if (query != null) {
                filter = query.getFilter();
            }
            if ((channel = ShapefileDataSource.getReadChannel(this.shpURL)) == null) {
                throw new DataSourceException("Non existent file or problems opening file: " + this.shpURL);
            }
            ShapefileReader shp = new ShapefileReader(channel);
            DbaseFileReader dbf = this.createDbaseReader();
            int[] mapping = query.retrieveAllProperties() ? new int[dbf.getHeader().getNumFields() + 1] : new int[query.getPropertyNames().length];
            FeatureType type = this.getSchema(shp, dbf, query, mapping);
            FeatureMaker features = new FeatureMaker(dbf, shp, type, mapping);
            while (features.hasNext()) {
                Feature f = features.next();
                if (filter != null && !filter.contains(f)) continue;
                collection.add(f);
            }
            shp.close();
            if (dbf != null) {
                dbf.close();
            }
        }
        catch (IOException ioe) {
            throw new DataSourceException("IO Exception loading data", ioe);
        }
        catch (TopologyException te) {
            throw new DataSourceException("Topology Exception loading data", te);
        }
        catch (IllegalAttributeException ife) {
            throw new DataSourceException("Illegal Attribute Exception loading data", ife);
        }
        catch (ShapefileException ise) {
            throw new DataSourceException("Illegal Feature Exception loading data", ise);
        }
    }

    private FeatureType getSchema(ShapefileReader shp, DbaseFileReader dbf, Query q, int[] sel) throws DataSourceException, IOException, ShapefileException {
        this.schema = this.getFeatureType(dbf == null ? this.createDbaseReader() : dbf, shp == null ? new ShapefileReader(ShapefileDataSource.getReadChannel(this.shpURL)) : shp, q, sel);
        return this.schema;
    }

    public FeatureType getSchema() throws DataSourceException {
        try {
            return this.getSchema(null, null, new DefaultQuery(), null);
        }
        catch (ShapefileException e) {
            throw new DataSourceException("Invalid Shapefile", e);
        }
        catch (IOException e) {
            throw new DataSourceException("IO problem reading shapefile", e);
        }
    }

    public void setSchema(FeatureType schema) throws DataSourceException {
        this.schema = schema;
    }

    private DbaseFileReader createDbaseReader() throws IOException {
        ReadableByteChannel channel;
        DbaseFileReader reader = null;
        if (this.dbfURL != null && (channel = ShapefileDataSource.getReadChannel(this.dbfURL)) != null) {
            reader = new DbaseFileReader(channel);
        }
        return reader;
    }

    private static ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.exists() || !file.canRead()) {
                throw new IOException("File either doesn't exist or is unreadable : " + file);
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    private static WritableByteChannel getWriteChannel(URL url) throws IOException {
        WritableByteChannel channel;
        if (url.getProtocol().equals("file")) {
            File f = new File(url.getFile());
            f.delete();
            if (!f.exists() && !f.createNewFile()) {
                throw new IOException("Cannot create file " + f);
            }
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            channel = raf.getChannel();
        } else {
            OutputStream out = url.openConnection().getOutputStream();
            channel = Channels.newChannel(out);
        }
        return channel;
    }

    protected AttributeType[] determineAttributeTypes(AttributeType[] ds, Query q, int[] sel) {
        AttributeType[] attTypes;
        if (q.retrieveAllProperties()) {
            int i = 0;
            int ii = sel.length;
            while (i < ii) {
                sel[i] = i;
                ++i;
            }
            attTypes = ds;
        } else {
            HashMap<String, Object[]> positions = new HashMap<String, Object[]>(ds.length);
            int i = 0;
            int ii = ds.length;
            while (i < ii) {
                positions.put(ds[i].getName(), new Object[]{new Integer(i), ds[i]});
                ++i;
            }
            String[] qat = q.getPropertyNames();
            ArrayList<Object> types = new ArrayList<Object>(qat.length);
            int i2 = 0;
            int ii2 = qat.length;
            while (i2 < ii2) {
                Object[] entry = (Object[])positions.get(qat[i2]);
                int n = sel[i2] = entry == null ? -1 : (Integer)entry[0];
                if (sel[i2] >= 0) {
                    types.add(entry[1]);
                }
                ++i2;
            }
            attTypes = types.toArray(new AttributeType[types.size()]);
        }
        return attTypes;
    }

    private AttributeType[] getAttributeTypes(DbaseFileReader dbf, ShapeType type) {
        AttributeType[] atts;
        AttributeType geometryAttribute = AttributeTypeFactory.newAttributeType("the_geom", JTSUtilities.findBestGeometryClass(type));
        if (dbf != null) {
            DbaseFileHeader header = dbf.getHeader();
            atts = new AttributeType[header.getNumFields() + 1];
            atts[0] = geometryAttribute;
            int i = 0;
            int ii = header.getNumFields();
            while (i < ii) {
                Class clazz = header.getFieldClass(i);
                atts[i + 1] = AttributeTypeFactory.newAttributeType(header.getFieldName(i), clazz);
                ++i;
            }
        } else {
            atts = new AttributeType[]{geometryAttribute};
        }
        return atts;
    }

    private FeatureType getFeatureType(DbaseFileReader dbf, ShapefileReader shp, Query q, int[] sel) throws IOException, DataSourceException {
        ShapeType t = shp.getHeader().getShapeType();
        AttributeType[] types = this.getAttributeTypes(dbf, t);
        if (sel == null) {
            sel = new int[types.length];
            int i = 0;
            int ii = sel.length;
            while (i < ii) {
                sel[i] = i;
                ++i;
            }
        }
        types = this.determineAttributeTypes(types, q, sel);
        try {
            return FeatureTypeFactory.newFeatureType(types, this.getTypeName());
        }
        catch (SchemaException se) {
            throw new DataSourceException("Schema Error", se);
        }
    }

    protected final DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport shpMeta = new AbstractDataSource.MetaDataSupport();
        shpMeta.setSupportsGetBbox(true);
        shpMeta.setFastBbox(true);
        shpMeta.setSupportsSetFeatures(true);
        return shpMeta;
    }

    private String getTypeName() {
        String path = this.shpURL.getPath();
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            dot = path.length();
        }
        int slash = path.lastIndexOf(47) + 1;
        return path.substring(slash, dot);
    }

    public void setFeatures(FeatureCollection collection) throws DataSourceException {
        try {
            GeometryCollection gc = this.makeShapeGeometryCollection(collection);
            int shapeDims = 2;
            if (gc.getNumGeometries() > 0) {
                shapeDims = JTSUtilities.guessCoorinateDims(gc.getGeometryN(0).getCoordinates());
            }
            ShapefileWriter writer = new ShapefileWriter(ShapefileDataSource.getWriteChannel(this.shpURL), ShapefileDataSource.getWriteChannel(this.shxURL));
            writer.write(gc, JTSUtilities.getShapeType(gc.getGeometryN(0), shapeDims));
            this.writeDbf(collection);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Something went wrong during shapefile saving", se);
        }
        catch (DbaseFileException dfe) {
            throw new DataSourceException("Something went wrong during shapefile saving", dfe);
        }
        catch (IOException e) {
            throw new DataSourceException("IOException during shapefile saving", e);
        }
        catch (RuntimeException e) {
            throw new DataSourceException("Something went wrong during shapefile saving", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeDbf(FeatureCollection featureCollection) throws DbaseFileException, IOException {
        it = featureCollection.features();
        if (!it.hasNext()) {
            throw new IOException("Empty featureCollection");
        }
        types = it.next().getFeatureType().getAttributeTypes();
        supported = new int[types.length];
        numAttributes = 0;
        i = 0;
        while (i < types.length) {
            currType = types[i].getType();
            v0 = ShapefileDataSource.class$0;
            if (v0 == null) {
                try {
                    v0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
            }
            if (currType == v0) ** GOTO lbl-1000
            v2 = ShapefileDataSource.class$1;
            if (v2 == null) {
                try {
                    v2 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException v3) {
                    throw new NoClassDefFoundError(v3.getMessage());
                }
            }
            if (currType == v2) ** GOTO lbl-1000
            v4 = ShapefileDataSource.class$2;
            if (v4 == null) {
                try {
                    v4 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException v5) {
                    throw new NoClassDefFoundError(v5.getMessage());
                }
            }
            if (v4.isAssignableFrom(currType)) ** GOTO lbl-1000
            v6 = ShapefileDataSource.class$3;
            if (v6 == null) {
                try {
                    v6 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException v7) {
                    throw new NoClassDefFoundError(v7.getMessage());
                }
            }
            if (v6.isAssignableFrom(currType)) lbl-1000:
            // 4 sources

            {
                supported[i] = ++numAttributes;
            } else {
                v8 = ShapefileDataSource.class$4;
                if (v8 == null) {
                    try {
                        v8 = Class.forName("com.vividsolutions.jts.geom.Geometry");
                    }
                    catch (ClassNotFoundException v9) {
                        throw new NoClassDefFoundError(v9.getMessage());
                    }
                }
                if (!v8.isAssignableFrom(currType)) {
                    throw new DbaseFileException("Shapefile: unsupported type found in feature schema : " + currType.getName());
                }
            }
            ++i;
        }
        header = new DbaseFileHeader();
        i = 0;
        while (i < types.length) {
            block63: {
                block62: {
                    block61: {
                        colType = types[i].getType();
                        colName = types[i].getName();
                        v10 = ShapefileDataSource.class$5;
                        if (v10 == null) {
                            try {
                                v10 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException v11) {
                                throw new NoClassDefFoundError(v11.getMessage());
                            }
                        }
                        if (colType == v10) break block61;
                        v12 = ShapefileDataSource.class$6;
                        if (v12 == null) {
                            try {
                                v12 = Class.forName("java.lang.Short");
                            }
                            catch (ClassNotFoundException v13) {
                                throw new NoClassDefFoundError(v13.getMessage());
                            }
                        }
                        if (colType == v12) break block61;
                        v14 = ShapefileDataSource.class$7;
                        if (v14 == null) {
                            try {
                                v14 = Class.forName("java.lang.Byte");
                            }
                            catch (ClassNotFoundException v15) {
                                throw new NoClassDefFoundError(v15.getMessage());
                            }
                        }
                        if (colType != v14) break block62;
                    }
                    header.addColumn(colName, 'N', 16, 0);
                    break block63;
                }
                v16 = ShapefileDataSource.class$8;
                if (v16 == null) {
                    try {
                        v16 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException v17) {
                        throw new NoClassDefFoundError(v17.getMessage());
                    }
                }
                if (colType == v16) ** GOTO lbl-1000
                v18 = ShapefileDataSource.class$9;
                if (v18 == null) {
                    try {
                        v18 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException v19) {
                        throw new NoClassDefFoundError(v19.getMessage());
                    }
                }
                if (colType == v18) lbl-1000:
                // 2 sources

                {
                    header.addColumn(colName, 'N', 33, 16);
                } else {
                    v20 = ShapefileDataSource.class$3;
                    if (v20 == null) {
                        try {
                            v20 = Class.forName("java.util.Date");
                        }
                        catch (ClassNotFoundException v21) {
                            throw new NoClassDefFoundError(v21.getMessage());
                        }
                    }
                    if (v20.isAssignableFrom(colType)) {
                        header.addColumn(colName, 'D', 8, 0);
                    } else {
                        v22 = ShapefileDataSource.class$1;
                        if (v22 == null) {
                            try {
                                v22 = Class.forName("java.lang.Boolean");
                            }
                            catch (ClassNotFoundException v23) {
                                throw new NoClassDefFoundError(v23.getMessage());
                            }
                        }
                        if (colType == v22) {
                            header.addColumn(colName, 'L', 1, 0);
                        } else {
                            v24 = ShapefileDataSource.class$0;
                            if (v24 == null) {
                                try {
                                    v24 = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException v25) {
                                    throw new NoClassDefFoundError(v25.getMessage());
                                }
                            }
                            if (colType == v24) {
                                maxlength = this.findMaxStringLength(featureCollection, i);
                                if (maxlength > 255) {
                                    throw new DbaseFileException("Shapefile does not support strings longer than 255 characters");
                                }
                                header.addColumn(colName, 'C', maxlength, 0);
                            } else {
                                v26 = ShapefileDataSource.class$4;
                                if (v26 == null) {
                                    try {
                                        v26 = Class.forName("com.vividsolutions.jts.geom.Geometry");
                                    }
                                    catch (ClassNotFoundException v27) {
                                        throw new NoClassDefFoundError(v27.getMessage());
                                    }
                                }
                                if (!v26.isAssignableFrom(colType)) {
                                    throw new DbaseFileException("Unable to write : " + colType.getName());
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        header.setNumRecords(featureCollection.size());
        dbf = new DbaseFileWriter(header, ShapefileDataSource.getWriteChannel(this.dbfURL));
        dbrow = new Object[numAttributes];
        attVals = new Object[types.length];
        it = featureCollection.features();
        while (it.hasNext()) {
            it.next().getAttributes(attVals);
            idx = 0;
            j = 0;
            while (j < types.length) {
                if (supported[j] > 0) {
                    dbrow[idx++] = this.forAttribute(attVals[j], types[j].getType());
                }
                ++j;
            }
            dbf.write(dbrow);
        }
        dbf.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object forAttribute(Object o, Class colType) {
        void var3_3;
        Object object;
        block42: {
            block41: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (colType == clazz) {
                    object = o;
                    return var3_3;
                }
                Class<?> clazz2 = class$6;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$6 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (colType == clazz2) break block41;
                Class<?> clazz3 = class$7;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$7 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (colType != clazz3) break block42;
            }
            object = new Integer(((Number)o).intValue());
            return var3_3;
        }
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (colType == clazz) {
            object = o;
            return var3_3;
        }
        Class<?> clazz4 = class$9;
        if (clazz4 == null) {
            try {
                clazz4 = class$9 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (colType == clazz4) {
            object = new Double(((Number)o).doubleValue());
            return var3_3;
        }
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (colType == clazz5) {
            object = o == null ? o : o.toString();
            return var3_3;
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (colType == clazz6) {
            object = o;
            return var3_3;
        }
        Class<?> clazz7 = class$3;
        if (clazz7 == null) {
            try {
                clazz7 = class$3 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz7.isAssignableFrom(colType)) {
            object = o;
            return var3_3;
        } else {
            if (colType == null) throw new RuntimeException("Null Class for conversion");
            throw new RuntimeException("Cannot convert " + colType.getName());
        }
    }

    private int findMaxStringLength(FeatureCollection fc, int attributeNumber) {
        Iterator i = fc.iterator();
        int maxlen = 0;
        while (i.hasNext()) {
            int len;
            Feature f = (Feature)i.next();
            String s = (String)f.getAttribute(attributeNumber);
            if (s == null || (len = s.length()) <= maxlen) continue;
            maxlen = len;
        }
        return maxlen;
    }

    public GeometryCollection makeShapeGeometryCollection(FeatureCollection fc) throws DataSourceException {
        Geometry[] allGeoms = new Geometry[fc.size()];
        Iterator i = fc.iterator();
        if (!i.hasNext()) {
            throw new DataSourceException("Feature Collection is empty");
        }
        Feature f1 = (Feature)i.next();
        if (f1.getFeatureType().getDefaultGeometry() == null) {
            throw new DataSourceException("Feature has no geometry");
        }
        ShapeType type = JTSUtilities.findBestGeometryType(f1.getDefaultGeometry());
        if (type == ShapeType.NULL) {
            throw new DataSourceException("Could not determine shapefile type - data is either all GeometryCollections or empty");
        }
        i = fc.iterator();
        int t = 0;
        while (i.hasNext()) {
            Polygon[] p;
            Geometry geom = ((Feature)i.next()).getDefaultGeometry();
            if (type == ShapeType.POINT) {
                allGeoms[t] = geom instanceof Point ? geom : new MultiPoint(null, new PrecisionModel(), 0);
            } else if (type == ShapeType.ARC) {
                if (geom instanceof LineString) {
                    LineString[] l = new LineString[]{(LineString)geom};
                    allGeoms[t] = new MultiLineString(l, new PrecisionModel(), 0);
                } else {
                    allGeoms[t] = geom instanceof MultiLineString ? geom : new MultiLineString(null, new PrecisionModel(), 0);
                }
            } else if (type == ShapeType.POLYGON) {
                if (geom instanceof Polygon) {
                    p = new Polygon[]{(Polygon)geom};
                    allGeoms[t] = JTSUtilities.makeGoodShapeMultiPolygon(new MultiPolygon(p, geom.getPrecisionModel(), geom.getSRID()));
                } else {
                    allGeoms[t] = geom instanceof MultiPolygon ? JTSUtilities.makeGoodShapeMultiPolygon((MultiPolygon)geom) : new MultiPolygon(null, geom.getPrecisionModel(), geom.getSRID());
                }
            } else if (type == ShapeType.MULTIPOINT) {
                if (geom instanceof Point) {
                    p = new Point[]{(Point)geom};
                    allGeoms[t] = new MultiPoint((Point[])p, geom.getPrecisionModel(), geom.getSRID());
                } else {
                    allGeoms[t] = geom instanceof MultiPoint ? geom : new MultiPoint(null, geom.getPrecisionModel(), geom.getSRID());
                }
            }
            ++t;
        }
        GeometryCollection result = new GeometryCollection(allGeoms, allGeoms[0].getPrecisionModel(), allGeoms[0].getSRID());
        return result;
    }

    final class FeatureMaker {
        final int[] mapping;
        final DbaseFileReader dbf;
        final ShapefileReader shp;
        final Object[] readStash;
        final Object[] writeStash;
        final FeatureType type;
        final IDFactory id;
        int cnt = 0;

        public FeatureMaker(DbaseFileReader dbf, ShapefileReader shp, FeatureType type, int[] mapping) {
            this.dbf = dbf;
            this.shp = shp;
            this.mapping = mapping;
            this.type = type;
            this.readStash = new Object[dbf.getHeader().getNumFields()];
            this.writeStash = new Object[type.getAttributeTypes().length];
            this.id = ShapefileDataSource.this.getIDFactory();
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasNext() throws IOException {
            void var2_2;
            boolean more;
            int both = (this.shp.hasNext() ? 1 : 0) + (this.dbf.hasNext() ? 2 : 0);
            if (both == 3) {
                more = true;
            } else if (both == 0) {
                more = false;
            } else {
                throw new IllegalStateException(String.valueOf(both == 1 ? "shape" : "dbf") + "file has extra record (count = " + this.cnt + ")");
            }
            return (boolean)var2_2;
        }

        public Feature next() throws IOException, IllegalAttributeException {
            ShapefileReader.Record record = this.shp.nextRecord();
            DbaseFileReader.Row row = null;
            if (this.dbf != null) {
                row = this.dbf.readRow();
            }
            int i = 0;
            int ii = this.writeStash.length;
            while (i < ii) {
                int idx = this.mapping[i];
                if (idx == 0) {
                    this.writeStash[i] = record.shape();
                } else if (idx == -1) {
                    this.writeStash[i] = null;
                } else if (row != null) {
                    this.writeStash[i] = row.read(idx - 1);
                }
                ++i;
            }
            return this.type.create(this.writeStash, this.id.getFeatureID(++this.cnt));
        }
    }

    public static interface IDFactory {
        public String getFeatureID(int var1);
    }

    public class DefaultIDFactory
    implements IDFactory {
        final String file;

        public DefaultIDFactory() {
            this.file = ShapefileDataSource.this.getTypeName();
        }

        public String getFeatureID(int record) {
            return String.valueOf(this.file) + "." + record;
        }
    }
}

