/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.List;
import org.geotools.data.Query;
import org.geotools.filter.Filter;

public class DefaultQuery
implements Query {
    private String[] properties;
    private int maxFeatures = 100000000;
    private Filter filter = Filter.NONE;
    private String typeName;
    private String handle;

    public DefaultQuery() {
    }

    public DefaultQuery(Filter filter) {
        this.filter = filter;
    }

    public DefaultQuery(String typeName, Filter filter) {
        this(filter);
        this.typeName = typeName;
    }

    public DefaultQuery(Filter filter, String[] properties) {
        this(filter);
        this.properties = properties;
    }

    public DefaultQuery(String typeName, Filter filter, int maxFeatures, String[] propNames, String handle) {
        this(filter, propNames);
        this.maxFeatures = maxFeatures;
        this.handle = handle;
    }

    public String[] getPropertyNames() {
        return this.properties;
    }

    public void setPropertyNames(String[] propNames) {
        this.properties = propNames;
    }

    public void setPropertyNames(List propNames) {
        if (propNames == null) {
            this.properties = null;
            return;
        }
        String[] stringArr = new String[propNames.size()];
        this.properties = propNames.toArray(stringArr);
    }

    public boolean retrieveAllProperties() {
        return this.properties == null;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getVersion() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("No feature versioning yet");
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("Query:");
        if (this.handle != null) {
            returnString.append(" [" + this.handle + "]");
        }
        returnString.append("\n   feature type: " + this.typeName);
        if (this.filter != null) {
            returnString.append("\n   filter: " + this.filter.toString());
        }
        returnString.append("\n   [properties: ");
        if (this.properties == null || this.properties.length == 0) {
            return returnString + " ALL ]";
        }
        int i = 0;
        while (i < this.properties.length) {
            returnString.append(this.properties[i]);
            if (i < this.properties.length - 1) {
                returnString.append(", ");
            }
            ++i;
        }
        returnString.append("]");
        return returnString.toString();
    }
}

