/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Set;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;

public abstract class AbstractDataSource
implements DataSource {
    private static String supportMsg = "This datasource does not support ";
    private DataSourceMetaData metaData;

    public abstract void getFeatures(FeatureCollection var1, Query var2) throws DataSourceException;

    public void getFeatures(FeatureCollection collection, Filter filter) throws DataSourceException {
        Query query = this.makeDefaultQuery(filter);
        this.getFeatures(collection, query);
    }

    protected Query makeDefaultQuery(Filter filter) {
        return new DefaultQuery(filter);
    }

    public FeatureCollection getFeatures(Query query) throws DataSourceException {
        FeatureCollection collection = FeatureCollections.newCollection();
        this.getFeatures(collection, query);
        return collection;
    }

    public FeatureCollection getFeatures(Filter filter) throws DataSourceException {
        FeatureCollection collection = FeatureCollections.newCollection();
        this.getFeatures(collection, filter);
        return collection;
    }

    public FeatureCollection getFeatures() throws DataSourceException {
        return this.getFeatures(Query.ALL);
    }

    public Set addFeatures(FeatureCollection collection) throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsAdd()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "addFeatures");
        }
        return null;
    }

    public void removeFeatures(Filter filter) throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsRemove()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "removeFeatures");
        }
    }

    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsModify()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "modifyFeatures");
        }
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws DataSourceException, UnsupportedOperationException {
        AttributeType[] singleType = new AttributeType[]{type};
        Object[] singleVal = new Object[]{value};
        this.modifyFeatures(singleType, singleVal, filter);
    }

    public void setFeatures(FeatureCollection collection) throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsSetFeatures()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "setFeatures");
        }
    }

    public void commit() throws DataSourceException {
    }

    public void rollback() throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsRollbacks()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "rollbacks");
        }
    }

    public void setAutoCommit(boolean autoCommit) throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsRollbacks()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "rollbacks");
        }
    }

    public boolean getAutoCommit() throws DataSourceException {
        return true;
    }

    public final DataSourceMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = this.createMetaData();
        }
        return this.metaData;
    }

    protected DataSourceMetaData createMetaData() {
        return new MetaDataSupport();
    }

    public abstract FeatureType getSchema() throws DataSourceException;

    public void abortLoading() throws UnsupportedOperationException {
        if (!this.getMetaData().supportsAbort()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "abortLoading");
        }
    }

    public Envelope getBounds() throws DataSourceException, UnsupportedOperationException {
        if (!this.getMetaData().supportsGetBbox()) {
            throw new UnsupportedOperationException(String.valueOf(supportMsg) + "getBbox");
        }
        return null;
    }

    protected static final class MetaDataSupport
    implements DataSourceMetaData {
        private boolean add = false;
        private boolean remove = false;
        private boolean modify = false;
        private boolean rollbacks = false;
        private boolean set = false;
        private boolean abort = false;
        private boolean getBbox = false;
        private boolean fastBbox = false;

        public boolean supportsAdd() {
            return this.add;
        }

        public void setSupportsAdd(boolean support) {
            this.add = support;
        }

        public boolean supportsRemove() {
            return this.remove;
        }

        public void setSupportsRemove(boolean support) {
            this.remove = support;
        }

        public boolean supportsModify() {
            return this.modify;
        }

        public void setSupportsModify(boolean support) {
            this.modify = support;
        }

        public boolean supportsRollbacks() {
            return this.rollbacks;
        }

        public void setSupportsRollbacks(boolean support) {
            this.rollbacks = support;
        }

        public boolean supportsSetFeatures() {
            return this.set;
        }

        public void setSupportsSetFeatures(boolean support) {
            this.set = support;
        }

        public boolean supportsAbort() {
            return this.abort;
        }

        public void setSupportsAbort(boolean support) {
            this.abort = support;
        }

        public boolean supportsGetBbox() {
            return this.getBbox;
        }

        public void setSupportsGetBbox(boolean support) {
            this.getBbox = support;
        }

        public boolean hasFastBbox() {
            return this.fastBbox;
        }

        public void setFastBbox(boolean fast) {
            this.fastBbox = fast;
        }

        public String toString() {
            return "supportsAdd: " + this.add + "\n" + "supportsRemove: " + this.remove + "\n" + "supportsModify: " + this.modify + "\n" + "supportsSetFeatures: " + this.set + "\n" + "supportsRollbacks: " + this.rollbacks + "\n" + "supportsAbort: " + this.abort + "\n" + "supportsGetBbox: " + this.getBbox + "\n" + "hasFastBbox: " + this.fastBbox;
        }
    }
}

