/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import index.Query;
import spatial.SpatialSearchTree;
import spatial.SpatialSearchTreeNode;
import spatial.SpatialSearchTreeObject;

public class NearestNeighborQuery
extends Query {
    public static final int ALLLAYERS = -1;
    public static final int ALLSCALES = -1;
    public static final int QUERY = 0;
    protected int[] point;
    protected double tolerance = 0.0;
    protected int scale = 1;
    protected int layer = -1;
    protected int operation = 0;
    protected SpatialSearchTreeObject unequal = null;
    protected SpatialSearchTreeObject typeObject = null;
    protected SpatialSearchTreeObject bestObject = null;
    protected double bestDist;
    protected static final int MAXHEIGHT = 40;
    protected SpatialSearchTreeNode[] node = new SpatialSearchTreeNode[40];
    protected int[] index = new int[40];
    protected int pathLength = 0;

    public NearestNeighborQuery() {
        this.node[0] = null;
    }

    public SpatialSearchTreeObject getNearestObject() {
        if (this.node[0] != null && this.node[0].getNumberOfEntries() > 0) {
            this.timer.start();
            if (this.unequal == null) {
                this.tolerance = 100.0;
            } else {
                this.tolerance = this.unequal.getMBR().extension(0);
                int i = 1;
                while (i < this.unequal.getMBR().numOfDimensions()) {
                    this.tolerance = Math.max(this.tolerance, (double)this.unequal.getMBR().extension(i));
                    ++i;
                }
            }
            this.bestObject = null;
            while (this.bestObject == null) {
                this.getNextObject(0);
                if (this.bestObject != null) continue;
                this.tolerance += this.tolerance;
                this.reset();
            }
            if (this.bestDist <= this.tolerance) {
                this.timer.stop();
                ++this.resultNum;
                return this.bestObject;
            }
            this.tolerance = this.bestDist;
            this.reset();
            this.getNextObject(0);
            this.timer.stop();
            if (this.bestObject == null) {
                System.err.println("NearestNeighborQuery - Error: bestObject null in second phase");
            } else {
                ++this.resultNum;
            }
            return this.bestObject;
        }
        return null;
    }

    protected void getNextObject(int actHeight) {
        if (actHeight == this.pathLength) {
            this.node[this.pathLength] = this.node[this.pathLength - 1].getChildNode(this.index[this.pathLength - 1]);
            this.index[this.pathLength] = 0;
            ++this.pathLength;
        }
        int num = this.node[actHeight].getNumberOfEntries();
        if (this.node[actHeight].isLeaf()) {
            int i = this.index[actHeight];
            while (i < num) {
                SpatialSearchTreeObject obj = this.node[actHeight].getObject(i);
                if (this.unequal != obj && (this.typeObject == null || obj.isOfSameType(this.typeObject))) {
                    double objDist = obj.computeDistanceTo(this.point);
                    if (this.bestObject == null || objDist < this.bestDist) {
                        this.bestObject = obj;
                        this.bestDist = objDist;
                    }
                }
                ++i;
            }
        } else {
            int i = this.index[actHeight];
            while (i < num) {
                if (actHeight + 1 < this.pathLength || this.node[actHeight].getEntryMBR(i).contains(this.point, (int)Math.ceil(this.tolerance))) {
                    this.index[actHeight] = i;
                    this.getNextObject(actHeight + 1);
                }
                ++i;
            }
        }
        --this.pathLength;
        if (!this.node[this.pathLength].isRoot()) {
            this.node[this.pathLength].resetLock();
        }
    }

    public void initWithPoint(SpatialSearchTree tree, int[] point) {
        this.initWithPoint(tree, point, -1, 0, -1, null);
    }

    public void initWithPoint(SpatialSearchTree tree, int[] point, int scale, int tolerance, int layer, SpatialSearchTreeObject typeObject) {
        this.initWithPoint(tree, point, scale, layer, typeObject, 0, null);
    }

    public void initWithPoint(SpatialSearchTree tree, int[] point, int scale, int layer, SpatialSearchTreeObject typeObject, int operation, SpatialSearchTreeObject unequal) {
        this.point = point;
        this.scale = scale;
        this.layer = layer;
        this.typeObject = typeObject;
        this.operation = operation;
        this.unequal = unequal;
        this.node[0] = tree.getRoot();
        ++this.queryNum;
        this.reset();
    }

    protected void reset() {
        this.index[0] = 0;
        this.pathLength = 1;
        this.bestObject = null;
    }
}

