/*
 * Decompiled with CFR 0.152.
 */
package showmap;

import drawables.Drawable;
import drawables.DrawableBitmap;
import drawables.DrawableObject;
import drawables.DrawableObjectType;
import drawables.DrawableObjects;
import drawables.DrawableText;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;
import showmap.LoadDrawables;
import util.CPUTimer;
import util.ColorDefiner;
import util.DataReader;
import util.EntryInput;

public abstract class ShowMap
extends Applet
implements ActionListener,
ItemListener,
MouseListener,
MouseMotionListener {
    protected static final int STARTING = 0;
    protected static final int STARTED = 2;
    protected static final int ACTIVE = 3;
    protected static final int COMPLETE = 4;
    protected static final int ENGLISH = 0;
    protected static final int GERMAN = 1;
    protected CPUTimer updateTimer = new CPUTimer();
    protected static final long UPDATETIME = 3000L;
    protected int numOfLayers = 5;
    protected DrawableObjects drawableObjects = null;
    protected int baseScaleFactor = 1000000;
    protected int mapWidth = 300;
    protected int mapHeight = 300;
    protected int viewMapX = 150;
    protected int viewMapY = 150;
    protected int maxScale = 1;
    protected int minScale = 320;
    protected int scale = 160;
    protected int viewWidth = 300;
    protected int viewHeight = 300;
    protected int viewX = 10;
    protected int viewY = 10;
    protected int panelY = 1;
    protected int panelHeight = 163;
    protected Color backgroundColor = ColorDefiner.getDefaultColor();
    protected Color mapColor = new Color(120, 255, 255);
    protected boolean unicodeSupported = false;
    protected int language = 0;
    protected int state = 0;
    private Image doubleBuffer = null;
    private int lastMouseXPos = 0;
    private int lastMouseYPos = 0;
    private int lastDragXPos = 0;
    private int lastDragYPos = 0;
    protected boolean infoIsShown = false;
    private Label ivjClickInfoLabel = null;
    private Label ivjCopyrightLabel = null;
    private Label ivjNameLabel = null;
    private Label ivjPressInfoLabel = null;
    private Label ivjScaleLabel = null;
    private Label ivjShiftClickInfoLabel = null;
    private Label ivjTagLabel = null;
    private Label ivjValueLabel = null;
    private Button ivjEastButton = null;
    private Button ivjNorthButton = null;
    private Button ivjSouthButton = null;
    private Button ivjWestButton = null;
    private Button ivjZoomInButton = null;
    private Button ivjZoomOutButton = null;
    private Checkbox ivjUnicodeCheckbox = null;

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getZoomInButton()) {
            this.zoomIn();
        }
        if (e.getSource() == this.getZoomOutButton()) {
            this.zoomOut();
        }
        if (e.getSource() == this.getNorthButton()) {
            this.moveNorth();
        }
        if (e.getSource() == this.getWestButton()) {
            this.moveWest();
        }
        if (e.getSource() == this.getEastButton()) {
            this.moveEast();
        }
        if (e.getSource() == this.getSouthButton()) {
            this.moveSouth();
        }
    }

    protected void addComponentsToApplet() {
        this.add((Component)this.getEastButton(), this.getEastButton().getName());
        this.add((Component)this.getWestButton(), this.getWestButton().getName());
        this.add((Component)this.getNorthButton(), this.getNorthButton().getName());
        this.add((Component)this.getSouthButton(), this.getSouthButton().getName());
        this.add((Component)this.getZoomInButton(), this.getZoomInButton().getName());
        this.add((Component)this.getZoomOutButton(), this.getZoomOutButton().getName());
        this.add((Component)this.getScaleLabel(), this.getScaleLabel().getName());
        this.add((Component)this.getNameLabel(), this.getNameLabel().getName());
        this.add((Component)this.getValueLabel(), this.getValueLabel().getName());
        this.add((Component)this.getTagLabel(), this.getTagLabel().getName());
        this.add((Component)this.getClickInfoLabel(), this.getClickInfoLabel().getName());
        this.add((Component)this.getShiftClickInfoLabel(), this.getShiftClickInfoLabel().getName());
        this.add((Component)this.getPressInfoLabel(), this.getPressInfoLabel().getName());
        this.add((Component)this.getCopyrightLabel(), this.getCopyrightLabel().getName());
        if (this.unicodeSupported) {
            this.add((Component)this.getUnicodeCheckbox(), this.getUnicodeCheckbox().getName());
        }
    }

    protected void addComponentsToListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.getZoomInButton().addActionListener(this);
        this.getZoomOutButton().addActionListener(this);
        this.getNorthButton().addActionListener(this);
        this.getWestButton().addActionListener(this);
        this.getEastButton().addActionListener(this);
        this.getSouthButton().addActionListener(this);
        if (this.unicodeSupported) {
            this.getUnicodeCheckbox().addItemListener(this);
        }
    }

    public void changeComponentPositions() {
        this.getEastButton().setBounds(this.viewX + this.viewWidth / 2 + 24, this.viewY + this.viewHeight + 48, 31, 29);
        this.getNorthButton().setBounds(this.viewX + this.viewWidth / 2 - 16, this.viewY + this.viewHeight + 20, 31, 29);
        this.getSouthButton().setBounds(this.viewX + this.viewWidth / 2 - 16, this.viewY + this.viewHeight + 78, 31, 29);
        this.getWestButton().setBounds(this.viewX + this.viewWidth / 2 - 56, this.viewY + this.viewHeight + 48, 31, 29);
        this.getZoomInButton().setBounds(this.viewX + this.viewWidth / 2 - 151, this.viewY + this.viewHeight + 48, 76, 29);
        this.getZoomOutButton().setBounds(this.viewX + this.viewWidth / 2 + 76, this.viewY + this.viewHeight + 48, 76, 29);
        this.getClickInfoLabel().setBounds(this.viewWidth / 2 + this.viewX + 24, this.viewHeight + this.viewY + 5, 160, 13);
        this.getShiftClickInfoLabel().setBounds(this.viewWidth / 2 + this.viewX + 24, this.viewHeight + this.viewY + 18, 160, 13);
        this.getPressInfoLabel().setBounds(this.viewWidth / 2 + this.viewX + 24, this.viewHeight + this.viewY + 31, 160, 13);
        this.getCopyrightLabel().setBounds(this.viewX, this.viewY + this.viewHeight + 140, this.viewWidth - 100, 19);
        this.getScaleLabel().setBounds(this.viewX, this.viewY + this.viewHeight + 4, 100, 23);
        this.getNameLabel().setBounds(this.viewX, this.viewHeight + this.viewY + 79, this.viewWidth / 2 - 25, 23);
        this.getValueLabel().setBounds(this.viewX + this.viewWidth / 2 + 24, this.viewHeight + this.viewY + 79, this.viewWidth / 2 - 25, 23);
        this.getTagLabel().setBounds(this.viewX, this.viewHeight + this.viewY + 108, this.viewWidth, 23);
        if (this.unicodeSupported) {
            this.getTagLabel().setBounds(this.viewX, this.viewHeight + this.viewY + 108, this.viewWidth - 70, 23);
            this.getUnicodeCheckbox().setBounds(this.viewX + this.viewWidth - 70, this.viewY + this.viewHeight + 104, 70, 23);
        }
    }

    protected void checkViewPoint() {
        boolean set;
        boolean bl = set = this.state >= 3;
        if (this.viewMapX >= this.mapWidth / this.scale - this.viewWidth / 2) {
            this.viewMapX = this.mapWidth / this.scale - this.viewWidth / 2;
            this.getEastButton().setEnabled(false);
        } else {
            this.getEastButton().setEnabled(set);
        }
        if (this.viewMapX <= this.viewWidth / 2) {
            this.viewMapX = this.viewWidth / 2;
            this.getWestButton().setEnabled(false);
            this.getEastButton().setEnabled(this.viewMapX < this.mapWidth / this.scale - this.viewWidth / 2 && set);
        } else {
            this.getWestButton().setEnabled(set);
        }
        if (this.viewMapY >= this.mapHeight / this.scale - this.viewHeight / 2) {
            this.viewMapY = this.mapHeight / this.scale - this.viewHeight / 2;
            this.getSouthButton().setEnabled(false);
        } else {
            this.getSouthButton().setEnabled(set);
        }
        if (this.viewMapY <= this.viewHeight / 2) {
            this.viewMapY = this.viewHeight / 2;
            this.getNorthButton().setEnabled(false);
            this.getSouthButton().setEnabled(this.viewMapY < this.mapHeight / this.scale - this.viewHeight / 2 && set);
        } else {
            this.getNorthButton().setEnabled(set);
        }
        this.getZoomInButton().setEnabled(this.scale != this.maxScale && set);
        this.getZoomOutButton().setEnabled(this.scale != this.minScale && set);
    }

    protected URL computeURL(String name) {
        try {
            if (name == null) {
                return null;
            }
            if (name.startsWith("http:") || name.startsWith("file:")) {
                return new URL(name);
            }
            if (name.indexOf(58) > 0) {
                return new URL("file:/" + name.replace('\\', '/'));
            }
            String docBase = this.getCodeBase().toString();
            return new URL(String.valueOf(docBase) + name.replace('\\', '/'));
        }
        catch (MalformedURLException me) {
            System.err.println("MalformedURLException: " + me);
            return null;
        }
    }

    protected void depictObjectAttributes(DrawableObject obj) {
        this.drawableObjects.deselect();
        if (obj == null) {
            this.getNameLabel().setText("...");
            this.getTagLabel().setText("...");
            this.getValueLabel().setText("...");
            this.repaint();
            return;
        }
        this.drawableObjects.select(obj);
        this.repaint();
    }

    protected void drawMap(Graphics g, Rectangle r, int scale) {
        this.drawableObjects.drawAllObjects(g, r, scale);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.mapWidth / scale + 1, this.mapHeight / scale + 1);
    }

    protected DrawableObject findObject(int mx, int my, boolean selectable) {
        if (mx < this.viewX || mx > this.viewX + this.viewWidth || my < this.viewY || my > this.viewY + this.viewHeight) {
            return null;
        }
        DrawableObject obj = null;
        int px = this.xIntoCoord(mx);
        int py = this.yIntoCoord(my);
        obj = this.drawableObjects.getNextVisibleIntersectingObject(px, py, this.scale, selectable);
        return obj;
    }

    public String getAppletInfo() {
        return "Applet ShowMap, Version 2.40\n" + this.getCopyrightLabel().getText();
    }

    protected Label getClickInfoLabel() {
        if (this.ivjClickInfoLabel == null) {
            this.ivjClickInfoLabel = new Label();
            this.ivjClickInfoLabel.setName("ClickInfo");
            this.ivjClickInfoLabel.setFont(new Font("dialog", 0, 10));
            if (this.language == 1) {
                this.ivjClickInfoLabel.setText("Klicken: Objekt-Info");
            } else {
                this.ivjClickInfoLabel.setText("click: show info");
            }
        }
        return this.ivjClickInfoLabel;
    }

    protected Label getCopyrightLabel() {
        if (this.ivjCopyrightLabel == null) {
            this.ivjCopyrightLabel = new Label();
            this.ivjCopyrightLabel.setName("CopyrightLabel");
            this.ivjCopyrightLabel.setFont(new Font("dialog", 0, 10));
            this.ivjCopyrightLabel.setText("(c) Th. Brinkhoff, 1999-2001, tbrinkhoff@acm.org");
        }
        return this.ivjCopyrightLabel;
    }

    protected Button getEastButton() {
        if (this.ivjEastButton == null) {
            this.ivjEastButton = new Button();
            this.ivjEastButton.setName("EastButton");
            this.ivjEastButton.setFont(new Font("dialog", 0, 12));
            if (this.language == 1) {
                this.ivjEastButton.setLabel("O");
            } else {
                this.ivjEastButton.setLabel("E");
            }
        }
        return this.ivjEastButton;
    }

    public long getIdOfSelectedObject() {
        DrawableObject obj = this.drawableObjects.getSelectedObject();
        if (obj != null) {
            return obj.getId();
        }
        return -1L;
    }

    public String getIdOfSelectedObjectAsString() {
        long id = this.getIdOfSelectedObject();
        if (id != -1L) {
            return String.valueOf(id);
        }
        return "";
    }

    protected abstract String getInfoText(DrawableObject var1);

    protected Label getNameLabel() {
        if (this.ivjNameLabel == null) {
            this.ivjNameLabel = new Label();
            this.ivjNameLabel.setName("NameLabel");
            this.ivjNameLabel.setFont(new Font("sansserif", 0, 12));
            this.ivjNameLabel.setText("...");
        }
        return this.ivjNameLabel;
    }

    public String getNameOfSelectedObject() {
        DrawableObject obj = this.drawableObjects.getSelectedObject();
        if (obj != null) {
            return obj.getName();
        }
        return "";
    }

    protected Button getNorthButton() {
        if (this.ivjNorthButton == null) {
            this.ivjNorthButton = new Button();
            this.ivjNorthButton.setName("NorthButton");
            this.ivjNorthButton.setFont(new Font("Dialog", 0, 12));
            this.ivjNorthButton.setLabel("N");
        }
        return this.ivjNorthButton;
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"name of parameter", "type of parameter", "see: ShowMapParameters.html"}};
        return info;
    }

    protected Label getPressInfoLabel() {
        if (this.ivjPressInfoLabel == null) {
            this.ivjPressInfoLabel = new Label();
            this.ivjPressInfoLabel.setName("PressInfo");
            this.ivjPressInfoLabel.setFont(new Font("dialog", 0, 10));
            if (this.language == 1) {
                this.ivjPressInfoLabel.setText("Aufziehen: Neue Mitte & Gr\u00f6\u00dfer");
            } else {
                this.ivjPressInfoLabel.setText("drag: new center & zoom in");
            }
        }
        return this.ivjPressInfoLabel;
    }

    protected Label getScaleLabel() {
        if (this.ivjScaleLabel == null) {
            this.ivjScaleLabel = new Label();
            this.ivjScaleLabel.setName("ScaleLabel");
            this.ivjScaleLabel.setAlignment(0);
            this.ivjScaleLabel.setFont(new Font("Dialog", 0, 12));
            this.ivjScaleLabel.setText("...");
        }
        return this.ivjScaleLabel;
    }

    protected Label getShiftClickInfoLabel() {
        if (this.ivjShiftClickInfoLabel == null) {
            this.ivjShiftClickInfoLabel = new Label();
            this.ivjShiftClickInfoLabel.setName("ShiftClickInfoLabel");
            this.ivjShiftClickInfoLabel.setFont(new Font("dialog", 0, 10));
            if (this.language == 1) {
                this.ivjShiftClickInfoLabel.setText("Shift-Klick: Neue Mitte");
            } else {
                this.ivjShiftClickInfoLabel.setText("shift click: new center");
            }
        }
        return this.ivjShiftClickInfoLabel;
    }

    protected Button getSouthButton() {
        if (this.ivjSouthButton == null) {
            this.ivjSouthButton = new Button();
            this.ivjSouthButton.setName("SouthButton");
            this.ivjSouthButton.setLabel("S");
        }
        return this.ivjSouthButton;
    }

    protected int getState() {
        return this.state;
    }

    protected Label getTagLabel() {
        if (this.ivjTagLabel == null) {
            this.ivjTagLabel = new Label();
            this.ivjTagLabel.setName("TagLabel");
            this.ivjTagLabel.setFont(new Font("sansserif", 0, 12));
            this.ivjTagLabel.setText("...");
        }
        return this.ivjTagLabel;
    }

    protected Checkbox getUnicodeCheckbox() {
        if (this.ivjUnicodeCheckbox == null && this.unicodeSupported) {
            this.ivjUnicodeCheckbox = new Checkbox();
            this.ivjUnicodeCheckbox.setName("UnicodeCheckbox");
            this.ivjUnicodeCheckbox.setFont(new Font("dialog", 0, 11));
            this.ivjUnicodeCheckbox.setLabel("Unicode");
            this.ivjUnicodeCheckbox.setState(true);
        }
        return this.ivjUnicodeCheckbox;
    }

    protected Label getValueLabel() {
        if (this.ivjValueLabel == null) {
            this.ivjValueLabel = new Label();
            this.ivjValueLabel.setName("ValueLabel");
            this.ivjValueLabel.setFont(new Font("sansserif", 0, 12));
            this.ivjValueLabel.setText("...");
        }
        return this.ivjValueLabel;
    }

    protected Button getWestButton() {
        if (this.ivjWestButton == null) {
            this.ivjWestButton = new Button();
            this.ivjWestButton.setName("WestButton");
            this.ivjWestButton.setFont(new Font("dialog", 0, 12));
            this.ivjWestButton.setLabel("W");
        }
        return this.ivjWestButton;
    }

    protected Button getZoomInButton() {
        if (this.ivjZoomInButton == null) {
            this.ivjZoomInButton = new Button();
            this.ivjZoomInButton.setName("ZoomInButton");
            if (this.language == 1) {
                this.ivjZoomInButton.setLabel("Gr\u00f6\u00dfer");
            } else {
                this.ivjZoomInButton.setLabel("Zoom In");
            }
        }
        return this.ivjZoomInButton;
    }

    protected Button getZoomOutButton() {
        if (this.ivjZoomOutButton == null) {
            this.ivjZoomOutButton = new Button();
            this.ivjZoomOutButton.setName("ZoomOutButton");
            if (this.language == 1) {
                this.ivjZoomOutButton.setLabel("Kleiner");
            } else {
                this.ivjZoomOutButton.setLabel("Zoom Out");
            }
        }
        return this.ivjZoomOutButton;
    }

    public void init() {
        super.init();
        this.setName("ShowMap");
        this.interpretParameters();
        this.setLayout(null);
        this.setBackground(this.backgroundColor);
        this.setSize(2 * this.viewX + this.viewWidth, this.viewY + this.viewHeight + this.panelHeight);
        if (this.panelY >= 0) {
            this.panelY = this.viewY + this.viewHeight;
        } else {
            this.panelY = 0;
            this.viewY = this.panelHeight;
        }
        this.addComponentsToApplet();
        this.addComponentsToListeners();
        this.changeComponentPositions();
        DrawableBitmap.init(this);
        String p = this.getParameter("layers");
        if (p != null) {
            this.numOfLayers = new Integer(p);
        }
        if (this.drawableObjects == null) {
            this.drawableObjects = new DrawableObjects(this.numOfLayers);
        }
        this.initDrawablePresentation();
        this.depictObjectAttributes(null);
        this.checkViewPoint();
        this.movePos(-1L);
        this.startLoadingThread();
    }

    protected abstract void initDrawablePresentation();

    protected void interpretParameters() {
        String p = this.getParameter("basescalefactor");
        if (p != null) {
            this.baseScaleFactor = new Integer(p);
        }
        if ((p = this.getParameter("minscale")) != null) {
            this.minScale = new Integer(p);
        }
        if ((p = this.getParameter("maxscale")) != null) {
            this.maxScale = new Integer(p);
        }
        this.scale = (p = this.getParameter("scale")) != null ? new Integer(p) : this.maxScale;
        p = this.getParameter("viewwidth");
        if (p != null) {
            this.viewWidth = new Integer(p);
        }
        this.mapWidth = this.scale * this.viewWidth;
        p = this.getParameter("viewheight");
        if (p != null) {
            this.viewHeight = new Integer(p);
        }
        this.mapHeight = this.scale * this.viewHeight;
        p = this.getParameter("mapwidth");
        if (p != null) {
            this.mapWidth = new Integer(p);
        }
        if ((p = this.getParameter("mapheight")) != null) {
            this.mapHeight = new Integer(p);
        }
        if ((p = this.getParameter("viewx")) != null) {
            this.viewX = new Integer(p);
        }
        if ((p = this.getParameter("viewy")) != null) {
            this.viewY = new Integer(p);
        }
        if ((p = this.getParameter("unicode")) != null) {
            this.unicodeSupported = p.compareTo("yes") == 0;
            DrawableText.setUnicode(true);
        }
        if ((p = this.getParameter("color")) != null) {
            this.backgroundColor = ColorDefiner.getColor(p);
        }
        if ((p = this.getParameter("language")) != null && p.compareTo("D") == 0) {
            this.language = 1;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getUnicodeCheckbox() && this.unicodeSupported) {
            this.setUnicode(this.getUnicodeCheckbox().getState());
        }
    }

    protected void loadDrawables() {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this) {
            if (e.isShiftDown()) {
                this.movePos(e.getX(), e.getY());
            } else {
                DrawableObject oldSelectedObject = this.drawableObjects.getSelectedObject();
                DrawableObject obj = this.findObject(e.getX(), e.getY(), true);
                if (obj != oldSelectedObject) {
                    this.depictObjectAttributes(obj);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this) {
            this.paintDragBox(this.lastMouseXPos, this.lastMouseYPos, this.lastDragXPos, this.lastDragYPos);
            this.lastDragXPos = e.getX();
            this.lastDragYPos = e.getY();
            this.paintDragBox(this.lastMouseXPos, this.lastMouseYPos, this.lastDragXPos, this.lastDragYPos);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this) {
            DrawableObject obj = this.findObject(e.getX(), e.getY(), true);
            if (obj == null) {
                if (this.infoIsShown) {
                    this.paint(this.getGraphics());
                    this.infoIsShown = false;
                }
            } else if (!this.infoIsShown) {
                this.paintInfo(e.getX() + 10, e.getY() - 10, obj);
                this.infoIsShown = true;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this) {
            this.lastMouseXPos = e.getX();
            this.lastMouseYPos = e.getY();
            this.lastDragXPos = e.getX();
            this.lastDragYPos = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this) {
            this.paintDragBox(this.lastMouseXPos, this.lastMouseYPos, this.lastDragXPos, this.lastDragYPos);
            if ((Math.abs(this.lastMouseXPos - e.getX()) > 3 || Math.abs(this.lastMouseYPos - e.getY()) > 3) && this.state >= 3) {
                this.viewMapX = this.viewMapX - this.viewWidth / 2 + (this.lastMouseXPos + e.getX()) / 2 - this.viewX;
                this.viewMapY = this.viewMapY - this.viewHeight / 2 + (this.lastMouseYPos + e.getY()) / 2 - this.viewY;
                if (this.scale == this.maxScale) {
                    this.checkViewPoint();
                    this.repaint();
                    this.loadDrawables();
                } else {
                    this.zoomIn();
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void moveEast() {
        int oldViewMapX = this.viewMapX;
        this.viewMapX += this.viewWidth / 10 * 7;
        this.checkViewPoint();
        if (oldViewMapX != this.viewMapX) {
            this.repaint();
            this.loadDrawables();
        }
    }

    public void moveNorth() {
        int oldViewMapY = this.viewMapY;
        this.viewMapY -= this.viewHeight / 10 * 7;
        this.checkViewPoint();
        if (oldViewMapY != this.viewMapY) {
            this.repaint();
            this.loadDrawables();
        }
    }

    public void movePos(int x, int y) {
        int oldViewMapX = this.viewMapX;
        int oldViewMapY = this.viewMapY;
        this.viewMapX = this.viewMapX - this.viewWidth / 2 + x - this.viewX;
        this.viewMapY = this.viewMapY - this.viewHeight / 2 + y - this.viewY;
        this.checkViewPoint();
        if (oldViewMapX != this.viewMapX || oldViewMapY != this.viewMapY) {
            this.repaint();
            this.loadDrawables();
        }
    }

    public void movePos(int x, int y, int s) {
        this.scale = this.minScale;
        if (s < this.maxScale) {
            s = this.maxScale;
        }
        while (this.scale > s) {
            this.scale /= 2;
        }
        this.viewMapX = x / this.scale;
        this.viewMapY = y / this.scale;
        DrawableObject obj = this.findObject(this.viewX + this.viewWidth / 2, this.viewY + this.viewHeight / 2, true);
        this.depictObjectAttributes(obj);
        this.checkViewPoint();
        this.repaint();
        this.loadDrawables();
    }

    public void movePos(long id) {
        DrawableObject obj = this.drawableObjects.getObjectById(id);
        if (obj != null) {
            Drawable prim = obj.getDrawable(0);
            this.scale = this.minScale;
            int s = obj.getDefaultScale();
            if (s < this.maxScale) {
                s = this.maxScale;
            }
            while (this.scale > s) {
                this.scale /= 2;
            }
            Rectangle mbr = prim.getMBR();
            this.viewMapX = (mbr.x + mbr.width / 2) / this.scale;
            this.viewMapY = (mbr.y + mbr.height / 2) / this.scale;
            this.checkViewPoint();
            obj = this.drawableObjects.getVisibleObjectById(id, this.scale);
        }
        this.depictObjectAttributes(obj);
        this.repaint();
        this.loadDrawables();
    }

    public void moveSouth() {
        int oldViewMapY = this.viewMapY;
        this.viewMapY += this.viewHeight / 10 * 7;
        this.checkViewPoint();
        if (oldViewMapY != this.viewMapY) {
            this.repaint();
            this.loadDrawables();
        }
    }

    public void moveWest() {
        int oldViewMapX = this.viewMapX;
        this.viewMapX -= this.viewWidth / 10 * 7;
        this.checkViewPoint();
        if (oldViewMapX != this.viewMapX) {
            this.repaint();
            this.loadDrawables();
        }
    }

    public void paint(Graphics g) {
        if (this.doubleBuffer == null) {
            this.update(g);
        } else {
            g.drawImage(this.doubleBuffer, this.viewX, this.viewY, this);
        }
    }

    protected void paintDragBox(int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            Graphics g = this.getGraphics();
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            g.setClip(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
            g.drawRect(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
            g.setPaintMode();
        }
    }

    protected void paintInfo(int x, int y, DrawableObject obj) {
        String infoText = this.getInfoText(obj);
        if (infoText == null) {
            return;
        }
        Graphics g = this.getGraphics();
        Font f = DrawableText.setFont(g, 0, 9);
        FontMetrics fm = g.getFontMetrics(f);
        int width = fm.stringWidth(infoText);
        int height = fm.getLeading() + fm.getAscent();
        g.setClip(this.viewX + 1, this.viewY + 1, this.viewWidth - 2, this.viewHeight - 2);
        g.setColor(Color.yellow);
        g.fillRect(x, y - height - 3, width + 5, height + 4);
        g.setColor(Color.black);
        g.drawRect(x, y - height - 3, width + 5, height + 4);
        g.drawString(infoText, x + 3, y - 2);
    }

    protected int readDrawables(int objNum, URL url, int index) {
        try {
            DataReader ber;
            if (this.language == 1) {
                this.showStatus("\u00f6ffne URL ...");
            } else {
                this.showStatus("open URL ...");
            }
            InputStream is = null;
            if (url.toString().endsWith(".zip")) {
                ZipInputStream zis = new ZipInputStream(url.openStream());
                zis.getNextEntry();
                is = zis;
                ber = new DataReader(zis);
            } else {
                is = url.openStream();
                ber = new DataReader(is);
            }
            objNum = this.readDrawables(objNum, ber);
            is.close();
            return objNum;
        }
        catch (IOException ioe) {
            System.err.println("ShowMap.readDrawables.IOException: " + ioe);
            return objNum;
        }
    }

    protected int readDrawables(int objNum, EntryInput ber) {
        char t1 = ber.readChar();
        char t2 = ber.readChar();
        if (t1 == 'D' && t2 == 'O') {
            int version = ber.readInt();
            if (version < 200) {
                System.err.println("Wrong version!");
                return objNum;
            }
            if (version >= 210) {
                this.mapWidth = ber.readInt();
                this.mapHeight = ber.readInt();
                this.baseScaleFactor = ber.readInt();
            }
            String objType = null;
            while ((objType = ber.readString()) != null) {
                Object d;
                if (objType.startsWith("END")) break;
                if (objType.startsWith("STARTED")) {
                    this.state = 2;
                } else if (objType.startsWith("ACTIVE")) {
                    this.state = 3;
                    this.setViewToPrefinedValue();
                    this.checkViewPoint();
                    this.update(this.getGraphics());
                } else if (objType.compareTo("ObjectType") == 0) {
                    new DrawableObjectType().read(ber);
                } else if (objType.equals("O")) {
                    d = this.drawableObjects.readDrawableObject(ber, version);
                    if (d == null) {
                        System.err.println("Read error at object " + (objNum + 1));
                        break;
                    }
                } else if (version >= 210) {
                    long objID;
                    d = Drawable.readDrawable(ber, objType);
                    if (d == null) {
                        System.err.println("Read error at primitive " + (objNum + 1));
                        break;
                    }
                    this.drawableObjects.addDrawable((Drawable)d);
                    if (!ber.eol() && (objID = (long)ber.readInt()) != 0L) {
                        DrawableObject obj = this.drawableObjects.getObjectById(objID);
                        if (obj == null) {
                            this.drawableObjects.newDrawableObject(objID, "", "", "").addDrawable((Drawable)d);
                        } else {
                            obj.addDrawable((Drawable)d);
                        }
                    }
                } else {
                    this.drawableObjects.readDrawableObject(ber, objType);
                }
                ++objNum;
                if (this.state >= 3 && this.updateTimer.get() > 3000L) {
                    this.update(this.getGraphics());
                }
                if (objNum % 10 != 0) continue;
                if (this.state >= 3 && this.language == 1) {
                    this.showStatus(String.valueOf(objNum) + " Objekte geladen; man kann bereits arbeiten ...");
                    continue;
                }
                if (this.state >= 3) {
                    this.showStatus(String.valueOf(objNum) + " objects loaded; you can already work ...");
                    continue;
                }
                if (this.language == 1) {
                    this.showStatus(String.valueOf(objNum) + " Objekte geladen... ");
                    continue;
                }
                this.showStatus(String.valueOf(objNum) + " objects loaded... ");
            }
        } else {
            System.err.println("Wrong file type!");
        }
        return objNum;
    }

    public void setMapSize(int pViewWidth, int pViewHeight) {
        this.viewWidth = pViewWidth;
        this.viewHeight = pViewHeight;
        this.doubleBuffer = null;
        this.setSize(this.viewWidth + 2 * this.viewX, this.viewHeight + this.viewY + 163);
        this.changeComponentPositions();
        this.repaint();
    }

    protected void setState(int state) {
        this.state = state;
        if (state == 4) {
            if (this.language == 1) {
                this.showStatus("Bereit!");
            } else {
                this.showStatus("Ready!");
            }
        }
    }

    protected void setUnicode(boolean f) {
        DrawableText.setUnicode(f);
        this.repaint();
    }

    public void setViewToPrefinedValue() {
        String p = this.getParameter("posx");
        this.viewMapX = p != null ? new Integer(p) / this.scale : this.mapWidth / 2 / this.scale;
        p = this.getParameter("posy");
        this.viewMapY = p != null ? new Integer(p) / this.scale : this.mapHeight / 2 / this.scale;
    }

    protected void startLoadingThread() {
        String urlName = this.getParameter("url");
        if (urlName != null) {
            System.out.println("ShowMap: URL-Name: " + urlName);
            URL url = this.computeURL(urlName);
            System.out.println("ShowMap: URL: " + urlName);
            if (url != null) {
                new LoadDrawables(this, url, 0).start();
            }
        } else {
            System.err.println("ShowMap: no URL!");
        }
    }

    public synchronized void update(Graphics pg) {
        if (this.state < 3) {
            return;
        }
        int vMapX = this.viewMapX;
        int vMapY = this.viewMapY;
        int sc = this.scale;
        this.updateTimer.reset();
        DrawableObject oldSelectedObject = this.drawableObjects.getSelectedObject();
        this.drawableObjects.deselect();
        if (this.doubleBuffer == null) {
            this.doubleBuffer = this.createImage(this.viewWidth, this.viewHeight);
        }
        Graphics g = this.doubleBuffer.getGraphics();
        g.setPaintMode();
        g.setClip(0, 0, this.viewWidth, this.viewHeight);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.viewWidth, this.viewHeight);
        g.translate(-vMapX + this.viewWidth / 2, -vMapY + this.viewHeight / 2);
        g.setClip(vMapX - this.viewWidth / 2, vMapY - this.viewHeight / 2, this.viewWidth + 1, this.viewHeight + 1);
        g.setColor(this.mapColor);
        g.fillRect(0, 0, this.mapWidth / this.scale, this.mapHeight / this.scale);
        Rectangle r = new Rectangle((vMapX - this.viewWidth / 2) * sc, (vMapY - this.viewHeight / 2) * sc, this.viewWidth * sc, this.viewHeight * sc);
        this.drawMap(g, r, sc);
        if (oldSelectedObject != null) {
            this.drawableObjects.select(oldSelectedObject);
            oldSelectedObject.draw(g, r, sc);
        }
        g.translate(vMapX - this.viewWidth / 2, vMapY - this.viewHeight / 2);
        g.setClip(0, 0, this.viewWidth, this.viewHeight);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.viewWidth - 1, this.viewHeight - 1);
        this.getScaleLabel().setText("1 : " + String.valueOf(sc * this.baseScaleFactor));
        pg.drawImage(this.doubleBuffer, this.viewX, this.viewY, this);
        this.updateTimer.start();
    }

    public int xIntoCoord(int x) {
        x = x - this.viewX + this.viewMapX - this.viewWidth / 2;
        return x * this.scale;
    }

    public int yIntoCoord(int y) {
        y = y - this.viewY + this.viewMapY - this.viewHeight / 2;
        return y * this.scale;
    }

    public void zoomIn() {
        if (this.scale == this.maxScale) {
            return;
        }
        this.scale /= 2;
        this.viewMapX *= 2;
        this.viewMapY *= 2;
        this.checkViewPoint();
        this.repaint();
        this.loadDrawables();
    }

    public void zoomOut() {
        if (this.scale == this.minScale) {
            return;
        }
        this.scale *= 2;
        this.viewMapX /= 2;
        this.viewMapY /= 2;
        this.checkViewPoint();
        this.repaint();
        this.loadDrawables();
    }
}

