/*
 * Decompiled with CFR 0.152.
 */
package routing;

import drawables.DrawablePresentation;
import java.awt.Color;
import java.io.DataInput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import routing.Edge;
import routing.Node;
import routing.Nodes;
import routing.WeightManager;
import util.Num;

public class Edges {
    protected Hashtable hashTable = null;
    private long maxId = 0L;
    private WeightManager wm = null;
    private int numOfClasses = 7;
    private Edge searchEdge = new Edge(0L);
    protected int nullMark = 0;
    protected int[] speed = new int[]{140, 70, 50, 40, 20, 20, 5};
    protected int[] minScale = new int[]{128, 32, 8, 4, 2, 1, 1};

    public Edges() {
        this.hashTable = new Hashtable(10000);
    }

    public void clearAllMarks() {
        ++this.nullMark;
    }

    public Enumeration elements() {
        return this.hashTable.elements();
    }

    public Edge get(long id) {
        this.searchEdge.setID(id);
        return (Edge)this.hashTable.get(this.searchEdge);
    }

    public long getNextFreeId() {
        return this.maxId + 1L;
    }

    public int getNumOfClasses() {
        return this.numOfClasses;
    }

    public int getSpeed(int pClass) {
        return this.speed[Num.putIntoInterval(pClass, 0, this.numOfClasses)];
    }

    public WeightManager getWeightManager() {
        return this.wm;
    }

    public void initPresentation(Color[] color, Color highlightColor) {
        int i = 0;
        while (i < this.numOfClasses) {
            DrawablePresentation.newDrawablePresentation("Edge" + i, false, color[i], highlightColor);
            ++i;
        }
        DrawablePresentation.newDrawablePresentation("EdgeH", false, highlightColor, highlightColor);
    }

    public Edge newEdge(long id, int edgeClass, Node node1, Node node2, String name) {
        if (node1 == null || node2 == null) {
            return null;
        }
        Edge edge = this.get(id);
        if (edge != null) {
            return edge;
        }
        edge = new Edge(id, edgeClass, node1, node2, name, this);
        this.hashTable.put(edge, edge);
        node1.addEdge(edge);
        node2.addEdge(edge);
        if (id > this.maxId) {
            this.maxId = id;
        }
        return edge;
    }

    public int numOfEdges() {
        return this.hashTable.size();
    }

    public Edge read(DataInput in, Nodes nodes) throws IOException {
        Edge res = null;
        long id1 = in.readLong();
        long id2 = in.readLong();
        byte len = in.readByte();
        Node pNode1 = nodes.get(id1);
        Node pNode2 = nodes.get(id2);
        if (len > 0) {
            byte[] data = new byte[len];
            in.readFully(data);
            long eID = in.readLong();
            int eClass = in.readInt();
            res = this.newEdge(eID, eClass, pNode1, pNode2, new String(data));
        } else {
            long eID = in.readLong();
            int eClass = in.readInt();
            res = this.newEdge(eID, eClass, pNode1, pNode2, null);
        }
        return res;
    }

    public boolean removeEdge(Edge edge) {
        if (edge == null) {
            return false;
        }
        edge.getNode1().removeEdge(edge);
        edge.getNode2().removeEdge(edge);
        this.hashTable.remove(edge);
        return true;
    }

    public void setMinScaleArray(int[] newMinScale) {
        this.minScale = newMinScale;
    }

    public void setNumOfClasses(int num) {
        this.numOfClasses = num;
    }

    public void setSpeedArray(int[] newSpeed) {
        this.speed = newSpeed;
    }

    public void setWeightManager(WeightManager wm) {
        this.wm = wm;
    }
}

