/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataGenerator;
import generator2.OracleDataGenerator;
import generator2.OracleReporter;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.sql.Connection;
import java.sql.Statement;
import routing.Edge;
import routing.Edges;
import routing.Network;
import routing.Node;
import routing.Nodes;
import spatialdb.GeometryConversion;
import spatialdb.SpatialResultSet;

public class OracleSpatialDataGenerator
extends OracleDataGenerator {
    private Edge computeEdge(long id, int edgeClass, Node n1, Node n2, Edges edges) {
        Edge actEdge = edges.newEdge(id, edgeClass, n1, n2, null);
        this.drawableObjects.addDrawable(actEdge);
        return actEdge;
    }

    private Node computeNode(long id, int x, int y, Nodes nodes) {
        Node cn = nodes.findNearest(x, y);
        if (cn != null && x == cn.getX() && y == cn.getY()) {
            return cn;
        }
        Node actNode = nodes.newNode(id, x, y, null);
        this.drawableObjects.addDrawable(actNode);
        return actNode;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0] != null) {
            DataGenerator.propFilename = DataGenerator.makeAbsolute(args[0]);
        }
        DataGenerator.main("generator2.OracleSpatialDataGenerator");
    }

    protected void startLoadingThread() {
        try {
            if (this.net == null) {
                this.net = new Network();
            }
            Edges edges = this.net.getEdges();
            Nodes nodes = this.net.getNodes();
            System.out.println("open db connection ...");
            this.showStatus("open db connection ...");
            Connection dbCon = OracleReporter.getConnection(this.properties);
            Statement query = dbCon.createStatement();
            String tableName = "streets";
            if (this.properties.getProperty("dbStreetTableName") != null) {
                tableName = this.properties.getProperty("dbStreetTableName");
            }
            String geoAttrName = "geometry";
            if (this.properties.getProperty("dbStreetGeomName") != null) {
                geoAttrName = this.properties.getProperty("dbStreetGeomName");
            }
            String classAttrName = "class";
            if (this.properties.getProperty("dbStreetClassName") != null) {
                classAttrName = this.properties.getProperty("dbStreetClassName");
            }
            SpatialResultSet extent = new SpatialResultSet(query.executeQuery("SELECT SDO_TUNE.EXTENT_OF('" + tableName + "','" + geoAttrName + "') FROM DUAL"));
            extent.next();
            Rectangle mbr = GeometryConversion.toAwtRectangle(extent.getGeometry(1));
            System.out.println("construct network, please wait ...");
            this.showStatus("construct network, please wait ...");
            SpatialResultSet feature = new SpatialResultSet(query.executeQuery("SELECT * FROM " + tableName));
            long id = 0L;
            while (feature.next()) {
                int edgeClass = feature.getInt(classAttrName);
                Polygon pol = GeometryConversion.toAwtPolyline(feature.getGeometry(geoAttrName));
                Node n1 = this.computeNode(++id, pol.xpoints[0], pol.ypoints[0], nodes);
                int i = 1;
                while (i < pol.npoints) {
                    Node n2 = this.computeNode(++id, pol.xpoints[i], pol.ypoints[i], nodes);
                    this.computeEdge(++id, edgeClass, n1, n2, edges);
                    n1 = n2;
                    ++i;
                }
            }
            dbCon.close();
            System.out.println("construction finished");
            this.mapWidth = mbr.x + mbr.width;
            this.mapHeight = mbr.y + mbr.height;
        }
        catch (Exception ex) {
            System.err.println("OracleSpatialDataGenerator.startLoadingThread: " + ex);
        }
        this.setViewToPrefinedValue();
        this.setState(4);
        this.checkViewPoint();
    }
}

