/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import drawables.DrawableObjects;
import generator2.Reporter;
import java.awt.Rectangle;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class OracleReporter
extends Reporter {
    protected Connection con = null;
    protected String dbExternalObjectTableName = "externalobjects";
    protected String dbMovingObjectTableName = "movingobjects";
    protected PreparedStatement prepExtObjStmt = null;
    protected PreparedStatement prepMovObjStmt = null;

    public OracleReporter(Properties properties, DrawableObjects objects) {
        super(properties, objects);
        if (properties.getProperty("dbMovingObjectTableName") != null) {
            this.dbMovingObjectTableName = properties.getProperty("dbMovingObjectTableName");
        }
        if (properties.getProperty("dbExternalObjectTableName") != null) {
            this.dbExternalObjectTableName = properties.getProperty("dbExternalObjectTableName");
        }
        try {
            this.con = OracleReporter.getConnection(properties);
            this.prepMovObjStmt = this.con.prepareStatement("INSERT INTO " + this.dbMovingObjectTableName + "(id,num,time,class,x,y,dbtime) VALUES (?,?,?,?,?,?,sysdate)");
            this.prepExtObjStmt = this.con.prepareStatement("INSERT INTO " + this.dbExternalObjectTableName + "(id,num,time,class,x,y,width,height,dbtime) VALUES (?,?,?,?,?,?,?,?,sysdate)");
        }
        catch (Exception ex) {
            System.err.println("OracleReporter: Error while connecting: " + ex);
            this.con = null;
        }
    }

    public void close() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(Properties properties) throws SQLException, ClassNotFoundException {
        String dbDriverClassName = "oracle.jdbc.driver.OracleDriver";
        String dbConnectionName = "jdbc:oracle:oci8:@geodata";
        String dbUserName = "scott";
        String dbPassword = "tiger";
        if (properties.getProperty("dbDriverClassName") != null) {
            dbDriverClassName = properties.getProperty("dbDriverClassName");
        }
        if (properties.getProperty("dbConnectionName") != null) {
            dbConnectionName = properties.getProperty("dbConnectionName");
        }
        if (properties.getProperty("dbUserName") != null) {
            dbUserName = properties.getProperty("dbUserName");
        }
        if (properties.getProperty("dbPassword") != null) {
            dbPassword = properties.getProperty("dbPassword");
        }
        Class.forName(dbDriverClassName);
        return DriverManager.getConnection(dbConnectionName, dbUserName, dbPassword);
    }

    public void removeReportedObjects() {
        super.removeReportedObjects();
        try {
            Connection con = OracleReporter.getConnection(this.properties);
            Statement stmt = con.createStatement();
            stmt.executeUpdate("DELETE FROM " + this.dbMovingObjectTableName);
            stmt.executeUpdate("DELETE FROM " + this.dbExternalObjectTableName);
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            System.err.println("removeReportedObjects: " + e);
        }
    }

    public void reportDisappearingExternalObject(int time, long id, int repNum, int objClass, Rectangle rect) {
        if (this.con != null) {
            try {
                this.prepExtObjStmt.setLong(1, id);
                this.prepExtObjStmt.setInt(2, repNum);
                this.prepExtObjStmt.setInt(3, time);
                this.prepExtObjStmt.setInt(4, objClass);
                this.prepExtObjStmt.setInt(5, -1);
                this.prepExtObjStmt.setInt(6, -1);
                this.prepExtObjStmt.setInt(7, 0);
                this.prepExtObjStmt.setInt(8, 0);
                this.prepExtObjStmt.execute();
            }
            catch (Exception ex) {
                System.err.println("reportDisappearingExternalObject: " + ex + " VALUES (" + id + "," + repNum + "," + time + "," + objClass + "," + rect + ")");
            }
        }
    }

    public void reportDisappearingObject(int time, long id, int repNum, int objClass, int x, int y, double doneDist, int reportProbability) {
        if (reportProbability > 0 && this.con != null) {
            try {
                this.prepMovObjStmt.setLong(1, id);
                this.prepMovObjStmt.setInt(2, repNum + 1);
                this.prepMovObjStmt.setInt(3, time);
                this.prepMovObjStmt.setInt(4, objClass);
                this.prepMovObjStmt.setInt(5, -1);
                this.prepMovObjStmt.setInt(6, -1);
                this.prepMovObjStmt.execute();
            }
            catch (Exception ex) {
                System.err.println("reportDisappearingObject: " + ex + " VALUES (" + id + "," + (repNum + 1) + "," + time + "," + objClass + "," + x + "," + y + ")");
            }
        }
    }

    public void reportMovingExternalObject(int time, long id, int repNum, int objClass, Rectangle rect) {
        super.reportMovingExternalObject(time, id, repNum, objClass, rect);
        if (this.con != null) {
            try {
                this.prepExtObjStmt.setLong(1, id);
                this.prepExtObjStmt.setInt(2, repNum);
                this.prepExtObjStmt.setInt(3, time);
                this.prepExtObjStmt.setInt(4, objClass);
                this.prepExtObjStmt.setInt(5, rect.x);
                this.prepExtObjStmt.setInt(6, rect.y);
                this.prepExtObjStmt.setInt(7, rect.width);
                this.prepExtObjStmt.setInt(8, rect.height);
                this.prepExtObjStmt.execute();
            }
            catch (Exception ex) {
                System.err.println("reportMovingExternalObject: " + ex + " VALUES (" + id + "," + repNum + "," + time + "," + objClass + "," + rect + ")");
            }
        }
    }

    public int reportMovingObject(int time, long id, int repNum, int objClass, double x, double y, double speed, double doneDist, int nextNodeX, int nextNodeY, int reportProbability) {
        int newRepNum = super.reportMovingObject(time, id, repNum, objClass, x, y, speed, doneDist, nextNodeX, nextNodeY, reportProbability);
        if (repNum != newRepNum && this.con != null) {
            try {
                this.prepMovObjStmt.setLong(1, id);
                this.prepMovObjStmt.setInt(2, newRepNum);
                this.prepMovObjStmt.setInt(3, time);
                this.prepMovObjStmt.setInt(4, objClass);
                this.prepMovObjStmt.setInt(5, (int)x);
                this.prepMovObjStmt.setInt(6, (int)y);
                this.prepMovObjStmt.execute();
            }
            catch (Exception ex) {
                System.err.println("reportMovingOject: " + ex + " VALUES (" + id + "," + newRepNum + "," + time + "," + objClass + "," + x + "," + y + ")");
            }
        }
        return newRepNum;
    }

    public void reportNewExternalObject(int time, long id, int objClass, Rectangle rect) {
        super.reportNewExternalObject(time, id, objClass, rect);
        if (this.con != null) {
            try {
                this.prepExtObjStmt.setLong(1, id);
                this.prepExtObjStmt.setInt(2, 1);
                this.prepExtObjStmt.setInt(3, time);
                this.prepExtObjStmt.setInt(4, objClass);
                this.prepExtObjStmt.setInt(5, rect.x);
                this.prepExtObjStmt.setInt(6, rect.y);
                this.prepExtObjStmt.setInt(7, rect.width);
                this.prepExtObjStmt.setInt(8, rect.height);
                this.prepExtObjStmt.execute();
            }
            catch (Exception ex) {
                System.err.println("reportNewExternalObject: " + ex + " VALUES (" + id + ",1," + time + "," + objClass + "," + rect + ")");
            }
        }
    }

    public int reportNewMovingObject(int time, long id, int objClass, int x, int y, double speed, int nextNodeX, int nextNodeY, int reportProbability) {
        int repNum = super.reportNewMovingObject(time, id, objClass, x, y, speed, nextNodeX, nextNodeY, reportProbability);
        if (repNum > 0 && this.con != null) {
            try {
                this.prepMovObjStmt.setLong(1, id);
                this.prepMovObjStmt.setInt(2, repNum);
                this.prepMovObjStmt.setInt(3, time);
                this.prepMovObjStmt.setInt(4, objClass);
                this.prepMovObjStmt.setInt(5, x);
                this.prepMovObjStmt.setInt(6, y);
                this.prepMovObjStmt.execute();
            }
            catch (Exception ex) {
                System.err.println("reportNewMovingOject: " + ex + " VALUES (" + id + "," + repNum + "," + time + "," + objClass + "," + x + "," + y + ")");
            }
        }
        return repNum;
    }
}

