/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataSpace;
import generator2.MovingObject;
import generator2.ObjectClasses;
import generator2.RandomGenerator;
import generator2.Time;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import routing.Node;
import routing.Nodes;

public class ObjectGenerator {
    protected static int currId = 0;
    protected Properties properties = null;
    protected Time time;
    protected DataSpace dataspace = null;
    protected ObjectClasses objClasses = null;
    protected Nodes nodes = null;
    protected Node[] node = null;
    protected int numOfObjPerTime = 1;
    protected int numOfObjAtBeginning = 0;
    protected double maxLength = 0.0;
    protected int numOfGeneratedNodes = 0;
    protected double totalLength = 0.0;
    protected Random random = null;

    public ObjectGenerator(Properties properties, Time time, DataSpace ds, Nodes nodes, ObjectClasses objClasses, int numOfObjPerTime, int numOfObjAtBeginning) {
        this.numOfObjPerTime = numOfObjPerTime;
        this.numOfObjAtBeginning = numOfObjAtBeginning;
        this.time = time;
        this.properties = properties;
        this.nodes = nodes;
        this.objClasses = objClasses;
        this.dataspace = ds;
        this.node = new Node[nodes.numOfNodes()];
        int i = 0;
        Enumeration e = nodes.elements();
        while (e.hasMoreElements()) {
            this.node[i++] = (Node)e.nextElement();
        }
        double dx = this.dataspace.getMaxX() - this.dataspace.getMinX();
        double dy = this.dataspace.getMaxY() - this.dataspace.getMinY();
        this.maxLength = Math.sqrt(dx * dx + dy * dy) / 5.0;
        this.random = RandomGenerator.get(properties);
    }

    public Node computeDestinationNode(int time, Node startingNode, int length, int objClass) {
        Node bestNode = this.computeNode(time, objClass, false);
        while (bestNode.equals(startingNode)) {
            bestNode = this.computeNode(time, objClass, false);
        }
        double bestDist = bestNode.distanceTo(startingNode);
        double bestDiff = Math.abs(bestDist - (double)length);
        long goodDiff = length / 10;
        int i = 0;
        while (i < 50 && bestDiff > (double)goodDiff) {
            Node newNode = this.computeNode(time, objClass, false);
            double newDist = newNode.distanceTo(startingNode);
            double newDiff = Math.abs(newDist - (double)length);
            if (newDiff < bestDiff && !newNode.equals(startingNode)) {
                bestNode = newNode;
                bestDist = newDist;
                bestDiff = newDiff;
            }
            ++i;
        }
        ++this.numOfGeneratedNodes;
        this.totalLength += bestDist;
        return bestNode;
    }

    public int computeId(int currTime) {
        return currId++;
    }

    public int computeLengthOfRoute(int time, int objClass) {
        double r = Math.abs(this.random.nextGaussian());
        int ext = (int)(r * this.maxLength);
        return ext;
    }

    private Node computeNode(int time, int objClass, boolean start) {
        if (this.properties.getProperty("DSO") != null) {
            int dx = this.dataspace.getMaxX() - this.dataspace.getMinX();
            int dy = this.dataspace.getMaxY() - this.dataspace.getMinY();
            int x = Math.abs(this.random.nextInt()) % (dx + 1) + this.dataspace.getMinX();
            int y = Math.abs(this.random.nextInt()) % (dy + 1) + this.dataspace.getMinY();
            return this.nodes.findNearest(x, y);
        }
        int index = Math.abs(this.random.nextInt()) % this.node.length;
        try {
            return this.node[index];
        }
        catch (Exception ex) {
            System.err.println(index);
            return this.node[index - 1];
        }
    }

    public int computeObjectClass(int currTime) {
        return this.objClasses.computeNewObjectClass(currTime);
    }

    public Node computeStartingNode(int time, int objClass) {
        return this.computeNode(time, objClass, true);
    }

    public int getAverageRouteLength() {
        if (this.numOfGeneratedNodes > 0) {
            return (int)(this.totalLength / (double)this.numOfGeneratedNodes);
        }
        return 0;
    }

    public int numberOfNewObjects(int time) {
        if (Time.isFirstTimeStamp(time)) {
            return this.numOfObjAtBeginning;
        }
        return this.numOfObjPerTime;
    }

    public void reachDestination(MovingObject obj) {
    }
}

