/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataSpace;
import generator2.RandomGenerator;
import generator2.Time;
import java.awt.Color;
import java.util.Properties;
import java.util.Random;

public class ObjectClasses {
    protected Time time;
    protected int num = 6;
    protected double[] maxSpeed;
    protected double[] portion;
    protected int[] reportProbability;
    protected Color[] color;
    private Random random;

    public ObjectClasses(Properties properties, Time time, DataSpace ds, int numOfClasses, int reportProb, int maxSpeedDivisor) {
        this.num = numOfClasses;
        this.time = time;
        this.random = RandomGenerator.get(properties);
        this.maxSpeed = new double[this.num];
        int dist = ds.getMaxX() - ds.getMinX() + ds.getMaxY() - ds.getMinY();
        this.maxSpeed[0] = dist / maxSpeedDivisor;
        int i = 1;
        while (i < this.num) {
            this.maxSpeed[i] = this.maxSpeed[i - 1] / 2.0;
            if (this.maxSpeed[i] <= 0.0) {
                this.maxSpeed[i] = 0.001;
            }
            ++i;
        }
        this.portion = new double[this.num];
        this.portion[0] = 0.5;
        i = 1;
        while (i < this.num - 1) {
            this.portion[i] = this.portion[i - 1] / 2.0;
            ++i;
        }
        if (this.num > 1) {
            this.portion[this.num - 1] = this.portion[this.num - 2];
        } else {
            this.portion[0] = 1.0;
        }
        int prob = reportProb;
        this.reportProbability = new int[this.num];
        int i2 = 0;
        while (i2 < this.num) {
            this.reportProbability[i2] = prob;
            ++i2;
        }
        this.color = new Color[this.num];
        this.color[0] = Color.red;
        if (this.num > 1) {
            this.color[1] = Color.blue;
        }
        if (this.num > 2) {
            this.color[2] = Color.orange;
        }
        if (this.num > 3) {
            this.color[3] = Color.magenta;
        }
        if (this.num > 4) {
            this.color[4] = Color.black;
        }
        if (this.num > 5) {
            this.color[5] = Color.green;
        }
        if (this.num > 6) {
            this.color[6] = Color.pink;
        }
        i2 = 7;
        while (i2 < this.num) {
            this.color[i2] = new Color(Math.abs(RandomGenerator.getForVisualization(properties).nextInt()) % 0x1000000);
            ++i2;
        }
    }

    public int computeNewObjectClass(int time) {
        double value = this.random.nextDouble();
        int res = this.num - 1;
        int i = 0;
        while (i < this.num) {
            if (value - this.portion[i] < 0.0) {
                res = i;
                break;
            }
            value -= this.portion[i];
            ++i;
        }
        return res;
    }

    public Color getColor(int c) {
        if (c >= 0 && c < this.num) {
            return this.color[c];
        }
        return Color.red;
    }

    public double getMaxSpeed(int c) {
        if (c >= 0 && c < this.num) {
            return this.maxSpeed[c];
        }
        return 0.0;
    }

    public int getNumber() {
        return this.num;
    }

    public int getReportProbability(int c) {
        if (c >= 0 && c < this.num) {
            return this.reportProbability[c];
        }
        return 0;
    }
}

