/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.MovingObjects;
import generator2.ObjectClasses;
import generator2.Reporter;
import routing.Edge;
import routing.Node;
import routing.PathEdge;
import util.Timer;

public class MovingObject {
    private static ObjectClasses objClasses = null;
    private MovingObjects container = null;
    private int id = 0;
    private int objClass = 0;
    private Node start = null;
    private Node dest = null;
    private int startTime = 0;
    private int lastTime = 0;
    private int actTime = 0;
    private int repNum = 0;
    private PathEdge route = null;
    private PathEdge lastRoute = null;
    private Node lastNode = null;
    private double relDist = 0.0;
    private double doneDist = 0.0;
    private double lastX = 0.0;
    private double lastY = 0.0;
    private double arrivalTime;
    private int edgeNum = 0;

    public MovingObject(int id, int objClass, Node start, Node dest, int time) {
        this.id = id;
        this.objClass = objClass;
        this.start = start;
        this.dest = dest;
        this.startTime = time;
        this.lastTime = time;
        this.actTime = time;
        this.lastNode = start;
        this.lastX = start.getX();
        this.lastY = start.getY();
    }

    public void addToContainer(MovingObjects container) {
        if (container != null) {
            this.container = container;
            container.add(this);
            if (objClasses == null) {
                objClasses = container.getObjectClasses();
            }
        }
    }

    public static double computeDistance(double x1, double y1, double x2, double y2) {
        double xDist = Math.abs(x1 - x2);
        double yDist = Math.abs(y1 - y2);
        return Math.sqrt(xDist * xDist + yDist * yDist);
    }

    private boolean computeNextPoint(int newTime, Reporter reporter) {
        if (this.route == null) {
            return true;
        }
        Edge actEdge = this.route.getEdge();
        this.decreaseUsage(this.route);
        this.lastRoute = this.route;
        if (this.container.getReRoute().computeNewRouteByEvent(this.lastTime, this.actTime)) {
            this.reroute(actEdge);
        }
        double remainingTime = 1.0;
        double llx = this.lastX;
        double lly = this.lastY;
        double actDist = actEdge.getLength();
        if (actDist == 0.0) {
            actDist = 1.0;
        }
        double actWeight = actEdge.getWeight();
        double speed = actDist / actWeight;
        double maxDistOnEdge = remainingTime * speed;
        while (true) {
            if (this.relDist + maxDistOnEdge < actDist) {
                this.relDist += maxDistOnEdge;
                this.computePoint(actEdge, this.lastNode, this.relDist);
                Timer.stop(1);
                this.doneDist += MovingObject.computeDistance(llx, lly, this.lastX, this.lastY);
                int oldRepNum = this.repNum;
                Node nextNode = this.route.getDestinationNode();
                this.repNum = reporter.reportMovingObject(newTime, this.id, this.repNum, this.objClass, this.lastX, this.lastY, speed, this.doneDist, nextNode.getX(), nextNode.getY(), objClasses.getReportProbability(this.objClass));
                if (this.repNum != oldRepNum) {
                    this.doneDist = 0.0;
                }
                Timer.start(1);
                return false;
            }
            remainingTime -= (actDist - this.relDist) * actWeight / actDist;
            this.relDist = 0.0;
            this.lastNode = actEdge.getOppositeNode(this.lastNode);
            this.doneDist += MovingObject.computeDistance(llx, lly, this.lastNode.getX(), this.lastNode.getY());
            llx = this.lastNode.getX();
            lly = this.lastNode.getY();
            if (this.lastNode == this.dest) {
                this.decreaseUsage(null);
                this.arrivalTime = (double)newTime - remainingTime;
                return true;
            }
            this.route = this.route.getNext();
            if (this.route == null) {
                this.dest = this.lastNode;
                this.decreaseUsage(null);
                this.arrivalTime = (double)newTime - remainingTime;
                return true;
            }
            actEdge = this.route.getEdge();
            actEdge.incUsage();
            actDist = actEdge.getLength();
            if (actDist == 0.0) {
                actDist = 1.0;
            }
            actWeight = actEdge.getWeight();
            speed = actDist / actWeight;
            maxDistOnEdge = remainingTime * speed;
            Timer.stop(1);
            reporter.reportEdge((double)newTime - remainingTime, this.id, ++this.edgeNum, this.objClass, actEdge.getId(), actEdge.getEdgeClass(), this.route.getStartingNode().getX(), this.route.getStartingNode().getY(), speed, this.route.getDestinationNode().getX(), this.route.getDestinationNode().getY(), objClasses.getReportProbability(this.objClass));
            Timer.start(1);
            if (!this.container.getReRoute().computeNewRouteByComparison(this.lastTime, this.actTime, (int)(2.147483647E9 / this.route.getOrigWeight()), (int)(2.147483647E9 / actWeight))) continue;
            this.reroute(actEdge);
        }
    }

    private void computePoint(int x1, int y1, int x2, int y2, double portion, double length) {
        if (length == 0.0) {
            length = 1.0;
        }
        this.lastX = (double)x1 + (double)(x2 - x1) * portion / length;
        this.lastY = (double)y1 + (double)(y2 - y1) * portion / length;
    }

    private void computePoint(Edge edge, Node start, double portion) {
        if (start == edge.getNode1()) {
            this.computePoint(edge.getNode1().getX(), edge.getNode1().getY(), edge.getNode2().getX(), edge.getNode2().getY(), portion, edge.getLength());
        } else {
            this.computePoint(edge.getNode2().getX(), edge.getNode2().getY(), edge.getNode1().getX(), edge.getNode1().getY(), portion, edge.getLength());
        }
    }

    public boolean computeRoute() {
        if (this.container != null) {
            this.container.getWeightManager().setActualObjectClass(this.objClass);
            Timer.start(2);
            this.route = this.container.getNetwork().computeFastWay2(this.start, this.dest);
            Timer.stop(2);
            if (this.route != null) {
                if (this.route.getNext() == null || this.route.getNext().getNext() == null) {
                    return false;
                }
                this.route.getEdge().incUsage();
                if (this.container != null) {
                    this.container.incTraversedNodesBy(this.route.computeNumber());
                    this.container.incTraversedDegreeBy(this.route.computeDegree());
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected void decreaseUsage(PathEdge actPathEdge) {
        PathEdge path = this.lastRoute;
        if (path != null) {
            Edge travEdge = path.getEdge();
            while (path != null && path != actPathEdge) {
                travEdge.decUsage();
                path = path.getNext();
                if (path == null) continue;
                travEdge = path.getEdge();
            }
        }
    }

    protected PathEdge getActPathEdge() {
        return this.route;
    }

    protected Node getDestinationNode() {
        return this.dest;
    }

    public int getId() {
        return this.id;
    }

    public int getObjectClass() {
        return this.objClass;
    }

    public int getRepNum() {
        return this.repNum;
    }

    protected Node getStartingNode() {
        return this.start;
    }

    public boolean move(int newTime, Reporter reporter) {
        if (this.container != null) {
            this.container.getWeightManager().setActualObjectClass(this.objClass);
            while (this.actTime < newTime) {
                ++this.actTime;
                if (!this.computeNextPoint(this.actTime, reporter)) continue;
                return true;
            }
        }
        return false;
    }

    public void reportEnd(Reporter reporter) {
        Timer.stop(1);
        if (reporter != null) {
            reporter.reportDisappearingObject(this.arrivalTime, this.id, this.repNum, this.objClass, this.dest.getX(), this.dest.getY(), this.doneDist, objClasses.getReportProbability(this.objClass));
        }
        Timer.start(1);
    }

    public void reportNewObject(Reporter reporter) {
        Timer.stop(1);
        if (reporter != null) {
            Edge currEdge = this.route.getEdge();
            double actDist = currEdge.getLength();
            double actWeight = currEdge.getWeight();
            double speed = actDist / actWeight;
            Node nextNode = this.route.getDestinationNode();
            this.repNum = reporter.reportNewMovingObject(this.startTime, this.id, this.objClass, this.start.getX(), this.start.getY(), speed, nextNode.getX(), nextNode.getY(), objClasses.getReportProbability(this.objClass));
            reporter.reportEdge(this.startTime, this.id, ++this.edgeNum, this.objClass, currEdge.getId(), currEdge.getEdgeClass(), this.route.getStartingNode().getX(), this.route.getStartingNode().getY(), speed, this.route.getDestinationNode().getX(), this.route.getDestinationNode().getY(), objClasses.getReportProbability(this.objClass));
        }
        Timer.start(1);
    }

    private void reroute(Edge actEdge) {
        this.container.getWeightManager().setActualObjectClass(this.objClass);
        Timer.start(2);
        PathEdge newPath = this.container.getNetwork().computeFastWay2(actEdge.getOppositeNode(this.lastNode), this.dest);
        Timer.stop(2);
        if (newPath != null && this.container != null) {
            this.route.setNext(newPath);
            this.container.incTraversedNodesBy(this.route.computeNumber());
            this.container.incTraversedDegreeBy(this.route.computeDegree());
        }
        this.lastTime = this.actTime;
    }

    public void setDestination(Node dest) {
        this.dest = dest;
    }

    public void setRepNum(int num) {
        this.repNum = num;
    }

    public void setStart(Node start) {
        this.start = start;
        this.lastNode = start;
        this.lastX = start.getX();
        this.lastY = start.getY();
    }
}

