/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import drawables.DrawableObject;
import drawables.DrawableObjects;
import drawables.DrawableObjectsWithSearchTree;
import drawables.DrawablePresentation;
import generator2.DataSpace;
import generator2.EdgeClasses;
import generator2.ExternalObject;
import generator2.ExternalObjectClasses;
import generator2.ExternalObjectGenerator;
import generator2.ExternalObjects;
import generator2.MovingObject;
import generator2.MovingObjects;
import generator2.ObjectClasses;
import generator2.ObjectGenerator;
import generator2.ReRoute;
import generator2.Reporter;
import generator2.Time;
import generator2.WeightManagerForDataGenerator;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import routing.BorderHeap;
import routing.Edge;
import routing.Edges;
import routing.Network;
import routing.Node;
import routing.Nodes;
import showmap.LoadDrawables;
import showmap.ShowMap;
import showmap.ShowNetworkMap;
import spatial.MemoryRTree;
import util.ColorDefiner;
import util.Timer;

public abstract class DataGenerator
extends ShowNetworkMap
implements AdjustmentListener {
    protected Properties properties = new Properties();
    protected static String propFilename = "properties.txt";
    protected int actTime = 0;
    protected Time time = null;
    protected DataSpace dataspace = null;
    protected EdgeClasses edgeClasses = null;
    protected ObjectClasses objClasses = null;
    protected ExternalObjects extObjects = null;
    protected ExternalObjectClasses extObjClasses = null;
    protected Reporter reporter = null;
    public static final int PROPERTY_FILE_ERROR = -1;
    public static final int APPLICATION_START_ERROR = -2;
    public static final int NETWORKFILE_ERROR = -3;
    public static int MAX_EXTOBJBEGIN = 100;
    public static int MAX_EXTOBJCLASSES = 10;
    public static int MAX_EXTOBJPERTIME = 10;
    public static int MAX_MAXTIME = 64000;
    public static int MAX_OBJBEGIN = 1000;
    public static int MAX_OBJCLASSES = 20;
    public static int MAX_OBJPERTIME = 800;
    public static int MIN_MAXTIME = 5;
    protected int waitingPeriod = 0;
    protected static Frame frame = null;
    private Button computeButton = null;
    private Button addTimeButton = null;
    private Scrollbar timeScrollbar = null;
    private Label maxTimeLabel = null;
    private TextField maxTimeText = null;
    private Label numObjClassesLabel = null;
    private TextField numObjClassesText = null;
    private TextField numExtObjClassesText = null;
    private Label objPerTimeLabel = null;
    private TextField objPerTimeText = null;
    private Label objBeginLabel = null;
    private TextField extobjPerTimeText = null;
    private TextField extobjBeginText = null;
    private Button deleteButton = null;
    private Label msdLabel = null;
    private TextField msdText = null;
    private TextField objBeginText = null;
    private Label reportProbLabel = null;
    private TextField reportProbText = null;

    public static void main(String nameOfApplet) {
        try {
            frame = new Frame("Network Generator");
            Class<?> iiCls = Class.forName(nameOfApplet);
            ClassLoader iiClsLoader = iiCls.getClassLoader();
            DataGenerator aDataGenerator = (DataGenerator)Beans.instantiate(iiClsLoader, nameOfApplet);
            frame.add("Center", aDataGenerator);
            Dimension size = aDataGenerator.getSize();
            size.setSize(size.width + 10, size.height + 50);
            ((Component)frame).setSize(size);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of generator2.DataGenerator " + exception);
            System.exit(-2);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int newTime;
        super.actionPerformed(e);
        if (e.getSource() == this.getComputeButton()) {
            this.compute();
        }
        if (e.getSource() == this.getAddTimeButton() && this.time != null && (newTime = this.actTime + 1) <= this.time.getMaxTime()) {
            this.setTime(newTime);
            this.setTimeScrollbar(newTime);
            this.repaint();
        }
        if (e.getSource() == this.getDeleteButton()) {
            this.deleteObjects();
            this.deleteButton.setEnabled(false);
            this.getAddTimeButton().setEnabled(false);
            this.getComputeButton().setEnabled(true);
        }
    }

    protected void addComponentsToApplet() {
        super.addComponentsToApplet();
        this.remove(this.getTagLabel());
        this.remove(this.getValueLabel());
        this.remove(this.getClickInfoLabel());
        this.remove(this.getShiftClickInfoLabel());
        this.remove(this.getPressInfoLabel());
        this.add((Component)this.getComputeButton(), this.getComputeButton().getName());
        this.add((Component)this.getAddTimeButton(), this.getAddTimeButton().getName());
        this.add((Component)this.getTimeScrollbar(), this.getTimeScrollbar().getName());
        this.add((Component)this.getMaxTimeLabel(), this.getMaxTimeLabel().getName());
        this.add((Component)this.getMaxTimeTextField(), this.getMaxTimeTextField().getName());
        this.add((Component)this.getReportProbLabel(), this.getReportProbLabel().getName());
        this.add((Component)this.getReportProbTextField(), this.getReportProbTextField().getName());
        this.add((Component)this.getMsdLabel(), this.getMsdLabel().getName());
        this.add((Component)this.getMsdTextField(), this.getMsdTextField().getName());
        this.add((Component)this.getNumObjClassesLabel(), this.getNumObjClassesLabel().getName());
        this.add((Component)this.getNumObjClassesTextField(), this.getNumObjClassesTextField().getName());
        this.add((Component)this.getNumExtObjClassesTextField(), this.getNumExtObjClassesTextField().getName());
        this.add((Component)this.getObjPerTimeLabel(), this.getObjPerTimeLabel().getName());
        this.add((Component)this.getObjPerTimeTextField(), this.getObjPerTimeTextField().getName());
        this.add((Component)this.getObjBeginLabel(), this.getObjBeginLabel().getName());
        this.add((Component)this.getObjBeginTextField(), this.getObjBeginTextField().getName());
        this.add((Component)this.getExtObjPerTimeTextField(), this.getExtObjPerTimeTextField().getName());
        this.add((Component)this.getExtObjBeginTextField(), this.getExtObjBeginTextField().getName());
        this.add((Component)this.getDeleteButton(), this.getDeleteButton().getName());
    }

    protected void addComponentsToListeners() {
        super.addComponentsToListeners();
        this.getComputeButton().addActionListener(this);
        this.getAddTimeButton().addActionListener(this);
        this.getTimeScrollbar().addAdjustmentListener(this);
        this.getDeleteButton().addActionListener(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.getTimeScrollbar() && this.time != null) {
            int newTime = e.getValue() * this.time.getMaxTime() / (this.timeScrollbar.getMaximum() - this.timeScrollbar.getVisibleAmount());
            if (newTime != this.actTime) {
                // empty if block
            }
            this.setTime(newTime);
            this.repaint();
        }
    }

    public void changeComponentPositions() {
        super.changeComponentPositions();
        this.getScaleLabel().setBounds(this.viewX, this.viewY + this.viewHeight + 4, 70, 23);
        this.getComputeButton().setBounds(this.viewX, this.viewY + this.viewHeight + 48, 76, 29);
        this.getAddTimeButton().setBounds(this.viewX + this.viewWidth - 76, this.viewY + this.viewHeight + 48, 76, 29);
        this.getTimeScrollbar().setBounds(this.viewX, this.viewY + this.viewHeight + 140, this.viewWidth, 18);
        this.getNameLabel().setBounds(this.viewX + 90, this.viewY + this.viewHeight + 4, 60, 23);
        this.getMaxTimeLabel().setBounds(this.viewX, this.viewY + this.viewHeight + 82, 140, 23);
        this.getMaxTimeTextField().setBounds(this.viewX + 150, this.viewY + this.viewHeight + 82, 40, 23);
        this.getNumObjClassesLabel().setBounds(this.viewX + this.viewWidth / 2 + 25, this.viewY + this.viewHeight + 82, 155, 23);
        this.getNumObjClassesTextField().setBounds(this.viewX + this.viewWidth / 2 + 185, this.viewY + this.viewHeight + 82, 30, 23);
        this.getNumExtObjClassesTextField().setBounds(this.viewX + this.viewWidth / 2 + 220, this.viewY + this.viewHeight + 82, 30, 23);
        this.getObjBeginLabel().setBounds(this.viewX + this.viewWidth / 2 + 25, this.viewY + this.viewHeight + 1, 155, 23);
        this.getObjBeginTextField().setBounds(this.viewX + this.viewWidth / 2 + 185, this.viewY + this.viewHeight + 1, 30, 21);
        this.getExtObjBeginTextField().setBounds(this.viewX + this.viewWidth / 2 + 220, this.viewY + this.viewHeight + 1, 30, 21);
        this.getObjPerTimeLabel().setBounds(this.viewX + this.viewWidth / 2 + 25, this.viewY + this.viewHeight + 23, 155, 23);
        this.getObjPerTimeTextField().setBounds(this.viewX + this.viewWidth / 2 + 185, this.viewY + this.viewHeight + 23, 30, 21);
        this.getExtObjPerTimeTextField().setBounds(this.viewX + this.viewWidth / 2 + 220, this.viewY + this.viewHeight + 23, 30, 21);
        this.getCopyrightLabel().setBounds(this.viewX, this.viewY + this.viewHeight + 180, this.viewWidth - 100, 19);
        this.getReportProbLabel().setBounds(this.viewX, this.viewY + this.viewHeight + 112, 148, 23);
        this.getReportProbTextField().setBounds(this.viewX + 150, this.viewY + this.viewHeight + 112, 40, 23);
        this.getMsdLabel().setBounds(this.viewX + 195, this.viewY + this.viewHeight + 112, 260, 23);
        this.getMsdTextField().setBounds(this.viewX + this.viewWidth / 2 + 220, this.viewY + this.viewHeight + 112, 30, 23);
        this.getDeleteButton().setBounds(this.viewX + 150, this.viewY + this.viewHeight + 6, 75, 29);
    }

    public synchronized void compute() {
        this.getComputeButton().setEnabled(false);
        this.showStatus("initialize generation...");
        Network net = this.getNetwork();
        Nodes nodes = net.getNodes();
        Edges edges = net.getEdges();
        if (this.time == null) {
            this.time = new Time(this.properties, this.getValueOfTextField(this.getMaxTimeTextField(), MIN_MAXTIME, MAX_MAXTIME, false));
            this.dataspace = new DataSpace(this.drawableObjects);
            this.objClasses = this.createObjectClasses(this.properties, this.time, this.dataspace, this.getValueOfTextField(this.getNumObjClassesTextField(), 1, MAX_OBJCLASSES, false), this.getValueOfTextField(this.getReportProbTextField(), 0, 1000, false), this.getValueOfTextField(this.getMsdTextField(), 1, 1000, true));
            this.extObjClasses = this.createExternalObjectClasses(this.properties, this.time, this.dataspace, this.getValueOfTextField(this.getNumExtObjClassesTextField(), 1, MAX_EXTOBJCLASSES, false));
            if (this.properties.getProperty("VIZ") != null) {
                int i;
                int c = 0;
                while (c < this.objClasses.getNumber()) {
                    i = 0;
                    while (i <= this.time.getMaxTime()) {
                        DrawablePresentation.newDrawablePresentation("Point" + c + "-" + i, false, this.objClasses.getColor(c), Color.red, 1, 8);
                        ++i;
                    }
                    ++c;
                }
                c = 0;
                while (c < this.extObjClasses.getNumber()) {
                    i = 0;
                    while (i <= this.time.getMaxTime()) {
                        DrawablePresentation.newDrawablePresentation("Rectangle" + c + "-" + i, false, this.extObjClasses.getColor(c), Color.red);
                        ++i;
                    }
                    ++c;
                }
            }
        }
        this.time.reset();
        this.edgeClasses.announce(this.time, this.dataspace, this.getValueOfTextField(this.getMsdTextField(), 1, 1000, true));
        ExternalObjectGenerator extObjGen = this.createExternalObjectGenerator(this.properties, this.time, this.dataspace, this.extObjClasses, this.getValueOfTextField(this.getExtObjPerTimeTextField(), 0, MAX_EXTOBJPERTIME, true), this.getValueOfTextField(this.getExtObjBeginTextField(), 0, MAX_EXTOBJBEGIN, true));
        boolean extObjectsExist = extObjGen.externalObjectsExist();
        if (extObjectsExist && this.extObjects == null) {
            this.extObjects = new ExternalObjects(this.properties, this.time, this.extObjClasses);
        }
        this.reporter = this.createReporter(this.properties, this.drawableObjects);
        this.deleteButton.setEnabled(true);
        WeightManagerForDataGenerator wm = null;
        wm = extObjectsExist ? new WeightManagerForDataGenerator(this.edgeClasses, this.objClasses, this.extObjects) : new WeightManagerForDataGenerator(this.edgeClasses, this.objClasses, null);
        edges.setWeightManager(wm);
        ReRoute reroute = this.createReRoute(this.properties, this.time, this.dataspace);
        ObjectGenerator objGen = this.createObjectGenerator(this.properties, this.time, this.dataspace, nodes, this.objClasses, this.getValueOfTextField(this.getObjPerTimeTextField(), 0, MAX_OBJPERTIME, true), this.getValueOfTextField(this.getObjBeginTextField(), 0, MAX_OBJBEGIN, true));
        MovingObjects movingObjects = new MovingObjects(wm, net, objGen, this.reporter, reroute);
        this.showStatus("generate data, please wait...");
        Timer.reset(1);
        Timer.reset(2);
        Timer.start(1);
        this.actTime = this.time.getCurrTime();
        while (!this.time.isMaximumTimeExceeded()) {
            if (extObjectsExist) {
                this.extObjects.moveAndResizeAndRemoveObjects(this.actTime, extObjGen, this.reporter);
            }
            movingObjects.move(this.actTime);
            int numOfNewExtObjects = extObjGen.numberOfNewObjects(this.actTime);
            int i = 0;
            while (i < numOfNewExtObjects) {
                ExternalObject extObj = extObjGen.computeExternalObject(this.actTime);
                extObj.addToContainer(this.extObjects);
                extObj.reportNewObject(this.reporter);
                ++i;
            }
            int numOfNewObjects = objGen.numberOfNewObjects(this.actTime);
            int i2 = 0;
            while (i2 < numOfNewObjects) {
                int id = objGen.computeId(this.actTime);
                int objClass = objGen.computeObjectClass(this.actTime);
                Node start = objGen.computeStartingNode(this.actTime, objClass);
                Node dest = objGen.computeDestinationNode(this.actTime, start, objGen.computeLengthOfRoute(this.actTime, objClass), objClass);
                MovingObject obj = new MovingObject(id, objClass, start, dest, this.actTime);
                obj.addToContainer(movingObjects);
                while (!obj.computeRoute()) {
                    obj.setStart(objGen.computeStartingNode(this.actTime, objClass));
                    obj.setDestination(objGen.computeDestinationNode(this.actTime, start, objGen.computeLengthOfRoute(this.actTime, objClass), objClass));
                }
                obj.reportNewObject(this.reporter);
                ++i2;
            }
            if (this.waitingPeriod > 0) {
                int c;
                if (!Time.isFirstTimeStamp(this.actTime)) {
                    c = 0;
                    while (c < this.objClasses.getNumber()) {
                        DrawablePresentation.get("Point" + c + "-" + (this.actTime - 1)).setVisibility(false);
                        ++c;
                    }
                    c = 0;
                    while (c < this.extObjClasses.getNumber()) {
                        DrawablePresentation.get("Rectangle" + c + "-" + (this.actTime - 1)).setVisibility(false);
                        ++c;
                    }
                }
                c = 0;
                while (c < this.objClasses.getNumber()) {
                    DrawablePresentation.get("Point" + c + "-" + this.actTime).setVisibility(true);
                    ++c;
                }
                c = 0;
                while (c < this.extObjClasses.getNumber()) {
                    DrawablePresentation.get("Rectangle" + c + "-" + this.actTime).setVisibility(true);
                    ++c;
                }
                this.update(this.getGraphics());
            }
            this.time.increaseCurrTime();
            this.actTime = this.time.getCurrTime();
            if (this.actTime % 25 == 0) {
                System.gc();
            }
            this.reportProgress(this.actTime);
            if (this.waitingPeriod <= 0) continue;
            try {
                this.wait(this.waitingPeriod);
            }
            catch (Exception e) {
                System.err.println("wait: " + e);
            }
        }
        Timer.stop(1);
        this.showStatus("remove remaining objects and report statistics...");
        movingObjects.removeObjects();
        if (extObjectsExist) {
            this.extObjects.removeObjects();
        }
        long totalTime = Timer.get(1);
        long routingTime = Timer.get(2);
        int numOfRoutes = movingObjects.getTotalNumOfObjects() + reroute.getNumberOfRoutesByEvent() + reroute.getNumberOfRoutesByComparison();
        int dx = this.dataspace.getMaxX() - this.dataspace.getMinX();
        int dy = this.dataspace.getMaxY() - this.dataspace.getMinY();
        this.reporter.reportInt("data space width: ", dx);
        this.reporter.reportInt("data space height: ", dy);
        this.reporter.reportInt("number of nodes: ", nodes.numOfNodes());
        this.reporter.reportInt("number of edges: ", edges.numOfEdges());
        this.reporter.reportInt("maximum time: ", this.time.getMaxTime());
        this.reporter.reportInt("# moving objects: ", movingObjects.getTotalNumOfObjects());
        this.reporter.reportInt("# points: ", this.reporter.getNumberOfReportedPoints());
        this.reporter.reportInt("# traversed nodes: ", movingObjects.getTotalNumberOfTraversedNodes());
        this.reporter.reportDouble("# nodes/obj: ", (double)movingObjects.getTotalNumberOfTraversedNodes() / (double)movingObjects.getTotalNumOfObjects());
        this.reporter.reportDouble("# traversed degree: ", movingObjects.getTotalDegreeOfTraversedNodes());
        double nodeDegree = (double)(movingObjects.getTotalDegreeOfTraversedNodes() - movingObjects.getTotalNumberOfTraversedNodes()) / (double)movingObjects.getTotalNumberOfTraversedNodes();
        this.reporter.reportDouble("# node degree: ", nodeDegree);
        this.reporter.reportInt("# all routes: ", numOfRoutes);
        this.reporter.reportInt("# routes by event: ", reroute.getNumberOfRoutesByEvent());
        this.reporter.reportInt("# routes by comparison: ", reroute.getNumberOfRoutesByComparison());
        this.reporter.reportInt("total time in ms: ", totalTime);
        this.reporter.reportDouble("total time/obj: ", (double)totalTime / (double)movingObjects.getTotalNumOfObjects());
        this.reporter.reportDouble("total time/point: ", (double)totalTime / (double)this.reporter.getNumberOfReportedPoints());
        this.reporter.reportDouble("routing time in ms: ", routingTime);
        this.reporter.reportDouble("insert time: ", BorderHeap.insertTimer.get());
        this.reporter.reportDouble("fetch time:  ", BorderHeap.fetchTimer.get());
        this.reporter.reportDouble("change time: ", BorderHeap.changeTimer.get());
        this.reporter.reportDouble("routing time/obj: ", (double)routingTime / (double)movingObjects.getTotalNumOfObjects());
        this.reporter.reportDouble("routing time/point: ", (double)routingTime / (double)this.reporter.getNumberOfReportedPoints());
        this.reporter.reportDouble("routing time/node: ", (double)routingTime / (double)movingObjects.getTotalNumberOfTraversedNodes());
        this.reporter.reportDouble("routing time/node/nodedegr: ", (double)routingTime / (double)movingObjects.getTotalNumberOfTraversedNodes() / nodeDegree);
        this.reporter.reportDouble("routing time/routing: ", (double)routingTime / (double)numOfRoutes);
        if (extObjectsExist) {
            this.reporter.reportInt("# computed decreases: ", this.extObjects.getNumOfComputedDecreases());
            this.reporter.reportInt("# real decreases: ", this.extObjects.getNumOfRealDecreases());
            this.reporter.reportInt("time for external objects in ms: ", this.extObjects.getUsedTime());
        }
        long totalDistance = 0L;
        Enumeration e = edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            totalDistance = (long)((double)totalDistance + edge.getLength());
        }
        int avDistance = (int)(totalDistance / (long)edges.numOfEdges());
        this.reporter.reportInt("average edge length: ", avDistance);
        this.reporter.reportInt("average route length: ", objGen.getAverageRouteLength());
        this.reporter.close();
        this.setTime(0);
        this.setTimeScrollbar(0);
        this.addTimeButton.setEnabled(true);
        this.repaint();
        this.showStatus("ready...");
    }

    public abstract EdgeClasses createEdgeClasses(Properties var1);

    public abstract ExternalObjectClasses createExternalObjectClasses(Properties var1, Time var2, DataSpace var3, int var4);

    public abstract ExternalObjectGenerator createExternalObjectGenerator(Properties var1, Time var2, DataSpace var3, ExternalObjectClasses var4, int var5, int var6);

    public abstract ObjectClasses createObjectClasses(Properties var1, Time var2, DataSpace var3, int var4, int var5, int var6);

    public abstract ObjectGenerator createObjectGenerator(Properties var1, Time var2, DataSpace var3, Nodes var4, ObjectClasses var5, int var6, int var7);

    public abstract Reporter createReporter(Properties var1, DrawableObjects var2);

    public abstract ReRoute createReRoute(Properties var1, Time var2, DataSpace var3);

    protected void deleteObjects() {
        if (this.reporter != null) {
            this.reporter.removeReportedObjects();
        }
        this.repaint();
    }

    protected Button getAddTimeButton() {
        if (this.addTimeButton == null) {
            this.addTimeButton = new Button();
            this.addTimeButton.setName("AddTimeButton");
            this.addTimeButton.setFont(new Font("Dialog", 0, 12));
            this.addTimeButton.setLabel("Time +");
            this.addTimeButton.setEnabled(false);
        }
        return this.addTimeButton;
    }

    protected Button getComputeButton() {
        if (this.computeButton == null) {
            this.computeButton = new Button();
            this.computeButton.setName("ComputeButton");
            this.computeButton.setFont(new Font("Dialog", 0, 12));
            this.computeButton.setLabel("Compute");
            this.computeButton.setEnabled(false);
        }
        return this.computeButton;
    }

    protected Button getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new Button();
            this.deleteButton.setName("DeleteObjectsButton");
            this.deleteButton.setFont(new Font("Dialog", 0, 12));
            this.deleteButton.setLabel("Delete Obj.");
            this.deleteButton.setEnabled(false);
        }
        return this.deleteButton;
    }

    protected TextField getExtObjBeginTextField() {
        if (this.extobjBeginText == null) {
            this.extobjBeginText = new TextField("0");
            this.extobjBeginText.setName("ExtObjBeginTextField");
            this.extobjBeginText.setFont(new Font("Dialog", 0, 11));
        }
        return this.extobjBeginText;
    }

    protected TextField getExtObjPerTimeTextField() {
        if (this.extobjPerTimeText == null) {
            this.extobjPerTimeText = new TextField("0");
            this.extobjPerTimeText.setName("ExtObjPerTimeTextField");
            this.extobjPerTimeText.setFont(new Font("Dialog", 0, 11));
        }
        return this.extobjPerTimeText;
    }

    protected String getInfoText(DrawableObject obj) {
        return null;
    }

    protected Label getMaxTimeLabel() {
        if (this.maxTimeLabel == null) {
            this.maxTimeLabel = new Label();
            this.maxTimeLabel.setName("MaxTimeLabel");
            this.maxTimeLabel.setFont(new Font("sansserif", 0, 12));
            this.maxTimeLabel.setText("maximum time (" + MIN_MAXTIME + "-" + MAX_MAXTIME + "):");
        }
        return this.maxTimeLabel;
    }

    protected TextField getMaxTimeTextField() {
        if (this.maxTimeText == null) {
            this.maxTimeText = new TextField("20");
            this.maxTimeText.setName("MaxTimeTextField");
            this.maxTimeText.setFont(new Font("Dialog", 0, 11));
        }
        return this.maxTimeText;
    }

    protected Label getMsdLabel() {
        if (this.msdLabel == null) {
            this.msdLabel = new Label();
            this.msdLabel.setName("MsdLabel");
            this.msdLabel.setFont(new Font("sansserif", 0, 12));
            this.msdLabel.setText("max.speed div. (10=fast,50=middle,250=slow):");
        }
        return this.msdLabel;
    }

    protected TextField getMsdTextField() {
        if (this.msdText == null) {
            this.msdText = new TextField("50");
            this.msdText.setName("ReportProbTextField");
            this.msdText.setFont(new Font("Dialog", 0, 11));
        }
        return this.msdText;
    }

    protected TextField getNumExtObjClassesTextField() {
        if (this.numExtObjClassesText == null) {
            this.numExtObjClassesText = new TextField("3");
            this.numExtObjClassesText.setName("NumExtObjClassesTextField");
            this.numExtObjClassesText.setFont(new Font("Dialog", 0, 11));
        }
        return this.numExtObjClassesText;
    }

    protected Label getNumObjClassesLabel() {
        if (this.numObjClassesLabel == null) {
            this.numObjClassesLabel = new Label();
            this.numObjClassesLabel.setName("NumObjClassesLabel");
            this.numObjClassesLabel.setFont(new Font("sansserif", 0, 12));
            this.numObjClassesLabel.setText("classes (M:1-" + MAX_OBJCLASSES + "/E:1-" + MAX_EXTOBJCLASSES + "):");
        }
        return this.numObjClassesLabel;
    }

    protected TextField getNumObjClassesTextField() {
        if (this.numObjClassesText == null) {
            this.numObjClassesText = new TextField("6");
            this.numObjClassesText.setName("NumObjClassesTextField");
            this.numObjClassesText.setFont(new Font("Dialog", 0, 11));
        }
        return this.numObjClassesText;
    }

    protected Label getObjBeginLabel() {
        if (this.objBeginLabel == null) {
            this.objBeginLabel = new Label();
            this.objBeginLabel.setName("ExtObjPerTimeLabel");
            this.objBeginLabel.setFont(new Font("sansserif", 0, 12));
            this.objBeginLabel.setText("obj./begin (M:-" + MAX_OBJBEGIN + " E:-" + MAX_EXTOBJBEGIN + "):");
        }
        return this.objBeginLabel;
    }

    protected TextField getObjBeginTextField() {
        if (this.objBeginText == null) {
            this.objBeginText = new TextField("5");
            this.objBeginText.setName("ObjBeginTextField");
            this.objBeginText.setFont(new Font("Dialog", 0, 11));
        }
        return this.objBeginText;
    }

    protected Label getObjPerTimeLabel() {
        if (this.objPerTimeLabel == null) {
            this.objPerTimeLabel = new Label();
            this.objPerTimeLabel.setName("ObjPerTimeLabel");
            this.objPerTimeLabel.setFont(new Font("sansserif", 0, 12));
            this.objPerTimeLabel.setText("obj./time (M:-" + MAX_OBJPERTIME + "/E:-" + MAX_EXTOBJPERTIME + "):");
        }
        return this.objPerTimeLabel;
    }

    protected TextField getObjPerTimeTextField() {
        if (this.objPerTimeText == null) {
            this.objPerTimeText = new TextField("5");
            this.objPerTimeText.setName("ObjPerTimeTextField");
            this.objPerTimeText.setFont(new Font("Dialog", 0, 11));
        }
        return this.objPerTimeText;
    }

    protected int getProperty(String key, int defaultValue) {
        return DataGenerator.getProperty(this.properties, key, defaultValue);
    }

    public static int getProperty(Properties properties, String key, int defaultValue) {
        try {
            return new Integer(properties.getProperty(key));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected Label getReportProbLabel() {
        if (this.reportProbLabel == null) {
            this.reportProbLabel = new Label();
            this.reportProbLabel.setName("ReportProbLabel");
            this.reportProbLabel.setFont(new Font("sansserif", 0, 12));
            this.reportProbLabel.setText("report probability (0-1000):");
        }
        return this.reportProbLabel;
    }

    protected TextField getReportProbTextField() {
        if (this.reportProbText == null) {
            this.reportProbText = new TextField("1000");
            this.reportProbText.setName("ReportProbTextField");
            this.reportProbText.setFont(new Font("Dialog", 0, 11));
        }
        return this.reportProbText;
    }

    protected Scrollbar getTimeScrollbar() {
        if (this.timeScrollbar == null) {
            this.timeScrollbar = new Scrollbar(0, 0, 32, 0, this.viewWidth - 32);
            this.timeScrollbar.setName("TimeScrollbar");
        }
        return this.timeScrollbar;
    }

    protected int getValueOfTextField(TextField tf, int min, int max, boolean enabledAfter) {
        int intValue = new Integer(tf.getText());
        if (intValue < min) {
            intValue = min;
        } else if (intValue > max) {
            intValue = max;
        }
        tf.setText(String.valueOf(intValue));
        tf.setEditable(enabledAfter);
        tf.setEnabled(enabledAfter);
        return intValue;
    }

    public void init() {
        String p = this.getParameter("propertyfile");
        if (p != null) {
            propFilename = p;
        }
        try {
            URL url = this.computeURL(propFilename);
            InputStream in = url.openStream();
            this.properties.load(in);
        }
        catch (MalformedURLException mex) {
            System.err.println("DataGenerator.init: " + mex);
            System.exit(-1);
        }
        catch (IOException ioex) {
            System.err.println("DataGenerator.init: " + ioex);
            System.exit(-1);
        }
        this.edgeClasses = this.createEdgeClasses(this.properties);
        if (this.drawableObjects == null) {
            this.drawableObjects = new DrawableObjectsWithSearchTree(this.numOfLayers, new MemoryRTree());
        }
        super.init();
    }

    protected void initDrawablePresentation() {
        super.initDrawablePresentation();
        int num = this.edgeClasses.getNumber();
        int[] nodeMinScale = new int[num + 1];
        int i = 0;
        while (i < num + 1) {
            nodeMinScale[i] = 0;
            ++i;
        }
        int[] edgeMinScale = new int[num];
        int i2 = 0;
        while (i2 < num) {
            edgeMinScale[i2] = this.edgeClasses.getMinScale(i2);
            ++i2;
        }
        Color[] nodeColor = new Color[num + 1];
        int i3 = 0;
        while (i3 < num + 1) {
            nodeColor[i3] = Color.gray;
            ++i3;
        }
        Color[] edgeColor = new Color[num];
        int i4 = 0;
        while (i4 < num) {
            edgeColor[i4] = this.edgeClasses.getColor(i4);
            ++i4;
        }
        this.net.getEdges().setNumOfClasses(num);
        this.net.getEdges().initPresentation(edgeColor, Color.red);
        this.net.getEdges().setMinScaleArray(edgeMinScale);
        this.net.getNodes().setNumOfClasses(num + 1);
        this.net.getNodes().initPresentation(nodeColor, Color.red);
        this.net.getNodes().setMinScaleArray(nodeMinScale);
    }

    protected void interpretParameters() {
        MIN_MAXTIME = this.getProperty("MIN_MAXTIME", MIN_MAXTIME);
        MAX_MAXTIME = this.getProperty("MAX_MAXTIME", MAX_MAXTIME);
        MAX_OBJCLASSES = this.getProperty("MAX_OBJCLASSES", MAX_OBJCLASSES);
        MAX_OBJPERTIME = this.getProperty("MAX_OBJPERTIME", MAX_OBJPERTIME);
        MAX_OBJBEGIN = this.getProperty("MAX_OBJBEGIN", MAX_OBJBEGIN);
        MAX_EXTOBJCLASSES = this.getProperty("MAX_EXTOBJCLASSES", MAX_EXTOBJCLASSES);
        MAX_EXTOBJPERTIME = this.getProperty("MAX_EXTOBJPERTIME", MAX_EXTOBJPERTIME);
        MAX_EXTOBJBEGIN = this.getProperty("MAX_EXTOBJBEGIN", MAX_EXTOBJBEGIN);
        this.waitingPeriod = this.getProperty("waitingPeriod", this.waitingPeriod);
        this.baseScaleFactor = this.getProperty("baseScaleFactor", 1);
        this.minScale = this.getProperty("minScale", this.minScale);
        this.maxScale = this.getProperty("maxScale", this.maxScale);
        this.scale = this.getProperty("scale", this.maxScale);
        this.viewWidth = this.getProperty("viewWidth", this.viewWidth);
        this.viewHeight = this.getProperty("viewHeight", this.viewHeight);
        this.mapWidth = this.getProperty("mapWidth", this.scale * this.viewWidth);
        this.mapHeight = this.getProperty("mapHeight", this.scale * this.viewHeight);
        this.viewX = this.getProperty("viewX", this.viewX);
        this.viewY = this.getProperty("viewY", this.viewY);
        String p = this.properties.getProperty("color");
        if (p != null) {
            this.backgroundColor = ColorDefiner.getColor(p);
        }
        if ((p = this.properties.getProperty("mapColor")) != null) {
            this.mapColor = ColorDefiner.getColor(p);
        }
        if ((p = this.properties.getProperty("language")) != null && p.equals("D")) {
            this.language = 1;
        }
    }

    protected static String makeAbsolute(String fileName) {
        try {
            return new File(fileName).getAbsolutePath();
        }
        catch (Exception ex) {
            return fileName;
        }
    }

    protected void reportProgress(int time) {
        this.setTimeScrollbar(time);
    }

    protected void setState(int state) {
        super.setState(state);
        if (state != 4) {
            return;
        }
        Rectangle r = this.drawableObjects.getDataspace();
        this.movePos(r.x + r.width / 2, r.y + r.height, this.scale);
        this.repaint();
        if (this.getValueOfTextField(this.getMaxTimeTextField(), MIN_MAXTIME, MAX_MAXTIME, true) != 20) {
            this.compute();
        }
        this.getComputeButton().setEnabled(true);
    }

    protected void setTime(int actTime) {
        int c;
        int t;
        int c2;
        if (this.actTime != 0) {
            c2 = 0;
            while (c2 < this.objClasses.getNumber()) {
                DrawablePresentation.get("Point" + c2 + "-" + this.actTime).setVisibility(false);
                ++c2;
            }
            c2 = 0;
            while (c2 < this.extObjClasses.getNumber()) {
                DrawablePresentation.get("Rectangle" + c2 + "-" + this.actTime).setVisibility(false);
                ++c2;
            }
        } else {
            t = 0;
            while (t <= this.time.getMaxTime()) {
                c = 0;
                while (c < this.objClasses.getNumber()) {
                    DrawablePresentation.get("Point" + c + "-" + t).setVisibility(false);
                    ++c;
                }
                c = 0;
                while (c < this.extObjClasses.getNumber()) {
                    DrawablePresentation.get("Rectangle" + c + "-" + t).setVisibility(false);
                    ++c;
                }
                ++t;
            }
        }
        if (actTime != 0) {
            c2 = 0;
            while (c2 < this.objClasses.getNumber()) {
                DrawablePresentation.get("Point" + c2 + "-" + actTime).setVisibility(true);
                ++c2;
            }
            c2 = 0;
            while (c2 < this.extObjClasses.getNumber()) {
                DrawablePresentation.get("Rectangle" + c2 + "-" + actTime).setVisibility(true);
                ++c2;
            }
        } else {
            t = 0;
            while (t <= this.time.getMaxTime()) {
                c = 0;
                while (c < this.objClasses.getNumber()) {
                    DrawablePresentation.get("Point" + c + "-" + t).setVisibility(true);
                    ++c;
                }
                c = 0;
                while (c < this.extObjClasses.getNumber()) {
                    DrawablePresentation.get("Rectangle" + c + "-" + t).setVisibility(true);
                    ++c;
                }
                ++t;
            }
        }
        this.actTime = actTime;
        this.time.setCurrTime(actTime);
        this.getNameLabel().setText("Time: " + String.valueOf(actTime));
    }

    protected void setTimeScrollbar(int t) {
        int value = t * (this.timeScrollbar.getMaximum() - this.timeScrollbar.getVisibleAmount()) / this.time.getMaxTime();
        this.timeScrollbar.setValue(value);
        this.getNameLabel().setText("Time: " + String.valueOf(t));
    }

    public void showStatus(String text) {
        super.showStatus(text);
        if (frame != null) {
            frame.setTitle("Network Generator: " + text);
        }
    }

    protected void startLoadingThread() {
        URL[] url = new URL[3];
        String filename = this.properties.getProperty("urlne");
        if (filename != null) {
            url[1] = this.computeURL(String.valueOf(filename) + ".node");
            url[2] = this.computeURL(String.valueOf(filename) + ".edge");
        } else {
            filename = this.properties.getProperty("urlnez");
            if (filename == null) {
                System.err.println("no network file determined");
                System.exit(-3);
            }
            url[1] = this.computeURL(String.valueOf(filename) + ".node.zip");
            url[2] = this.computeURL(String.valueOf(filename) + ".edge.zip");
        }
        new LoadDrawables((ShowMap)this, url, 0).start();
    }

    public void setViewToPrefinedValue() {
        this.viewMapX = this.getProperty("posx", this.mapWidth / 2 / this.scale);
        this.viewMapY = this.getProperty("posy", this.mapHeight / 2 / this.scale);
    }
}

