/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawablePresentation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawableText
extends Drawable {
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLDITALIC = 3;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOPLINE = 0;
    public static final int CENTERLINE = 1;
    public static final int BASELINE = 2;
    public static final int MINSIZE = 5;
    public static final int MAXSIZE = 24;
    private static boolean unicode = false;
    private static Font[][] font = new Font[][]{new Font[20], new Font[20], new Font[20], new Font[20]};
    private static char[] ansiChar = new char[]{'\u0080', '\u0081', 'a', 'e', 'r', 'n', 'z', 'c', 'g', 'u', 'S', 'C', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', 'Z', 'U', 'r', 'n', 'z', 'c', 's', 'S', 'Z', 's', '\u009b', '\u009c', '\u009d', '\u009e', 'a', 'e', 's', 't', 'S', 'l', 'L', 'z', '\u00a7', 'e', 'i', 'I', 'Z', 'i', 'a', 'u', 'o', '\u00b0', 'e', 'A', 'O', '\u00f6', 'a', 'i', 'u', 'o', 'h', 's', 't', 'H', 'T', 'S', 'z'};
    private static char[] unicodeChar = new char[]{'\u0080', '\u0081', 'a', '\u0115', '\u0159', '\u0148', '\u017e', '\u010d', '\u011f', '\u01d4', '\u0160', '\u010c', '\u0152', '\u008d', '\u008e', '\u008f', '\u0090', '\u017d', '\u016c', '\u0155', '\u0144', '\u017a', '\u0107', '\u015b', '\u015a', '\u0179', '\u0161', '\u009b', '\u0153', '\u009d', '\u009e', '\u0105', '\u0119', '\u015f', '\u0163', '\u015e', '\u0142', '\u0141', '\u017c', '\u00a7', '\u0117', '\u0131', '\u0130', '\u017b', '\u012b', '\u0101', '\u016b', '\u014d', '\u00b0', '\u0113', '\u0100', '\u014c', '\u0151', '\u0103', '\u012d', '\u016d', '\u014f', 'h', 's', 't', 'H', 'T', 'S', 'z'};
    private String origText = null;
    private String ansiText = "";
    private String unicodeText = "";
    private int x = 0;
    private int y = 0;
    private int len = 0;
    private int horAlignment = 0;
    private int vertAlignment = 2;

    protected DrawableText() {
        this.layer = (byte)3;
    }

    public DrawableText(int px, int py, String s) {
        this();
        this.x = px;
        this.y = py;
        this.len = s.length();
        this.origText = s;
        if (!s.equals("=")) {
            this.ansiText = DrawableText.toAnsi(s);
            this.unicodeText = DrawableText.toUnicode(s);
        } else {
            this.ansiText = s;
            this.unicodeText = s;
        }
        this.mbr = new Rectangle(this.x - this.len, this.y - 1, 2 * this.len, 3);
        this.pres = DrawablePresentation.get("default");
    }

    public DrawableText(int x, int y, String s, String presName, int h, int v) {
        this(x, y, s);
        this.pres = DrawablePresentation.get(presName);
        this.horAlignment = h;
        this.vertAlignment = v;
    }

    public DrawableText(int x, int y, String s, String presName, int h, int v, int pMinScale, int pMaxScale) {
        this(x, y, s, presName, h, v);
        this.minScale = pMinScale;
        this.maxScale = pMaxScale;
    }

    /*
     * Unable to fully structure code
     */
    public static String correctString(String input) {
        if (input != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            input = input.replace('\u0160', '\u008a');
lbl4:
            // 2 sources

            ** while (input.indexOf((int)352) >= 0)
        }
lbl5:
        // 2 sources

        while (input.indexOf(353) >= 0) {
            input = input.replace('\u0161', '\u009a');
        }
        while (input.indexOf(376) >= 0) {
            input = input.replace('\u0178', '\u009f');
        }
        while (input.indexOf(402) >= 0) {
            input = input.replace('\u0192', '\u0083');
        }
        while (input.indexOf(710) >= 0) {
            input = input.replace('\u02c6', '\u0088');
        }
        while (input.indexOf(732) >= 0) {
            input = input.replace('\u02dc', '\u0098');
        }
        while (input.indexOf(8211) >= 0) {
            input = input.replace('\u2013', '\u0096');
        }
        while (input.indexOf(8212) >= 0) {
            input = input.replace('\u2014', '\u0097');
        }
        while (input.indexOf(8216) >= 0) {
            input = input.replace('\u2018', '\u0091');
        }
        while (input.indexOf(8217) >= 0) {
            input = input.replace('\u2019', '\u0092');
        }
        while (input.indexOf(8218) >= 0) {
            input = input.replace('\u201a', '\u0082');
        }
        while (input.indexOf(8221) >= 0) {
            input = input.replace('\u201d', '\u0094');
        }
        while (input.indexOf(8222) >= 0) {
            input = input.replace('\u201e', '\u0084');
        }
        while (input.indexOf(8224) >= 0) {
            input = input.replace('\u2020', '\u0086');
        }
        while (input.indexOf(8225) >= 0) {
            input = input.replace('\u2021', '\u0087');
        }
        while (input.indexOf(8226) >= 0) {
            input = input.replace('\u2022', '\u0095');
        }
        while (input.indexOf(8230) >= 0) {
            input = input.replace('\u2026', '\u0085');
        }
        while (input.indexOf(8240) >= 0) {
            input = input.replace('\u2030', '\u0089');
        }
        while (input.indexOf(8249) >= 0) {
            input = input.replace('\u2039', '\u008b');
        }
        return input;
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        int py;
        int px;
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        if (ap.size < 5) {
            ap.size = 5;
        }
        if (ap.size > 24) {
            ap.size = 24;
        }
        if (this.selected) {
            if (ap.selectionColor == null) {
                return;
            }
            g.setColor(ap.selectionColor);
        } else {
            if (ap.color == null) {
                return;
            }
            g.setColor(ap.color);
        }
        Font f = DrawableText.setFont(g, ap.type, ap.size);
        FontMetrics fm = g.getFontMetrics(f);
        int width = fm.stringWidth(this.ansiText);
        int height = fm.getLeading() + fm.getAscent();
        switch (this.horAlignment) {
            case 2: {
                px = this.x / scale - width;
                if (this.vertAlignment != 1) break;
                px -= ap.offset;
                break;
            }
            case 1: {
                px = this.x / scale - width / 2;
                break;
            }
            default: {
                px = this.x / scale;
                if (this.vertAlignment != 1) break;
                px += ap.offset;
            }
        }
        switch (this.vertAlignment) {
            case 0: {
                py = this.y / scale + height - ap.size / 2 + ap.offset;
                break;
            }
            case 1: {
                py = this.y / scale + height / 2 - 1;
                break;
            }
            default: {
                py = this.y / scale + ap.size / 5 - ap.offset;
            }
        }
        if (unicode) {
            g.drawString(this.unicodeText, px, py);
        } else {
            g.drawString(this.ansiText, px, py);
        }
    }

    public String getOrigString() {
        return this.origText;
    }

    public String getString() {
        if (unicode) {
            return this.unicodeText;
        }
        return this.ansiText;
    }

    public boolean interacts(int px, int py, int scale) {
        int actMode = this.container == null ? 0 : this.container.getMode();
        int value = this.obj == null ? Integer.MIN_VALUE : this.obj.getPresValue();
        DrawablePresentation ap = this.pres.get(scale, actMode, value);
        return px >= this.x - ap.size * this.len / 3 * scale && px <= this.x + ap.size * this.len / 3 * scale && py >= this.y - ap.size / 2 * scale && py <= this.y + ap.size / 2 * scale;
    }

    public static boolean isUnicodeUsed() {
        return unicode;
    }

    public EntryReadable read(EntryInput r) {
        int type = r.readInt();
        this.x = r.readInt();
        this.y = r.readInt();
        this.origText = DrawableText.correctString(r.readString());
        this.mbr = new Rectangle(this.x - 1, this.y - 1, 3, 3);
        this.len = this.origText.length();
        this.ansiText = DrawableText.toAnsi(this.origText);
        this.unicodeText = DrawableText.toUnicode(this.origText);
        if (type == 0) {
            this.pres = DrawablePresentation.get("default");
            return this;
        }
        this.pres = DrawablePresentation.get(r.readString());
        this.horAlignment = r.readInt();
        this.vertAlignment = r.readInt();
        if (type == 1) {
            return this;
        }
        this.minScale = r.readInt();
        this.maxScale = r.readInt();
        return this;
    }

    public static Font setFont(Graphics g, int style, int size) {
        if (font[style][size - 5] == null) {
            switch (style) {
                case 0: {
                    DrawableText.font[style][size - 5] = new Font("SansSerif", 0, size + 2);
                    break;
                }
                case 1: {
                    DrawableText.font[style][size - 5] = new Font("SansSerif", 1, size + 2);
                    break;
                }
                case 2: {
                    DrawableText.font[style][size - 5] = new Font("SansSerif", 2, size + 2);
                    break;
                }
                case 3: {
                    DrawableText.font[style][size - 5] = new Font("SansSerif", 3, size + 2);
                }
            }
        }
        g.setFont(font[style][size - 5]);
        return font[style][size - 5];
    }

    public void setText(String text) {
        this.len = text.length();
        this.origText = text;
        this.ansiText = DrawableText.toAnsi(text);
        this.unicodeText = DrawableText.toUnicode(text);
        this.mbr.setBounds(this.x - this.len, this.y - 1, 2 * this.len, 3);
    }

    public static void setUnicode(boolean u) {
        unicode = u;
    }

    private static String toAnsi(String s) {
        StringBuffer r = new StringBuffer(s);
        int i = 0;
        while (i < r.length()) {
            if (r.charAt(i) >= '\u0080') {
                if (r.charAt(i) < '\u00c0') {
                    r.setCharAt(i, ansiChar[r.charAt(i) - 128]);
                } else {
                    if (r.charAt(i) == '\u00d7') {
                        r.setCharAt(i, 'Z');
                    }
                    if (r.charAt(i) == '\u00de') {
                        r.setCharAt(i, 'I');
                    }
                    if (r.charAt(i) == '\u00f7') {
                        r.setCharAt(i, 'z');
                    }
                    if (r.charAt(i) == '\u00fe') {
                        r.setCharAt(i, 'Z');
                    }
                    if (r.charAt(i) == '\u00ff') {
                        r.setCharAt(i, 'd');
                    }
                    if (r.charAt(i) >= '\u0100') {
                        System.out.println("s: " + s + " i: " + i + " r.charAt(i): " + r.charAt(i));
                        r.setCharAt(i, '*');
                    }
                }
            }
            ++i;
        }
        return r.toString();
    }

    protected static String toOutputString(String in) {
        if (unicode) {
            return DrawableText.toUnicode(in);
        }
        return DrawableText.toAnsi(in);
    }

    private static String toUnicode(String s) {
        StringBuffer r = new StringBuffer(s);
        int i = 0;
        while (i < r.length()) {
            if (r.charAt(i) >= '\u0080') {
                if (r.charAt(i) < '\u00c0') {
                    r.setCharAt(i, unicodeChar[r.charAt(i) - 128]);
                } else {
                    if (r.charAt(i) == '\u00d7') {
                        r.setCharAt(i, 'Z');
                    }
                    if (r.charAt(i) == '\u00de') {
                        r.setCharAt(i, '\u012a');
                    }
                    if (r.charAt(i) == '\u00f7') {
                        r.setCharAt(i, 'z');
                    }
                    if (r.charAt(i) == '\u00fe') {
                        r.setCharAt(i, 'Z');
                    }
                    if (r.charAt(i) == '\u00ff') {
                        r.setCharAt(i, 'd');
                    }
                    if (r.charAt(i) >= '\u0100') {
                        System.out.println("s: " + s + " i: " + i + " r.charAt(i): " + r.charAt(i));
                        r.setCharAt(i, '*');
                    }
                }
            }
            ++i;
        }
        return r.toString();
    }

    protected void writeProtected(EntryWriter out, int type) {
        out.print("T\t" + type + '\t' + this.x + '\t' + this.y + '\t');
        if (this.obj != null && this.obj.getId() > 0L) {
            out.print('=');
        } else {
            out.print(this.origText);
        }
        if (type == 0) {
            return;
        }
        out.print(String.valueOf('\t') + this.pres.getName() + '\t' + this.horAlignment + '\t' + this.vertAlignment);
        if (type == 1) {
            return;
        }
        out.print("\t" + this.minScale + '\t' + this.maxScale);
    }
}

