/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.DrawablePresentation;
import drawables.DrawableText;
import drawables.FilledDrawable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawableSymbol
extends FilledDrawable {
    public static final int SQUARE = 0;
    public static final int CIRCLE = 1;
    public static final int SQUAREDOT = 2;
    public static final int CIRCLEDOT = 3;
    public static final int RING = 4;
    public static final int TRIANGLE = 5;
    public static final int UPDOWNARROW = 6;
    protected int x = 0;
    protected int y = 0;
    protected static DrawableText bufferedText = null;

    protected DrawableSymbol() {
        this.layer = (byte)2;
    }

    public DrawableSymbol(int px, int py, String presName) {
        this();
        this.x = px;
        this.y = py;
        this.mbr = new Rectangle(this.x - 1, this.y - 1, 3, 3);
        this.pres = DrawablePresentation.get(presName);
    }

    public DrawableSymbol(int x, int y, String presName, int pMinScale, int pMaxScale) {
        this(x, y, presName);
        this.minScale = pMinScale;
        this.maxScale = pMaxScale;
    }

    protected void drawProtected(Graphics g, int scale, int mode, int pvalue) {
        DrawablePresentation ap = this.pres.get(scale, mode, pvalue);
        int size = ap.size;
        try {
            size *= this.obj.getDataValue(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selected) {
            g.setColor(ap.selectionFillColor);
        } else {
            g.setColor(ap.fillColor);
        }
        int off = 0;
        if (size % 2 == 1) {
            off = 1;
        }
        Polygon pol = null;
        switch (ap.type) {
            case 0: 
            case 2: {
                g.fillRect(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
                break;
            }
            case 1: 
            case 3: {
                g.fillOval(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
                break;
            }
            case 4: {
                g.fillOval(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
                g.setColor(Color.white);
                g.fillOval(this.x / scale - size * 3 / 10, this.y / scale - size * 3 / 10, (size + off) * 3 / 5, (size + off) * 3 / 5);
                break;
            }
            case 5: {
                int[] pgxT = new int[]{this.x / scale - size / 2, this.x / scale + size / 2, this.x / scale};
                int[] pgyT = new int[]{this.y / scale + size / 2, this.y / scale + size / 2, this.y / scale - size / 2};
                pol = new Polygon(pgxT, pgyT, 3);
                g.fillPolygon(pol);
                break;
            }
            case 6: {
                if (size == 0) {
                    g.fillRect(this.x / scale - 3, this.y / scale, 7, 4);
                    break;
                }
                g.fillRect(this.x / scale - 3, this.y / scale - (Math.abs(size) + 1) / 2, 6, Math.abs(size) + 1);
            }
        }
        if (this.selected) {
            g.setColor(ap.selectionColor);
        } else {
            g.setColor(ap.color);
        }
        switch (ap.type) {
            case 2: {
                g.fillRect(this.x / scale - size / 6, this.y / scale - size / 6, (size + off) / 3, (size + off) / 3);
            }
            case 0: {
                g.drawRect(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
                break;
            }
            case 4: {
                g.drawOval(this.x / scale - size * 3 / 10, this.y / scale - size * 3 / 10, (size + off) * 3 / 5, (size + off) * 3 / 5);
                g.drawOval(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
                break;
            }
            case 3: {
                g.drawOval(this.x / scale - size / 6, this.y / scale - size / 6, (size + off) / 3, (size + off) / 3);
            }
            case 1: {
                g.drawOval(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
                break;
            }
            case 5: {
                g.drawPolygon(pol);
                break;
            }
            case 6: {
                if (size > 0) {
                    g.drawRect(this.x / scale - 3, this.y / scale - (size + 1) / 2, 6, size + 1);
                    g.drawLine(this.x / scale - 5, this.y / scale + (size + 2) / 2, this.x / scale + 5, this.y / scale + (size + 2) / 2);
                    break;
                }
                if (size < 0) {
                    g.drawRect(this.x / scale - 3, this.y / scale + (size - 1) / 2, 6, -size + 1);
                    g.drawLine(this.x / scale - 5, this.y / scale + (size - 1) / 2, this.x / scale + 5, this.y / scale + (size - 1) / 2);
                    break;
                }
                g.drawRect(this.x / scale - 3, this.y / scale, 6, 4);
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean interacts(int px, int py, int scale) {
        int actMode = this.container == null ? 0 : this.container.getMode();
        int pvalue = this.obj == null ? Integer.MIN_VALUE : this.obj.getPresValue();
        DrawablePresentation ap = this.pres.get(scale, actMode, pvalue);
        int size = Math.abs(ap.size * pvalue) / 10;
        if (size < 4) {
            size = 4;
        }
        return px >= this.x - size / 2 * scale && px <= this.x + size / 2 * scale && py >= this.y - size / 2 * scale - 1 && py <= this.y + size / 2 * scale;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public EntryReadable read(EntryInput r) {
        int type = r.readInt();
        this.x = r.readInt();
        this.y = r.readInt();
        this.pres = DrawablePresentation.get(r.readString());
        this.mbr = new Rectangle(this.x - 1, this.y - 1, 3, 3);
        if (type == 0) {
            return this;
        }
        this.minScale = r.readInt();
        this.maxScale = r.readInt();
        if (type == 1) {
            return this;
        }
        if (type == 4) {
            r.readInt();
            return this;
        }
        String txt = DrawableText.correctString(r.readString());
        String txtPres = r.readString();
        int h = r.readInt();
        int v = r.readInt();
        if (type == 2) {
            bufferedText = new DrawableText(this.x, this.y, txt, txtPres, h, v, this.minScale, this.maxScale);
            return this;
        }
        int txtMinScale = r.readInt();
        int txtMaxScale = r.readInt();
        bufferedText = new DrawableText(this.x, this.y, txt, txtPres, h, v, txtMinScale, txtMaxScale);
        return this;
    }

    public void writeGML(EntryWriter out) {
        String name = "pnt_";
        if (this.obj != null) {
            name = String.valueOf(name) + this.obj.getName();
        }
        out.println("<Point name=\"" + name + "\" srsName=\"br\">");
        out.print(" <CList>" + this.x + "," + this.y + "</CList>");
        out.println("</Point>");
    }

    protected void writeProtected(EntryWriter out, int type) {
        out.print("S\t" + type + '\t');
        out.print(this.x);
        out.print('\t');
        out.print(this.y);
        out.print('\t');
        out.print(this.pres.getName());
        if (type == 0) {
            return;
        }
        out.print("\t" + this.minScale + '\t' + this.maxScale);
    }
}

