/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import java.awt.Graphics;
import spatial.LayerSpatialSearchTreeObject;
import spatial.MBR;
import spatial.MovingSpatialSearchTreeObject;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeObject;
import spatial.VisualizedSpatialSearchTreeObject;

public class DrawableSpatialSearchTreeObject
implements VisualizedSpatialSearchTreeObject,
MovingSpatialSearchTreeObject,
LayerSpatialSearchTreeObject {
    protected Drawable prim;
    protected MBR mbr;

    public DrawableSpatialSearchTreeObject(Drawable prim) {
        this.prim = prim;
        this.mbr = new MBR(this.prim.getMBR());
    }

    public double computeDistanceTo(int[] point) {
        return this.prim.computeDistanceTo(point[0], point[1]);
    }

    public boolean contains(MBR rect) {
        return this.prim.contains(rect.extractRectangle(0, 1));
    }

    public void draw(Graphics g, int scale) {
        this.prim.draw(g, scale);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DrawableSpatialSearchTreeObject)) {
            return false;
        }
        return this.prim.equals(((DrawableSpatialSearchTreeObject)obj).prim);
    }

    public Drawable getDrawable() {
        return this.prim;
    }

    public long getId() {
        return this.prim.getId();
    }

    public int getLayer() {
        return this.prim.getLayer();
    }

    public MBR getMBR() {
        return this.mbr;
    }

    public int getNumOfDimensions() {
        return 2;
    }

    public Object getType() {
        return this.prim.getType();
    }

    public boolean interacts(int x, int y, int scale) {
        return this.prim.interacts(x, y, scale);
    }

    public boolean intersects(Object obj) {
        return this.prim.intersects(obj);
    }

    public boolean intersects(MBR r) {
        return this.prim.intersects(r.extractRectangle(0, 1));
    }

    public boolean isContainedBy(MBR rect) {
        return this.prim.isContainedBy(rect.extractRectangle(0, 1));
    }

    public boolean isContainedBy(SpatialSearchTreeEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.isContainedBy(entry.getMBR());
    }

    public boolean isOfSameType(SpatialSearchTreeObject obj) {
        try {
            DrawableSpatialSearchTreeObject o = (DrawableSpatialSearchTreeObject)obj;
            return this.getType() == o.getType();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isVisible(int scale) {
        return this.prim.isVisible(scale);
    }

    public void setMBR(MBR newMBR) {
        this.mbr = newMBR;
        this.prim.setMBR(newMBR.extractRectangle(0, 1));
    }
}

