/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import java.awt.Color;

public class DrawablePresentation {
    private static DrawablePresentation first = null;
    private String name = "default";
    protected int minScale = Integer.MAX_VALUE;
    protected int maxScale = 0;
    public static final int ALLMODES = -1;
    protected int mode = -1;
    public static final int NOVALUE = Integer.MIN_VALUE;
    protected int value = Integer.MIN_VALUE;
    protected boolean selectable = false;
    protected boolean visible = true;
    protected Color color = Color.black;
    protected Color fillColor = Color.white;
    protected Color selectionColor = Color.red;
    protected Color selectionFillColor = Color.red;
    protected int type = 0;
    protected int size = 1;
    protected int offset = 0;
    private DrawablePresentation nextOfSame = null;
    private DrawablePresentation nextOfOther = null;

    private DrawablePresentation get(int scale) {
        DrawablePresentation actObj = this;
        while (actObj.nextOfSame != null) {
            if (scale <= actObj.minScale && scale > actObj.maxScale) {
                return actObj;
            }
            actObj = actObj.nextOfSame;
        }
        return actObj;
    }

    public DrawablePresentation get(int scale, int mode, int value) {
        DrawablePresentation actObj = this;
        while (actObj != null) {
            if (!(scale > actObj.minScale || scale < actObj.maxScale || mode != -1 && actObj.mode != -1 && actObj.mode != mode || value != Integer.MIN_VALUE && actObj.value != Integer.MIN_VALUE && actObj.value != value)) {
                return actObj;
            }
            actObj = actObj.nextOfSame;
        }
        return first;
    }

    public static DrawablePresentation get(String name) {
        DrawablePresentation actObj = first;
        while (actObj != null) {
            if (actObj.name.compareTo(name) == 0) {
                return actObj;
            }
            actObj = actObj.nextOfOther;
        }
        return first;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public String getName() {
        return this.name;
    }

    public DrawablePresentation getNext() {
        return this.nextOfSame;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean getSelectability() {
        return this.selectable;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Color getSelectionFillColor() {
        return this.selectionFillColor;
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public boolean getVisibility() {
        return this.visible;
    }

    public static void init() {
        if (first != null) {
            DrawablePresentation.first.nextOfSame = null;
            DrawablePresentation.first.nextOfOther = null;
        }
    }

    public static DrawablePresentation newDrawablePresentation(String name) {
        if (first == null) {
            first = new DrawablePresentation().setVisibility(false);
        }
        DrawablePresentation newObj = new DrawablePresentation();
        newObj.name = name;
        DrawablePresentation father = DrawablePresentation.get(name);
        if (father.name.equals(name)) {
            father = father.get(-1);
            newObj.nextOfSame = father.nextOfSame;
            father.nextOfSame = newObj;
        } else {
            newObj.nextOfOther = father.nextOfOther;
            father.nextOfOther = newObj;
        }
        return newObj;
    }

    public static DrawablePresentation newDrawablePresentation(String name, int mode, int value, boolean selectable, Color color, Color selectionColor) {
        return DrawablePresentation.newDrawablePresentation(name, mode, value, selectable, color, color, selectionColor, selectionColor);
    }

    public static DrawablePresentation newDrawablePresentation(String name, int mode, int value, boolean selectable, Color color, Color selectionColor, int type, int size) {
        return DrawablePresentation.newDrawablePresentation(name, mode, value, selectable, color, color, selectionColor, selectionColor, type, size);
    }

    public static DrawablePresentation newDrawablePresentation(String name, int mode, int value, boolean selectable, Color color, Color selectionColor, int type, int size, int offset, int minScale, int maxScale) {
        return DrawablePresentation.newDrawablePresentation(name, mode, value, selectable, color, color, selectionColor, selectionColor, type, size, offset, minScale, maxScale);
    }

    public static DrawablePresentation newDrawablePresentation(String name, int mode, int value, boolean selectable, Color color, Color fillColor, Color selectionColor, Color selectionFillColor) {
        DrawablePresentation newObj = DrawablePresentation.newDrawablePresentation(name);
        newObj.mode = mode;
        newObj.value = value;
        newObj.selectable = selectable;
        newObj.color = color;
        newObj.fillColor = fillColor;
        newObj.selectionColor = selectionColor;
        newObj.selectionFillColor = selectionFillColor;
        return newObj;
    }

    public static DrawablePresentation newDrawablePresentation(String name, int mode, int value, boolean selectable, Color color, Color fillColor, Color selectionColor, Color selectionFillColor, int type, int size) {
        DrawablePresentation newObj = DrawablePresentation.newDrawablePresentation(name, mode, value, selectable, color, fillColor, selectionColor, selectionFillColor);
        newObj.type = type;
        newObj.size = size;
        return newObj;
    }

    public static DrawablePresentation newDrawablePresentation(String name, int mode, int value, boolean selectable, Color color, Color fillColor, Color selectionColor, Color selectionFillColor, int type, int size, int offset, int minScale, int maxScale) {
        DrawablePresentation newObj = DrawablePresentation.newDrawablePresentation(name, mode, value, selectable, color, fillColor, selectionColor, selectionFillColor, type, size);
        newObj.offset = offset;
        newObj.minScale = minScale;
        newObj.maxScale = maxScale;
        return newObj;
    }

    public static DrawablePresentation newDrawablePresentation(String name, boolean selectable, Color color, Color selectionColor) {
        return DrawablePresentation.newDrawablePresentation(name, selectable, color, color, selectionColor, selectionColor);
    }

    public static DrawablePresentation newDrawablePresentation(String name, boolean selectable, Color color, Color selectionColor, int type, int size) {
        return DrawablePresentation.newDrawablePresentation(name, selectable, color, color, selectionColor, selectionColor, type, size);
    }

    public static DrawablePresentation newDrawablePresentation(String name, boolean selectable, Color color, Color selectionColor, int type, int size, int offset, int minScale, int maxScale) {
        return DrawablePresentation.newDrawablePresentation(name, selectable, color, color, selectionColor, selectionColor, type, size, offset, minScale, maxScale);
    }

    public static DrawablePresentation newDrawablePresentation(String name, boolean selectable, Color color, Color fillColor, Color selectionColor, Color selectionFillColor) {
        return DrawablePresentation.newDrawablePresentation(name, -1, Integer.MIN_VALUE, selectable, color, fillColor, selectionColor, selectionFillColor);
    }

    public static DrawablePresentation newDrawablePresentation(String name, boolean selectable, Color color, Color fillColor, Color selectionColor, Color selectionFillColor, int type, int size) {
        return DrawablePresentation.newDrawablePresentation(name, -1, Integer.MIN_VALUE, selectable, color, fillColor, selectionColor, selectionFillColor, type, size);
    }

    public static DrawablePresentation newDrawablePresentation(String name, boolean selectable, Color color, Color fillColor, Color selectionColor, Color selectionFillColor, int type, int size, int offset, int minScale, int maxScale) {
        return DrawablePresentation.newDrawablePresentation(name, -1, Integer.MIN_VALUE, selectable, color, fillColor, selectionColor, selectionFillColor, type, size, offset, minScale, maxScale);
    }

    public DrawablePresentation setColor(Color pColor) {
        this.color = pColor;
        return this;
    }

    public DrawablePresentation setFillColor(Color pColor) {
        this.fillColor = pColor;
        return this;
    }

    public DrawablePresentation setOffset(int pOffset) {
        this.offset = pOffset;
        return this;
    }

    public DrawablePresentation setSelectability(boolean s) {
        this.selectable = s;
        return this;
    }

    public DrawablePresentation setSelectionColor(Color pColor) {
        this.selectionColor = pColor;
        return this;
    }

    public DrawablePresentation setSelectionFillColor(Color pColor) {
        this.selectionFillColor = pColor;
        return this;
    }

    public DrawablePresentation setSize(int pSize) {
        this.size = pSize;
        return this;
    }

    public DrawablePresentation setType(int pType) {
        this.type = pType;
        return this;
    }

    public DrawablePresentation setVisibility(boolean on) {
        this.visible = on;
        return this;
    }
}

