/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawablePresentation;
import drawables.FilledDrawable;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawablePolygon
extends FilledDrawable {
    protected int[] xCoords = null;
    protected int[] yCoords = null;
    protected int num = 0;
    protected int[] outX = null;
    protected int[] outY = null;

    public DrawablePolygon() {
        this.pres = DrawablePresentation.get("default");
    }

    public DrawablePolygon(int npoints, int[] xpoints, int[] ypoints) {
        this();
        this.xCoords = xpoints;
        this.yCoords = ypoints;
        this.num = npoints;
        if (this.num > 0) {
            this.outX = new int[this.num];
            this.outY = new int[this.num];
            this.mbr = DrawablePolygon.computeMBR(this.num, this.xCoords, this.yCoords);
        }
    }

    public DrawablePolygon(int npoints, int[] xpoints, int[] ypoints, boolean filled, String presName) {
        this(npoints, xpoints, ypoints);
        this.filled = filled;
        if (filled) {
            this.layer = 0;
        }
        this.pres = DrawablePresentation.get(presName);
    }

    public DrawablePolygon(int npoints, int[] xpoints, int[] ypoints, boolean filled, String presName, int minScale, int maxScale) {
        this(npoints, xpoints, ypoints, filled, presName);
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    public static Rectangle computeMBR(int num, int[] xCoords, int[] yCoords) {
        int ymin;
        int xmin;
        if (num <= 0) {
            return null;
        }
        int xmax = xmin = xCoords[0];
        int ymax = ymin = yCoords[0];
        int i = 1;
        while (i < num) {
            if (xCoords[i] < xmin) {
                xmin = xCoords[i];
            }
            if (xCoords[i] > xmax) {
                xmax = xCoords[i];
            }
            if (yCoords[i] < ymin) {
                ymin = yCoords[i];
            }
            if (yCoords[i] > ymax) {
                ymax = yCoords[i];
            }
            ++i;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        if (this.num == 0) {
            return;
        }
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        int i = 0;
        while (i < this.num) {
            this.outX[i] = (this.xCoords[i] + scale - 1) / scale;
            this.outY[i] = (this.yCoords[i] + scale - 1) / scale;
            ++i;
        }
        if (this.filled && this.selected && ap.selectionFillColor != null) {
            g.setColor(ap.selectionFillColor);
            g.fillPolygon(this.outX, this.outY, this.num);
        }
        if (this.filled && !this.selected && ap.fillColor != null) {
            g.setColor(ap.fillColor);
            g.fillPolygon(this.outX, this.outY, this.num);
        }
        if (this.selected && ap.selectionColor != null) {
            g.setColor(ap.selectionColor);
            g.drawPolygon(this.outX, this.outY, this.num);
        } else if (ap.color != null) {
            g.setColor(ap.color);
            g.drawPolygon(this.outX, this.outY, this.num);
        }
    }

    public int getNumberOfPoints() {
        return this.num;
    }

    public EntryReadable read(DataInputStream r) throws IOException {
        byte type = r.readByte();
        this.num = r.readShort();
        this.xCoords = new int[this.num];
        this.yCoords = new int[this.num];
        this.outX = new int[this.num];
        this.outY = new int[this.num];
        int i = 0;
        while (i < this.num) {
            if (i > 0) {
                this.xCoords[i] = Drawable.readCoord(r) + this.xCoords[i - 1];
                this.yCoords[i] = Drawable.readCoord(r) + this.yCoords[i - 1];
            } else {
                this.xCoords[i] = Drawable.readCoord(r);
                this.yCoords[i] = Drawable.readCoord(r);
            }
            ++i;
        }
        this.mbr = DrawablePolygon.computeMBR(this.num, this.xCoords, this.yCoords);
        if (type > 0) {
            if (this.getClass().getName().endsWith("gon")) {
                this.filled = r.readBoolean();
                if (this.filled) {
                    this.layer = 0;
                }
            }
            String presName = r.readUTF();
            this.pres = DrawablePresentation.get(presName);
            if (type > 1) {
                this.minScale = r.readShort();
                this.maxScale = r.readShort();
                if (type > 2) {
                    this.layer = r.readByte();
                }
            }
        }
        return this;
    }

    public EntryReadable read(EntryInput r) {
        boolean relative;
        int type = r.readInt();
        this.num = r.readInt();
        boolean bl = relative = this.num < 0;
        if (relative) {
            this.num = -this.num;
        }
        this.xCoords = new int[this.num];
        this.yCoords = new int[this.num];
        this.outX = new int[this.num];
        this.outY = new int[this.num];
        int i = 0;
        while (i < this.num) {
            if (relative && i > 0) {
                this.xCoords[i] = Drawable.readCoord(r) + this.xCoords[i - 1];
                this.yCoords[i] = Drawable.readCoord(r) + this.yCoords[i - 1];
            } else if (relative) {
                this.xCoords[i] = Drawable.readCoord(r);
                this.yCoords[i] = Drawable.readCoord(r);
            } else {
                this.xCoords[i] = r.readInt();
                this.yCoords[i] = r.readInt();
            }
            ++i;
        }
        this.mbr = DrawablePolygon.computeMBR(this.num, this.xCoords, this.yCoords);
        if (type > 0) {
            if (this.getClass().getName().endsWith("gon")) {
                int f = r.readInt();
                boolean bl2 = this.filled = f != 0;
                if (this.filled) {
                    this.layer = 0;
                }
            }
            String presName = r.readString();
            this.pres = DrawablePresentation.get(presName);
            if (type > 1) {
                this.minScale = r.readInt();
                this.maxScale = r.readInt();
                if (type > 2) {
                    this.layer = (byte)r.readInt();
                }
            }
        }
        return this;
    }

    public void write(DataOutputStream out, int type) {
        try {
            boolean isPolygon;
            boolean bl = isPolygon = !this.getClass().getName().endsWith("line");
            if (isPolygon) {
                out.writeByte(80);
            } else {
                out.writeByte(76);
            }
            out.writeByte(type);
            out.writeShort((short)this.num);
            Drawable.writeCoord(out, this.xCoords[0]);
            Drawable.writeCoord(out, this.yCoords[0]);
            int i = 1;
            while (i < this.num) {
                Drawable.writeCoord(out, this.xCoords[i] - this.xCoords[i - 1]);
                Drawable.writeCoord(out, this.yCoords[i] - this.yCoords[i - 1]);
                ++i;
            }
            if (type > 0) {
                if (isPolygon) {
                    out.writeBoolean(this.filled);
                }
                out.writeUTF(this.pres.getName());
                if (type > 1) {
                    out.writeShort((short)this.minScale);
                    out.writeShort((short)this.maxScale);
                    if (type > 2) {
                        out.writeByte(this.layer);
                    }
                }
            }
            out.writeLong(this.obj == null ? 0L : Math.abs(this.obj.getId()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeGML(EntryWriter out) {
        String name = "gon_";
        if (this.obj != null) {
            name = String.valueOf(name) + this.obj.getName();
        }
        out.println("<Polygon name=\"p" + name + "\" srsName=\"br\">");
        out.println(" <LineString name=\"l" + name + "\" srsName=\"br\">");
        out.print("  <CList>");
        int i = 0;
        while (i < this.num) {
            out.print(String.valueOf(this.xCoords[i]) + "," + this.yCoords[i] + " ");
            ++i;
        }
        out.println(String.valueOf(this.xCoords[0]) + "," + this.yCoords[0] + "</CList>");
        out.println(" </LineString>");
        out.println("</Polygon>");
    }

    protected void writeProtected(EntryWriter out, int type) {
        boolean isPolygon;
        boolean bl = isPolygon = !this.getClass().getName().endsWith("line");
        if (isPolygon) {
            out.print('P');
        } else {
            out.print('L');
        }
        out.print("\t" + type + '\t');
        out.print(-this.num);
        out.print('\t');
        Drawable.writeCoord(out, this.xCoords[0]);
        Drawable.writeCoord(out, this.yCoords[0]);
        int i = 1;
        while (i < this.num) {
            Drawable.writeCoord(out, this.xCoords[i] - this.xCoords[i - 1]);
            Drawable.writeCoord(out, this.yCoords[i] - this.yCoords[i - 1]);
            ++i;
        }
        if (type == 0) {
            return;
        }
        if (isPolygon) {
            if (this.filled) {
                out.print("1\t");
            } else {
                out.print("0");
            }
        }
        out.print(this.pres.getName());
        if (type == 1) {
            return;
        }
        out.print("\t" + this.minScale + '\t' + this.maxScale);
        if (type == 2) {
            return;
        }
        out.print("\t" + this.layer);
    }
}

