/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawableObject;
import drawables.DrawableObjects;
import drawables.DrawableSpatialSearchTreeObject;
import java.awt.Graphics;
import java.awt.Rectangle;
import spatial.LayerAllQuery;
import spatial.LayerScaleWindowQuery;
import spatial.MBR;
import spatial.MemoryRTree;
import spatial.NearestNeighborQuery;
import spatial.RegionQuery;
import spatial.SelectQuery;
import spatial.SpatialSearchTree;
import spatial.SpatialSearchTreeObject;

public class DrawableObjectsWithSearchTree
extends DrawableObjects {
    private SpatialSearchTree tree = null;
    private RegionQuery pQuery = null;
    private RegionQuery wQuery = null;
    private NearestNeighborQuery nnQuery = null;

    public DrawableObjectsWithSearchTree(int numOfLayers, SpatialSearchTree tree) {
        super(numOfLayers);
        this.tree = tree;
        if (tree != null) {
            this.nnQuery = new NearestNeighborQuery();
        }
    }

    public void addDrawable(Drawable prim) {
        super.addDrawable(prim);
        if (this.tree != null) {
            this.tree.insert(new DrawableSpatialSearchTreeObject(prim));
        }
    }

    public void drawAllObjectsOfLayer(int l, Graphics g, Rectangle r, int scale) {
        if (l >= this.numOfLayers) {
            return;
        }
        if (l == 0 || this.tree == null) {
            super.drawAllObjectsOfLayer(l, g, r, scale);
        } else {
            this.wQuery = new RegionQuery(new LayerScaleWindowQuery(l, scale));
            this.wQuery.initWithRect(this.tree, new MBR(r));
            DrawableSpatialSearchTreeObject obj = (DrawableSpatialSearchTreeObject)this.wQuery.getNextObject();
            while (obj != null) {
                Drawable prim = obj.getDrawable();
                prim.draw(g, r, scale);
                obj = (DrawableSpatialSearchTreeObject)this.wQuery.getNextObject();
            }
        }
    }

    public Drawable findNearestDrawable(int x, int y, Drawable prim, SpatialSearchTreeObject typeObject) {
        if (this.tree != null) {
            int[] point = new int[]{x, y};
            this.nnQuery.initWithPoint(this.tree, point, -1, -1, typeObject, 0, prim == null ? null : new DrawableSpatialSearchTreeObject(prim));
            DrawableSpatialSearchTreeObject obj = (DrawableSpatialSearchTreeObject)this.nnQuery.getNearestObject();
            if (obj == null) {
                return null;
            }
            return obj.getDrawable();
        }
        return super.findNearestDrawable(x, y);
    }

    public Rectangle getDataspace() {
        if (this.tree != null) {
            return this.tree.getRoot().getMBR().extractRectangle(0, 1);
        }
        return super.getDataspace();
    }

    public Drawable getNextDrawable(Drawable prevPrim) {
        if (this.tree == null) {
            return super.getNextDrawable(prevPrim);
        }
        DrawableSpatialSearchTreeObject obj = (DrawableSpatialSearchTreeObject)this.pQuery.getNextObject();
        if (obj == null) {
            return null;
        }
        return obj.getDrawable();
    }

    public DrawableObject getNextVisibleIntersectingObject(int px, int py, int scale, boolean selectable) {
        if (this.tree != null) {
            int[] point = new int[]{px, py};
            SelectQuery sQuery = new SelectQuery(scale);
            sQuery.setTolerance(2 * scale);
            this.pQuery = new RegionQuery(sQuery);
            this.pQuery.initWithPoint(this.tree, point);
        }
        this.visibleDrawable = this.getNextDrawable(this.visibleDrawable);
        boolean firstSearch = true;
        while (true) {
            if (this.visibleDrawable == null) {
                if (firstSearch) {
                    if (this.tree != null) {
                        this.pQuery.reset();
                    }
                    this.visibleDrawable = this.getNextDrawable(null);
                    firstSearch = false;
                    continue;
                }
                return null;
            }
            if (this.visibleDrawable.isVisible(scale) && this.visibleDrawable.getObject() != null && this.visibleDrawable.getObject().getName() != null && this.visibleDrawable.getObject().getName().length() > 0 && (!selectable || this.visibleDrawable.getPresentation(scale, this.mode, this.visibleDrawable.getObject().getPresValue()).getSelectability()) && this.visibleDrawable.interacts(px, py, scale)) {
                return this.visibleDrawable.getObject();
            }
            this.visibleDrawable = this.getNextDrawable(this.visibleDrawable);
        }
    }

    public int getNumberOfObjects() {
        if (this.tree != null && this.tree.getClass().getName().equals("spatial.MemoryRTree")) {
            return ((MemoryRTree)this.tree).getTotalNumberOfObjects();
        }
        return super.getNumberOfObjects();
    }

    public void remove(DrawableObject obj) {
        if (obj == null) {
            return;
        }
        super.remove(obj);
        if (this.tree != null) {
            int i = 0;
            while (i < obj.getNumberOfDrawables()) {
                this.tree.remove(new DrawableSpatialSearchTreeObject(obj.getDrawable(i)));
                ++i;
            }
        }
    }

    public void removeAll() {
        super.removeAll();
        if (this.tree != null) {
            this.tree = new MemoryRTree();
        }
    }

    public void removeAllObjectsOfLayer(int l) {
        super.removeAllObjectsOfLayer(l);
        if (this.tree != null) {
            RegionQuery rlQuery = new RegionQuery(new LayerAllQuery(l));
            rlQuery.init(this.tree, 2);
            rlQuery.getNextObject();
        }
    }
}

