/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import util.EntryInput;
import util.EntryReadable;

public class DrawableObjectType
implements EntryReadable {
    private String name = null;
    private int numOfAttributes = 0;
    private String[] attrName = null;
    private String[] attrType = null;
    private DrawableObjectType next = null;
    private static char termChar = (char)124;
    private static DrawableObjectType first = new DrawableObjectType("default");

    public DrawableObjectType() {
        this.name = "unknown";
    }

    private DrawableObjectType(String name) {
        this.name = name;
    }

    public DrawableObjectType(String name, int numOfAttributes, String[] attrNames, String[] attrTypes) {
        this.name = name;
        this.numOfAttributes = numOfAttributes;
        this.attrName = attrNames;
        this.attrName = attrTypes;
    }

    public static DrawableObjectType findObjectType(String name) {
        return DrawableObjectType.getObjectType(name, false);
    }

    public int getAttributeAsInteger(int i, String attributes) throws NumberFormatException {
        return new Integer(this.getAttributeAsString(i, attributes));
    }

    public String getAttributeAsString(int i, String attributes) {
        if (attributes == null || attributes.length() == 0) {
            return null;
        }
        int first = 0;
        int last = attributes.indexOf(termChar);
        while (i > 0 && last > 0) {
            first = last + 1;
            last = attributes.indexOf(termChar, first);
            --i;
        }
        if (last < 0) {
            last = attributes.length();
        }
        return attributes.substring(first, last);
    }

    public String getAttributeName(int i) {
        try {
            return this.attrName[i];
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getAttributeType(int i) {
        try {
            return this.attrType[i];
        }
        catch (Exception e) {
            return "";
        }
    }

    public static DrawableObjectType getDefaultType() {
        return first;
    }

    public String getName() {
        return this.name;
    }

    public int getNumOfAttributes() {
        return this.numOfAttributes;
    }

    public static DrawableObjectType getObjectType(String name) {
        return DrawableObjectType.getObjectType(name, true);
    }

    private static DrawableObjectType getObjectType(String name, boolean create) {
        DrawableObjectType type = first;
        while (type != null) {
            if (type.name.compareTo(name) == 0) {
                return type;
            }
            if (type.next == null && create) {
                type.next = new DrawableObjectType(name);
                return type.next;
            }
            type = type.next;
        }
        return null;
    }

    public EntryReadable read(EntryInput r) {
        String newName = r.readString();
        DrawableObjectType foundType = DrawableObjectType.findObjectType(newName);
        if (foundType == null) {
            foundType = this;
        }
        foundType.name = this.name;
        foundType.numOfAttributes = r.readInt();
        foundType.attrName = new String[foundType.numOfAttributes];
        foundType.attrType = new String[foundType.numOfAttributes];
        int i = 0;
        while (i < this.numOfAttributes) {
            foundType.attrName[i] = r.readString();
            foundType.attrType[i] = r.readString();
            ++i;
        }
        return foundType;
    }

    public static void setTerminatingChar(char c) {
        termChar = c;
    }
}

