/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public class OracleOCIConnection
extends OracleConnection {
    public static final String NEW_PASSWORD = "OCINewPassword";
    private OracleOCIConnectionPool m_connection_pool = null;
    private boolean m_is_pool = false;
    private boolean m_aliasing = false;

    public OracleOCIConnection(DBAccess dBAccess, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        super(dBAccess, string, string2, string3, string4, properties);
    }

    public synchronized void close() throws SQLException {
        if (this.closed || this.m_aliasing) {
            return;
        }
        super.close();
        this.m_connection_pool.connectionClosed(this);
    }

    public synchronized byte[] getConnectionId() throws SQLException {
        byte[] byArray = ((OCIDBAccess)this.db_access).getConnectionId();
        this.m_aliasing = true;
        return byArray;
    }

    public synchronized void passwordChange(String string, String string2, String string3) throws SQLException, IOException {
        Properties properties = new Properties();
        ((Hashtable)properties).put(NEW_PASSWORD, string3);
        this.db_access.logon(string, string2, this.database, properties);
    }

    public synchronized void setConnectionPool(OracleOCIConnectionPool oracleOCIConnectionPool) {
        this.m_connection_pool = oracleOCIConnectionPool;
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        super.setStmtCacheSize(n, bl);
    }
}

